/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.memory;

import java.nio.BufferOverflowException;
import net.dongliu.direct.memory.UnsafeMemory;

public abstract class MemoryBuffer {
    private int size;

    protected MemoryBuffer() {
    }

    public void write(byte[] data) {
        if (data.length > this.capacity()) {
            throw new BufferOverflowException();
        }
        this.size = data.length;
        this.getMemory().write(this.getOffset(), data);
    }

    public byte[] toBytes() {
        byte[] buf = new byte[this.size];
        this.getMemory().read(this.getOffset(), buf);
        return buf;
    }

    public abstract int capacity();

    public int size() {
        return this.size;
    }

    public abstract int getOffset();

    public abstract UnsafeMemory getMemory();

    public abstract void dispose();
}

