/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.cache;

import net.dongliu.direct.cache.DirectCache;
import net.dongliu.direct.utils.Size;

public class DirectCacheBuilder {
    private int concurrency = 256;
    private int initialSize = 1024;
    private float loadFactor = 0.75f;
    private int chunkSize = 48;
    private float expandFactor = 1.25f;
    private long maxMemorySize = Size.Gb(1.0);
    private int slabSize = Size.Mb(4.0);

    DirectCacheBuilder() {
    }

    public DirectCacheBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public DirectCacheBuilder initialSize(int initialSize) {
        this.initialSize = initialSize;
        return this;
    }

    public DirectCacheBuilder loadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
        return this;
    }

    public DirectCacheBuilder chunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    public DirectCacheBuilder slabSize(int slabSize) {
        this.slabSize = slabSize;
        return this;
    }

    public DirectCacheBuilder expandFactor(float expandFactor) {
        this.expandFactor = expandFactor;
        return this;
    }

    public DirectCacheBuilder maxMemorySize(long maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
        return this;
    }

    public DirectCache build() {
        return new DirectCache(this.maxMemorySize, this.expandFactor, this.chunkSize, this.slabSize, this.initialSize, this.loadFactor, this.concurrency);
    }
}

