/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.dongliu.direct.cache.ConcurrentMap;
import net.dongliu.direct.cache.DirectCacheBuilder;
import net.dongliu.direct.exception.CacheException;
import net.dongliu.direct.exception.DeSerializeException;
import net.dongliu.direct.exception.SerializeException;
import net.dongliu.direct.memory.Allocator;
import net.dongliu.direct.memory.MemoryBuffer;
import net.dongliu.direct.memory.slabs.SlabsAllocator;
import net.dongliu.direct.serialization.ValueSerializer;
import net.dongliu.direct.struct.ValueHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectCache {
    private static final Logger logger = LoggerFactory.getLogger(DirectCache.class);
    private ConcurrentMap map;
    private final Allocator allocator;
    private static final int MAX_EVICTION_RATIO = 10;
    private static final int DEFAULT_SAMPLE_SIZE = 30;

    public static DirectCacheBuilder newBuilder() {
        return new DirectCacheBuilder();
    }

    DirectCache(long maxSize, float expandFactor, int chunkSize, int slabSize, int initialSize, float loadFactor, int concurrency) {
        this.allocator = new SlabsAllocator(maxSize, expandFactor, chunkSize, slabSize);
        this.map = new ConcurrentMap(initialSize, loadFactor, concurrency);
    }

    public <T> T get(Object key, ValueSerializer<T> serializer) {
        byte[] bytes = this.get(key);
        if (bytes == null) {
            return null;
        }
        try {
            return serializer.deserialize(bytes);
        }
        catch (DeSerializeException e) {
            throw new CacheException("deserialize value failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(Object key) {
        ReentrantReadWriteLock lock = this.lockFor(key);
        lock.readLock().lock();
        byte[] bytes = null;
        try {
            ValueHolder holder = this.map.get(key);
            if (holder == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (!holder.expired()) {
                bytes = holder.readValue();
            }
        }
        finally {
            lock.readLock().unlock();
        }
        if (bytes == null) {
            this.removeExpiredEntry(key);
        }
        return bytes;
    }

    public <T> void set(Object key, T value, ValueSerializer<T> serializer) {
        this.set(key, value, serializer, 0);
    }

    public <T> void set(Object key, T value, ValueSerializer<T> serializer, int expiry) {
        byte[] bytes;
        try {
            bytes = serializer.serialize(value);
        }
        catch (SerializeException e) {
            throw new CacheException("serialize value failed", e);
        }
        this.set(key, bytes, expiry);
    }

    public void set(Object key, byte[] value) {
        this.set(key, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object key, byte[] value, int expiry) {
        ValueHolder holder = this.store(key, value);
        ReentrantReadWriteLock lock = this.lockFor(key);
        lock.writeLock().lock();
        try {
            if (holder != null) {
                if (expiry > 0) {
                    holder.expiry(expiry);
                }
                this.map.put(key, holder);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public <T> boolean add(Object key, T value, ValueSerializer<T> serializer) {
        return this.add(key, value, serializer, 0);
    }

    public <T> boolean add(Object key, T value, ValueSerializer<T> serializer, int expiry) {
        byte[] bytes;
        ValueHolder oldValueHolder = this.map.get(key);
        if (oldValueHolder != null && !oldValueHolder.expired()) {
            return false;
        }
        try {
            bytes = serializer.serialize(value);
        }
        catch (SerializeException e) {
            throw new CacheException("serialize value failed", e);
        }
        return this.add(key, bytes, expiry);
    }

    private boolean add(Object key, byte[] bytes) {
        return this.add(key, bytes, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object key, byte[] value, int expiry) {
        ValueHolder oldValueHolder = this.map.get(key);
        if (oldValueHolder != null && !oldValueHolder.expired()) {
            return false;
        }
        ValueHolder holder = this.store(key, value);
        ReentrantReadWriteLock lock = this.lockFor(key);
        lock.writeLock().lock();
        try {
            oldValueHolder = this.map.get(key);
            if (oldValueHolder != null && !oldValueHolder.expired()) {
                boolean bl = false;
                return bl;
            }
            if (holder != null) {
                holder.expiry(expiry);
                oldValueHolder = this.map.putIfAbsent(key, holder);
            }
            boolean bl = oldValueHolder == null;
            return bl;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public boolean exists(Object key) {
        return this.map.containsKey(key);
    }

    public Collection<Object> keys() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredEntry(Object key) {
        ReentrantReadWriteLock lock = this.lockFor(key);
        lock.writeLock().lock();
        try {
            ValueHolder newHolder = this.map.get(key);
            if (newHolder != null && newHolder.expired()) {
                this.map.remove(key);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public void destroy() {
        this.map.clear();
        this.allocator.destroy();
        logger.debug("Cache closed");
    }

    public long size() {
        return this.map.quickSize();
    }

    public void remove(Object key) {
        this.map.remove(key);
    }

    private ValueHolder store(Object key, byte[] bytes) {
        MemoryBuffer buffer = this.allocator.allocate(bytes.length);
        if (buffer == null) {
            this.lruEvict(key);
            buffer = this.allocator.allocate(bytes.length);
        }
        if (buffer == null) {
            return null;
        }
        buffer.write(bytes);
        ValueHolder holder = new ValueHolder(buffer);
        holder.setKey(key);
        return holder;
    }

    public long offHeapSize() {
        return this.allocator.actualUsed();
    }

    private void lruEvict(Object key) {
        int evict = 10;
        if (this.allocator.getCapacity() < this.allocator.used()) {
            for (int i = 0; i < evict; ++i) {
                this.removeChosenElements(key);
            }
        }
    }

    private void removeChosenElements(Object key) {
        ValueHolder holder = this.findEvictionCandidate(key);
        if (holder == null) {
            logger.debug("Eviction selection miss. Selected element is null");
            return;
        }
        if (holder.expired()) {
            this.remove(holder.getKey());
            this.notifyExpiry(holder);
        } else {
            this.remove(holder);
        }
    }

    private ValueHolder findEvictionCandidate(Object key) {
        ValueHolder[] holders = this.sampleElements(key);
        if (holders.length == 0) {
            return null;
        }
        Arrays.sort(holders, new Comparator<ValueHolder>(){

            @Override
            public int compare(ValueHolder o1, ValueHolder o2) {
                if (o1.expired() && o2.expired()) {
                    return 0;
                }
                if (o1.expired()) {
                    return -1;
                }
                if (o2.expired()) {
                    return 1;
                }
                return (int)(o1.lastUpdate() - o2.lastUpdate());
            }
        });
        return holders[0];
    }

    private ValueHolder[] sampleElements(Object keyHint) {
        int size = Math.min(this.map.quickSize(), 30);
        return this.map.getRandomValues(size, keyHint);
    }

    private void notifyExpiry(ValueHolder holder) {
    }

    private ReentrantReadWriteLock lockFor(Object key) {
        return this.map.lockFor(key);
    }
}

