/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.cache;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.dongliu.direct.struct.ValueHolder;

class ConcurrentMap {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MAX_SEGMENTS = 65536;
    private static final int RETRIES_BEFORE_LOCK = 2;
    private final int segmentMask;
    private final int segmentShift;
    private final Segment[] segments;
    private final Random random = new Random();
    private Set<Object> keySet;
    private Set<Map.Entry<Object, ValueHolder>> entrySet;
    private Collection<ValueHolder> values;

    public ConcurrentMap(int initialCapacity, float loadFactor, int concurrency) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrency <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrency > 65536) {
            concurrency = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrency; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment(cap, loadFactor);
        }
    }

    public ValueHolder[] getRandomValues(int size, Object keyHint) {
        ArrayList<ValueHolder> sampled = new ArrayList<ValueHolder>(size * 2);
        int randomHash = this.random.nextInt();
        int segmentStart = keyHint == null ? randomHash >>> this.segmentShift & this.segmentMask : ConcurrentMap.hash(keyHint.hashCode()) >>> this.segmentShift & this.segmentMask;
        int segmentIndex = segmentStart;
        do {
            int tableStart;
            HashEntry[] table = this.segments[segmentIndex].table;
            int tableIndex = tableStart = randomHash & table.length - 1;
            do {
                HashEntry e = table[tableIndex];
                while (e != null) {
                    ValueHolder value = e.value;
                    if (value != null) {
                        sampled.add(value);
                    }
                    e = e.next;
                }
                if (sampled.size() < size) continue;
                return sampled.toArray(new ValueHolder[sampled.size()]);
            } while ((tableIndex = tableIndex + 1 & table.length - 1) != tableStart);
        } while ((segmentIndex = segmentIndex + 1 & this.segmentMask) != segmentStart);
        return sampled.toArray(new ValueHolder[sampled.size()]);
    }

    public Object storedObject(ValueHolder e) {
        return new HashEntry(null, 0, null, e);
    }

    public int quickSize() {
        Segment[] segments = this.segments;
        long sum = 0L;
        for (Segment seg : segments) {
            sum += (long)seg.count;
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public boolean isEmpty() {
        int i;
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Segment[] segments = this.segments;
        for (int k = 0; k < 2; ++k) {
            int i;
            int[] mc = new int[segments.length];
            long check = 0L;
            long sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check != sum) continue;
            if (sum > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)sum;
        }
        long sum = 0L;
        for (Segment segment : segments) {
            segment.readLock().lock();
        }
        try {
            for (Segment segment : segments) {
                sum += (long)segment.count;
            }
        }
        finally {
            for (Segment segment : segments) {
                segment.readLock().unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    public ReentrantReadWriteLock lockFor(Object key) {
        int hash = ConcurrentMap.hash(key.hashCode());
        return this.segmentFor(hash);
    }

    public ReentrantReadWriteLock[] locks() {
        return this.segments;
    }

    public ValueHolder get(Object key) {
        int hash = ConcurrentMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    public boolean containsKey(Object key) {
        int hash = ConcurrentMap.hash(key.hashCode());
        return this.segmentFor(hash).containsKey(key, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            boolean sum = false;
            int mcsum = 0;
            for (int i = 0; i < segments.length; ++i) {
                int c = segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                if (!segments[i].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments.length; ++i) {
                    int c = segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment segment : segments) {
            segment.readLock().lock();
        }
        try {
            for (Segment segment : segments) {
                if (!segment.containsValue(value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            for (Segment segment : segments) {
                segment.readLock().unlock();
            }
        }
        return false;
    }

    public ValueHolder put(Object key, ValueHolder ValueHolder2) {
        int hash = ConcurrentMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, ValueHolder2, false);
    }

    public ValueHolder putIfAbsent(Object key, ValueHolder ValueHolder2) {
        int hash = ConcurrentMap.hash(key.hashCode());
        return this.segmentFor(hash).put(key, hash, ValueHolder2, true);
    }

    public ValueHolder remove(Object key) {
        int hash = ConcurrentMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    public boolean remove(Object key, Object value) {
        int hash = ConcurrentMap.hash(key.hashCode());
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    public Set<Object> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection<ValueHolder> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set<Map.Entry<Object, ValueHolder>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    protected Segment createSegment(int initialCapacity, float lf) {
        return new Segment(initialCapacity, lf);
    }

    public boolean evict() {
        return this.getRandomSegment().evict();
    }

    private Segment getRandomSegment() {
        int randomHash = this.random.nextInt();
        return this.segments[randomHash >>> this.segmentShift & this.segmentMask];
    }

    protected final Segment segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    protected final List<Segment> segments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    protected static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = ConcurrentMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    abstract class HashEntryIterator
    extends HashIterator {
        private HashEntry myNextEntry = this.advanceToNextEntry();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        @Override
        public HashEntry nextEntry() {
            if (this.myNextEntry == null) {
                throw new NoSuchElementException();
            }
            HashEntry entry = this.myNextEntry;
            this.myNextEntry = this.advanceToNextEntry();
            return entry;
        }

        @Override
        public boolean hasNext() {
            return this.myNextEntry != null;
        }

        private HashEntry advanceToNextEntry() {
            HashEntry myEntry = null;
            while (super.hasNext() && (myEntry = super.nextEntry()) == null) {
            }
            return myEntry;
        }
    }

    final class EntryIterator
    extends HashEntryIterator
    implements Iterator<Map.Entry<Object, ValueHolder>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<Object, ValueHolder> next() {
            HashEntry entry = this.nextEntry();
            final Object key = entry.key;
            final ValueHolder value = entry.value;
            return new Map.Entry<Object, ValueHolder>(){

                @Override
                public Object getKey() {
                    return key;
                }

                @Override
                public ValueHolder getValue() {
                    return value;
                }

                @Override
                public ValueHolder setValue(ValueHolder value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    final class ValueIterator
    extends HashEntryIterator
    implements Iterator<ValueHolder> {
        ValueIterator() {
        }

        @Override
        public ValueHolder next() {
            return this.nextEntry().value;
        }
    }

    class KeyIterator
    extends HashEntryIterator
    implements Iterator<Object> {
        KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().key;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<Object, ValueHolder>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Object, ValueHolder>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return ConcurrentMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            ValueHolder v = ConcurrentMap.this.get(e.getKey());
            return v != null && v.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return ConcurrentMap.this.remove(e.getKey(), e.getValue());
        }

        @Override
        public void clear() {
            ConcurrentMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Map.Entry<Object, ValueHolder>> c = new ArrayList<Map.Entry<Object, ValueHolder>>();
            for (Map.Entry<Object, ValueHolder> object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Map.Entry<Object, ValueHolder>> c = new ArrayList<Map.Entry<Object, ValueHolder>>();
            for (Map.Entry<Object, ValueHolder> object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    final class Values
    extends AbstractCollection<ValueHolder> {
        Values() {
        }

        @Override
        public Iterator<ValueHolder> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<ValueHolder> c = new ArrayList<ValueHolder>();
            for (ValueHolder object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<ValueHolder> c = new ArrayList<ValueHolder>();
            for (ValueHolder object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    final class KeySet
    extends AbstractSet<Object> {
        KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return ConcurrentMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            ArrayList<Object> c = new ArrayList<Object>();
            for (Object object : this) {
                c.add(object);
            }
            return c.toArray(a);
        }
    }

    private class SegmentIterator
    implements Iterator<HashEntry> {
        int nextTableIndex = -1;
        HashEntry[] currentTable;
        HashEntry nextEntry;
        HashEntry lastReturned;
        private final Segment seg;

        private SegmentIterator(Segment memoryStoreSegment) {
            this.seg = memoryStoreSegment;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public HashEntry next() {
            if (this.nextEntry == null) {
                return null;
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            if (this.seg.count != 0) {
                this.currentTable = this.seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }
    }

    public static class HashEntry {
        public final Object key;
        public final int hash;
        public final HashEntry next;
        public volatile ValueHolder value;

        protected HashEntry(Object key, int hash, HashEntry next, ValueHolder value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }
    }

    public class Segment
    extends ReentrantReadWriteLock {
        private static final int MAX_EVICTION = 5;
        protected volatile int count;
        int modCount;
        int threshold;
        protected volatile HashEntry[] table;
        final float loadFactor;
        private Iterator<HashEntry> evictionIterator = this.iterator();

        protected Segment(int initialCapacity, float lf) {
            this.loadFactor = lf;
            this.setTable(new HashEntry[initialCapacity]);
        }

        void postRemove(ValueHolder vh) {
            vh.dispose();
        }

        void preInstall(Object key, ValueHolder value) {
        }

        void setTable(HashEntry[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        protected HashEntry getFirst(int hash) {
            HashEntry[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        protected HashEntry createHashEntry(Object key, int hash, HashEntry next, ValueHolder value) {
            return new HashEntry(key, hash, next, value);
        }

        protected HashEntry relinkHashEntry(HashEntry e, HashEntry next) {
            return new HashEntry(e.key, e.hash, next, e.value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clear() {
            this.writeLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        HashEntry entry = tab[i];
                        tab[i] = null;
                        if (entry == null) continue;
                        this.postRemove(entry.value);
                    }
                    ++this.modCount;
                    this.count = 0;
                }
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ValueHolder remove(Object key, int hash, Object value) {
            this.writeLock().lock();
            try {
                HashEntry first;
                int c = this.count - 1;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                ValueHolder oldValue = null;
                if (e != null) {
                    ValueHolder v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry p = first;
                        while (p != e) {
                            newFirst = this.relinkHashEntry(p, newFirst);
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                        this.postRemove(e.value);
                    }
                }
                ValueHolder valueHolder = oldValue;
                return valueHolder;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ValueHolder put(Object key, int hash, ValueHolder value, boolean onlyIfAbsent) {
            this.writeLock().lock();
            try {
                ValueHolder oldValue;
                HashEntry first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    oldValue = e.value;
                    if (!onlyIfAbsent) {
                        this.preInstall(key, value);
                        e.value = value;
                    }
                    this.postRemove(oldValue);
                } else {
                    oldValue = null;
                    this.preInstall(key, value);
                    ++this.modCount;
                    tab[index] = this.createHashEntry(key, hash, first, value);
                    this.count = c;
                }
                ValueHolder valueHolder = oldValue;
                return valueHolder;
            }
            finally {
                this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ValueHolder get(Object key, int hash) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && key.equals(e.key)) {
                            ValueHolder valueHolder = e.value;
                            return valueHolder;
                        }
                        e = e.next;
                    }
                }
                ValueHolder valueHolder = null;
                return valueHolder;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(Object key, int hash) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry e = this.getFirst(hash);
                    while (e != null) {
                        if (e.hash == hash && key.equals(e.key)) {
                            boolean bl = true;
                            return bl;
                        }
                        e = e.next;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsValue(Object value) {
            this.readLock().lock();
            try {
                if (this.count != 0) {
                    HashEntry[] tab;
                    HashEntry[] hashEntryArray = tab = this.table;
                    int n = hashEntryArray.length;
                    for (int i = 0; i < n; ++i) {
                        HashEntry aTab;
                        HashEntry e = aTab = hashEntryArray[i];
                        while (e != null) {
                            ValueHolder v = e.value;
                            if (value.equals(v)) {
                                boolean bl = true;
                                return bl;
                            }
                            e = e.next;
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readLock().unlock();
            }
        }

        private ValueHolder nextExpiredOrToEvict(ValueHolder justAdded) {
            if (!this.evictionIterator.hasNext()) {
                this.evictionIterator = this.iterator();
            }
            HashEntry next = this.evictionIterator.next();
            return next.value;
        }

        protected Iterator<HashEntry> iterator() {
            return new SegmentIterator(this);
        }

        private boolean evict() {
            ValueHolder remove = null;
            this.writeLock().lock();
            try {
                ValueHolder evict = this.nextExpiredOrToEvict(null);
                if (evict != null) {
                    remove = this.remove(evict.getKey(), ConcurrentMap.hash(evict.getKey().hashCode()), null);
                }
            }
            finally {
                this.writeLock().unlock();
            }
            return remove != null;
        }

        void rehash() {
            HashEntry[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry[] newTable = new HashEntry[oldCapacity << 1];
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (HashEntry e : oldTable) {
                int k;
                if (e == null) continue;
                HashEntry next = e.next;
                int idx = e.hash & sizeMask;
                if (next == null) {
                    newTable[idx] = e;
                    continue;
                }
                HashEntry lastRun = e;
                int lastIdx = idx;
                HashEntry last = next;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry p = e;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = this.relinkHashEntry(p, n);
                    p = p.next;
                }
            }
            this.table = newTable;
        }
    }
}

