/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client.transport;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dona.doip.DoipResponseHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipMessageFromJson;

public class DoipClientResponse
implements AutoCloseable {
    private final DoipResponseHeaders initialSegment;
    private final InDoipMessage in;
    private Runnable onClose;

    public DoipClientResponse(DoipResponseHeaders initialSegment, InDoipMessage in) {
        this.initialSegment = initialSegment;
        this.in = in;
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    public String getStatus() {
        return this.initialSegment.status;
    }

    public JsonObject getAttributes() {
        return this.initialSegment.attributes;
    }

    public JsonElement getAttribute(String key) {
        return this.initialSegment.attributes.get(key);
    }

    public String getAttributeAsString(String key) {
        return this.initialSegment.attributes.get(key).getAsString();
    }

    public InDoipMessage getOutput() {
        if (this.initialSegment.output != null) {
            return new InDoipMessageFromJson(this.initialSegment.output);
        }
        return this.in;
    }

    @Override
    public void close() {
        if (this.in != null) {
            this.in.close();
        }
        if (this.onClose != null) {
            this.onClose.run();
        }
    }
}

