/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class DoipException
extends Exception {
    private final String statusCode;
    private final JsonElement response;

    public DoipException(String message) {
        super(message);
        this.statusCode = null;
        this.response = DoipException.responseForMessage(message);
    }

    public DoipException(JsonElement response) {
        super(DoipException.messageForResponse(response));
        this.statusCode = null;
        this.response = response;
    }

    public DoipException(String statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
        this.response = DoipException.responseForMessage(message);
    }

    public DoipException(String statusCode, JsonElement response) {
        super(DoipException.messageForResponse(response));
        this.statusCode = statusCode;
        this.response = response;
    }

    public DoipException(Throwable cause) {
        super(cause);
        this.statusCode = null;
        this.response = null;
    }

    public DoipException(String statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.response = DoipException.responseForMessage(message);
    }

    public DoipException(String statusCode, JsonElement response, Throwable cause) {
        super(DoipException.messageForResponse(response), cause);
        this.statusCode = statusCode;
        this.response = response;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public JsonElement getResponse() {
        return this.response;
    }

    public static String messageForResponse(JsonElement response) {
        if (response == null || response.isJsonNull()) {
            return null;
        }
        try {
            if (response.isJsonObject()) {
                return response.getAsJsonObject().get("message").getAsString();
            }
            if (response.isJsonPrimitive()) {
                return response.getAsString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JsonElement responseForMessage(String message) {
        if (message == null) {
            return null;
        }
        JsonObject res = new JsonObject();
        res.addProperty("message", message);
        return res;
    }
}

