/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.client.AuthenticationInfo;
import net.dona.doip.client.DigitalObject;
import net.dona.doip.client.DoipException;
import net.dona.doip.client.QueryParams;
import net.dona.doip.client.SearchResults;
import net.dona.doip.client.ServiceInfo;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.util.ErrorMessageUtil;

public interface DoipClientInterface
extends AutoCloseable {
    public static DoipException doipExceptionFromDoipResponse(DoipClientResponse resp) throws IOException {
        JsonElement response = ErrorMessageUtil.getJsonResponseFromErrorResponse(resp);
        DoipException e = new DoipException(resp.getStatus(), response);
        return e;
    }

    @Override
    public void close();

    public JsonElement performOperationWithJsonResponse(String var1, String var2, AuthenticationInfo var3, JsonObject var4) throws DoipException;

    public JsonElement performOperationWithJsonResponse(String var1, String var2, AuthenticationInfo var3, JsonObject var4, ServiceInfo var5) throws DoipException;

    public JsonElement performOperationWithJsonResponse(String var1, String var2, AuthenticationInfo var3, JsonObject var4, JsonElement var5, ServiceInfo var6) throws DoipException;

    public DoipClientResponse performOperation(String var1, String var2, AuthenticationInfo var3, JsonObject var4) throws DoipException;

    public DoipClientResponse performOperation(String var1, String var2, AuthenticationInfo var3, JsonObject var4, JsonElement var5) throws DoipException;

    public DoipClientResponse performOperation(String var1, String var2, AuthenticationInfo var3, JsonObject var4, InDoipMessage var5) throws DoipException;

    public DoipClientResponse performOperation(String var1, String var2, AuthenticationInfo var3, JsonObject var4, ServiceInfo var5) throws DoipException;

    public DoipClientResponse performOperation(String var1, String var2, AuthenticationInfo var3, JsonObject var4, JsonElement var5, ServiceInfo var6) throws DoipException;

    public DoipClientResponse performOperation(String var1, String var2, AuthenticationInfo var3, JsonObject var4, InDoipMessage var5, ServiceInfo var6) throws DoipException;

    public DoipClientResponse performOperation(DoipRequestHeaders var1, InDoipMessage var2) throws DoipException;

    public DoipClientResponse performOperation(DoipRequestHeaders var1, InDoipMessage var2, ServiceInfo var3) throws DoipException;

    public DigitalObject create(DigitalObject var1, AuthenticationInfo var2, ServiceInfo var3) throws DoipException;

    public DigitalObject create(DigitalObject var1, AuthenticationInfo var2, ServiceInfo var3, JsonObject var4) throws DoipException;

    public DigitalObject update(DigitalObject var1, AuthenticationInfo var2) throws DoipException;

    public DigitalObject update(DigitalObject var1, AuthenticationInfo var2, ServiceInfo var3) throws DoipException;

    public DigitalObject update(DigitalObject var1, AuthenticationInfo var2, ServiceInfo var3, JsonObject var4) throws DoipException;

    public DigitalObject retrieve(String var1, AuthenticationInfo var2) throws DoipException;

    public DigitalObject retrieve(String var1, AuthenticationInfo var2, ServiceInfo var3) throws DoipException;

    public DigitalObject retrieve(String var1, boolean var2, AuthenticationInfo var3) throws DoipException;

    public DigitalObject retrieve(String var1, boolean var2, AuthenticationInfo var3, ServiceInfo var4) throws DoipException;

    public DigitalObject retrieve(String var1, JsonObject var2, AuthenticationInfo var3, ServiceInfo var4) throws DoipException;

    public void delete(String var1, AuthenticationInfo var2) throws DoipException;

    public void delete(String var1, AuthenticationInfo var2, ServiceInfo var3) throws DoipException;

    public void delete(String var1, AuthenticationInfo var2, ServiceInfo var3, JsonObject var4) throws DoipException;

    public List<String> listOperations(String var1, AuthenticationInfo var2) throws DoipException;

    public List<String> listOperations(String var1, AuthenticationInfo var2, ServiceInfo var3) throws DoipException;

    public List<String> listOperations(String var1, AuthenticationInfo var2, ServiceInfo var3, JsonObject var4) throws DoipException;

    public SearchResults<String> searchIds(String var1, String var2, QueryParams var3, AuthenticationInfo var4) throws DoipException;

    public SearchResults<String> searchIds(String var1, String var2, QueryParams var3, AuthenticationInfo var4, ServiceInfo var5) throws DoipException;

    public SearchResults<DigitalObject> search(String var1, String var2, QueryParams var3, AuthenticationInfo var4) throws DoipException;

    public SearchResults<DigitalObject> search(String var1, String var2, QueryParams var3, AuthenticationInfo var4, ServiceInfo var5) throws DoipException;

    public DigitalObject hello(String var1, AuthenticationInfo var2) throws DoipException;

    public DigitalObject hello(String var1, AuthenticationInfo var2, ServiceInfo var3) throws DoipException;

    public InputStream retrieveElement(String var1, String var2, AuthenticationInfo var3) throws DoipException;

    public InputStream retrieveElement(String var1, String var2, AuthenticationInfo var3, ServiceInfo var4) throws DoipException;

    public InputStream retrieveElement(String var1, String var2, AuthenticationInfo var3, ServiceInfo var4, JsonObject var5) throws DoipException;

    public InputStream retrievePartialElement(String var1, String var2, Long var3, Long var4, AuthenticationInfo var5) throws DoipException;

    public InputStream retrievePartialElement(String var1, String var2, Long var3, Long var4, AuthenticationInfo var5, ServiceInfo var6) throws DoipException;

    public InputStream retrievePartialElement(String var1, String var2, Long var3, Long var4, AuthenticationInfo var5, ServiceInfo var6, JsonObject var7) throws DoipException;
}

