package net.dona.doip.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.util.ErrorMessageUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public interface DoipClientInterface extends AutoCloseable {
    static DoipException doipExceptionFromDoipResponse(DoipClientResponse resp) throws IOException {
        JsonElement response = ErrorMessageUtil.getJsonResponseFromErrorResponse(resp);
        DoipException e = new DoipException(resp.getStatus(), response);
        return e;
    }

    @Override
    void close();

    JsonElement performOperationWithJsonResponse(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException;

    JsonElement performOperationWithJsonResponse(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, ServiceInfo serviceInfo) throws DoipException;

    JsonElement performOperationWithJsonResponse(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input, ServiceInfo serviceInfo) throws DoipException;

    DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException;

    DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input) throws DoipException;

    DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, InDoipMessage input) throws DoipException;

    DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, ServiceInfo serviceInfo) throws DoipException;

    DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input, ServiceInfo serviceInfo) throws DoipException;

    DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, InDoipMessage input, ServiceInfo serviceInfo) throws DoipException;

    DoipClientResponse performOperation(DoipRequestHeaders headers, InDoipMessage input) throws DoipException;

    DoipClientResponse performOperation(DoipRequestHeaders headers, InDoipMessage input, ServiceInfo serviceInfo) throws DoipException;

    DigitalObject create(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    DigitalObject create(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException;

    DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo) throws DoipException;

    DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException;

    DigitalObject retrieve(String targetId, AuthenticationInfo authInfo) throws DoipException;

    DigitalObject retrieve(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    DigitalObject retrieve(String targetId, boolean includeElementData, AuthenticationInfo authInfo) throws DoipException;

    DigitalObject retrieve(String targetId, boolean includeElementData, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    DigitalObject retrieve(String targetId, JsonObject attributes, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    void delete(String targetId, AuthenticationInfo authInfo) throws DoipException;

    void delete(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    void delete(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException;

    List<String> listOperations(String targetId, AuthenticationInfo authInfo) throws DoipException;

    List<String> listOperations(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    List<String> listOperations(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException;

    SearchResults<String> searchIds(String targetId, String query, QueryParams params, AuthenticationInfo authInfo) throws DoipException;

    SearchResults<String> searchIds(String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    SearchResults<DigitalObject> search(String targetId, String query, QueryParams params, AuthenticationInfo authInfo) throws DoipException;

    SearchResults<DigitalObject> search(String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    DigitalObject hello(String targetId, AuthenticationInfo authInfo) throws DoipException;

    DigitalObject hello(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo) throws DoipException;

    InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException;

    InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo) throws DoipException;

    InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException;

    InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException;
}
