package net.dona.doip;

/**
 * Constants useful in processing DOIP messages.
 */
public class DoipConstants {

    /** The request was processed successfully. */
    public static final String STATUS_OK = "0.DOIP/Status.001";

    /** There was something wrong with the structure or content of the request. */
    public static final String STATUS_BAD_REQUEST = "0.DOIP/Status.101";

    /** The client must authenticate to perform the attempted operation. */
    public static final String STATUS_UNAUTHENTICATED = "0.DOIP/Status.102";

    /** The client was not permitted to perform the attempted operation. */
    public static final String STATUS_FORBIDDEN = "0.DOIP/Status.103";

    /** The requested digital object could not be found. */
    public static final String STATUS_NOT_FOUND = "0.DOIP/Status.104";

    /** There was a conflict preventing the request from being executed. */
    public static final String STATUS_CONFLICT = "0.DOIP/Status.105";

    /** There was something wrong with the structure or content of the request. */
    public static final String STATUS_DECLINED = "0.DOIP/Status.200";

    /** There was an interval server error. */
    public static final String STATUS_ERROR = "0.DOIP/Status.500";

    /** Provides a target digital object provided along with this operation ID in a DOIP request. */
    public static final String OP_HELLO = "0.DOIP/Op.Hello";

    /** List operations associated with a target digital object provided along with this operation ID in a DOIP request. */
    public static final String OP_LIST_OPERATIONS = "0.DOIP/Op.ListOperations";

    /** Create a digital object. */
    public static final String OP_CREATE = "0.DOIP/Op.Create";

    /** Retrieve a digital object */
    public static final String OP_RETRIEVE = "0.DOIP/Op.Retrieve";

    /** Update a digital object. */
    public static final String OP_UPDATE = "0.DOIP/Op.Update";

    /** Delete a digital object. */
    public static final String OP_DELETE = "0.DOIP/Op.Delete";

    /** Search for digital objects. */
    public static final String OP_SEARCH = "0.DOIP/Op.Search";

    /** The key for a message in the error output of a DOIP server response. */
    public static final String MESSAGE_ATT = "message";
}
