package net.dona.doip.client;

import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.DoipConnectionPool;

import java.io.IOException;

/**
 * Used internally by {@link DoipClient} to manage pools of connections.
 */
public class ConnectionAndPool {
    private final DoipConnection connection;
    private final DoipConnectionPool pool;

    public ConnectionAndPool(DoipConnectionPool pool) throws DoipException {
        try {
            this.connection = pool.get();
        } catch (IOException ioe) {
            throw new DoipException(ioe);
        }

        this.pool = pool;
    }

    public void releaseConnection() throws InterruptedException {
        pool.release(connection);
    }

    public DoipConnection getConnection() { return connection; }
}
