package net.dona.doip.util;

import com.google.gson.JsonElement;
import net.dona.doip.DoipConstants;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipSegment;
import net.dona.doip.client.transport.DoipClientResponse;

import java.io.IOException;

public class ErrorMessageUtil {

    public static String getMessageFromErrorResponse(DoipClientResponse resp) throws IOException {
        JsonElement response = getJsonResponseFromErrorResponse(resp);
        if (response != null && response.isJsonObject() && response.getAsJsonObject().has(DoipConstants.MESSAGE_ATT)) {
            return response.getAsJsonObject().get(DoipConstants.MESSAGE_ATT).getAsString();
        }
        return "DOIP Error: " + resp.getStatus();
    }

    public static JsonElement getJsonResponseFromErrorResponse(DoipClientResponse resp) throws IOException {
        try (InDoipMessage in = resp.getOutput()) {
            if (in != null) {
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment != null) {
                    JsonElement el = firstSegment.getJson();
                    return el;
                }
            }
            return resp.getAttributes();
        }
    }
}
