package net.dona.doip;

/**
 * The initial segment of a properly formed DOIP request, including the requestId.
 * Generally it should suffice to produce a {@link DoipRequestHeaders} object and allow processing code to
 * automatically generate the requestId.
 * Can be serialized or deserialized using Gson.
 */
public class DoipRequestHeadersWithRequestId extends DoipRequestHeaders {

    /**
     * Copies the fields from the supplied request.
     *
     * @param request the initial segment except the requestId
     */
    public DoipRequestHeadersWithRequestId(DoipRequestHeaders request) {
        this.clientId = request.clientId;
        this.targetId = request.targetId;
        this.operationId = request.operationId;
        this.attributes = request.attributes;
        this.authentication = request.authentication;
        this.input = request.input;
    }

    /**
     * The requestId of the request, generally automatically generated by processing code.
     */
    public String requestId;
}
