package net.dona.doip.util;

import java.io.IOException;
import java.io.UncheckedIOException;

import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipSegment;

/**
 * Utility methods for {@link InDoipMessage}.
 */
public class InDoipMessageUtil {

    /**
     * Returns the first segment of the supplied {@link InDoipMessage}, or null
     * if it is empty.
     *
     * @param in an {@link InDoipMessage}
     * @return the first segment of the supplied {@link InDoipMessage}, or null if it is empty
     */
    public static InDoipSegment getFirstSegment(InDoipMessage in) throws IOException {
        try {
            for (InDoipSegment segment : in) {
                return segment;
            }
            return null;
        } catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    /**
     * Returns true is the supplied {@link InDoipMessage} is empty (has no segments),
     * otherwise false.
     *
     * @param in an {@link InDoipMessage}
     * @return true is the supplied {@link InDoipMessage} is empty (has no segments), otherwise false
     */
    public static boolean isEmpty(InDoipMessage in) throws IOException {
        try {
            for (@SuppressWarnings("unused") InDoipSegment segment : in) {
                return false;
            }
            return true;
        } catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}
