/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import net.handle.util.DeepClone;
import net.handle.util.StreamObject;
import net.handle.util.StreamTable;
import net.handle.util.StreamUtil;
import net.handle.util.StringEncodingException;

@Deprecated
public class StreamVector
extends Vector
implements StreamObject {
    @Override
    public boolean isStreamTable() {
        return false;
    }

    @Override
    public boolean isStreamVector() {
        return true;
    }

    public char startingDelimiter() {
        return '(';
    }

    @Override
    public void readFrom(String str) throws StringEncodingException {
        StringReader in = new StringReader(str);
        try {
            this.readFrom(in);
        }
        catch (IOException e) {
            throw new StringEncodingException("IO exception: " + e.toString());
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (Exception exception) {}
        }
    }

    public Object deepClone() {
        StreamVector newVector = new StreamVector();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            try {
                if (item instanceof DeepClone) {
                    item = ((DeepClone)item).deepClone();
                }
            }
            catch (Exception ex) {
                System.out.println("Exception cloning item in StreamVector: " + e);
            }
            newVector.addElement(item);
        }
        return newVector;
    }

    @Override
    public void readFrom(Reader str) throws StringEncodingException, IOException {
        char ch;
        while ((ch = StreamUtil.getNonWhitespace(str)) == '(') {
            this.readTheRest(str);
        }
        throw new StringEncodingException("Expected '(', got '" + ch + "'");
    }

    @Override
    public void writeTo(Writer out) throws IOException {
        out.write("(\n");
        for (int i = 0; i < this.size(); ++i) {
            Object val = this.elementAt(i);
            if (val instanceof StreamObject) {
                ((StreamObject)val).writeTo(out);
                continue;
            }
            StreamUtil.writeEncodedString(out, String.valueOf(val));
            out.write("\n");
        }
        out.write(")\n");
    }

    @Override
    public String writeToString() {
        StringWriter out = new StringWriter();
        try {
            this.writeTo(out);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return out.toString();
    }

    @Override
    public void readTheRest(Reader str) throws StringEncodingException, IOException {
        this.removeAllElements();
        while (true) {
            Object obj;
            char ch = StreamUtil.getNonWhitespace(str);
            switch (ch) {
                case '\"': {
                    obj = StreamUtil.readString(str);
                    break;
                }
                case '{': {
                    StreamTable valTable = new StreamTable();
                    valTable.readTheRest(str);
                    obj = valTable;
                    break;
                }
                case '(': {
                    StreamVector vector = new StreamVector();
                    vector.readTheRest(str);
                    obj = vector;
                    break;
                }
                case ')': {
                    return;
                }
                case '\uffff': {
                    throw new StringEncodingException("Unexpected end of input while reading Vector.");
                }
                default: {
                    obj = StreamUtil.readUndelimitedString(str, ch);
                }
            }
            this.addElement(obj);
        }
    }
}

