/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security.provider;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public final class GenericProvider
extends HdlSecurityProvider {
    private KeyGenerator aesKeygen = null;
    private KeyGenerator desKeygen = null;
    private KeyGenerator desedeKeygen = null;

    @Override
    public Cipher getCipher(int algorithm, byte[] secretKey, int direction, byte[] iv, int majorProtocolVersion, int minorProtocolVersion) throws Exception {
        SecretKey key;
        KeySpec spec;
        String cipherAlg;
        String keyAlg;
        boolean legacy = !AbstractMessage.hasEqualOrGreaterVersion(majorProtocolVersion, minorProtocolVersion, 2, 4);
        switch (algorithm) {
            case 1: {
                keyAlg = "DES";
                cipherAlg = legacy ? "DES/ECB/PKCS5Padding" : "DES/CBC/PKCS5Padding";
                spec = new DESKeySpec(secretKey);
                break;
            }
            case 3: {
                keyAlg = "AES";
                String string = cipherAlg = legacy ? "AES" : "AES/CBC/PKCS5Padding";
                if (secretKey.length > 16) {
                    secretKey = Util.substring(secretKey, 0, 16);
                }
                spec = new SecretKeySpec(secretKey, "AES");
                break;
            }
            case 2: {
                keyAlg = "DESede";
                cipherAlg = legacy ? "DESede/ECB/PKCS5Padding" : "DESede/CBC/PKCS5Padding";
                spec = new DESedeKeySpec(secretKey);
                break;
            }
            default: {
                throw new Exception("Invalid encryption algorithm code: " + algorithm);
            }
        }
        if (spec instanceof SecretKeySpec) {
            key = (SecretKeySpec)spec;
        } else {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(keyAlg);
            key = factory.generateSecret(spec);
        }
        Cipher cipher = Cipher.getInstance(cipherAlg);
        if (iv != null) {
            cipher.init(direction, (Key)key, new IvParameterSpec(iv));
        } else {
            cipher.init(direction, key);
        }
        return cipher;
    }

    @Override
    public int getIvSize(int algorithm, int majorProtocolVersion, int minorProtocolVersion) {
        boolean legacy;
        boolean bl = legacy = !AbstractMessage.hasEqualOrGreaterVersion(majorProtocolVersion, minorProtocolVersion, 2, 4);
        if (legacy) {
            return 0;
        }
        switch (algorithm) {
            case 1: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 2: {
                return 8;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateSecretKey(int keyAlg) throws Exception {
        KeyGenerator kgen = null;
        GenericProvider genericProvider = this;
        synchronized (genericProvider) {
            switch (keyAlg) {
                case 1: {
                    if (this.desKeygen == null) {
                        this.desKeygen = KeyGenerator.getInstance("DES");
                    }
                    kgen = this.desKeygen;
                    break;
                }
                case 2: {
                    if (this.desedeKeygen == null) {
                        this.desedeKeygen = KeyGenerator.getInstance("DESEDE");
                    }
                    kgen = this.desedeKeygen;
                    break;
                }
                case 3: {
                    if (this.aesKeygen == null) {
                        this.aesKeygen = KeyGenerator.getInstance("AES");
                    }
                    kgen = this.aesKeygen;
                    break;
                }
                default: {
                    throw new Exception("Invalid encryption algorithm code: " + keyAlg);
                }
            }
        }
        byte[] tmp = kgen.generateKey().getEncoded();
        byte[] encKey = new byte[tmp.length + 4];
        Encoder.writeInt(encKey, 0, keyAlg);
        System.arraycopy(tmp, 0, encKey, 4, tmp.length);
        return encKey;
    }

    @Override
    public byte[] getDESKeyFromDH(DHPublicKey pub, DHPrivateKey priv) throws Exception {
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(priv);
        ka.doPhase(pub, true);
        return this.generateSecretWithAlgorithm(ka, "DES");
    }

    @Override
    public byte[] getKeyFromDH(DHPublicKey pub, DHPrivateKey priv, int algorithm) throws Exception {
        byte[] rawKey;
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(priv);
        ka.doPhase(pub, true);
        switch (algorithm) {
            case 1: {
                String algStr = "DES";
                rawKey = this.generateSecretWithAlgorithm(ka, algStr);
                break;
            }
            case 2: {
                String algStr = "DESede";
                rawKey = this.generateSecretWithAlgorithm(ka, algStr);
                break;
            }
            case 3: {
                String algStr = "AES";
                rawKey = GenericProvider.stripLeadingZerosAndTruncate(ka.generateSecret(), 32);
                break;
            }
            default: {
                throw new Exception("Unknown algorithm code: " + algorithm);
            }
        }
        byte[] key = new byte[rawKey.length + 4];
        Encoder.writeInt(key, 0, algorithm);
        System.arraycopy(rawKey, 0, key, 4, rawKey.length);
        return key;
    }

    byte[] generateSecretWithAlgorithm(KeyAgreement ka, String algStr) throws Exception {
        byte[] key;
        byte[] raw = ka.generateSecret();
        if ("DES".equals(algStr)) {
            key = new DESKeySpec(raw).getKey();
        } else if ("DESede".equals(algStr)) {
            key = new DESedeKeySpec(raw).getKey();
        } else {
            throw new Exception("Unknown algorithm code: " + algStr);
        }
        for (int i = 0; i < key.length; ++i) {
            int b = key[i] & 0xFE;
            b |= Integer.bitCount(b) & 1 ^ 1;
            key[i] = (byte)b;
        }
        return key;
    }

    private static byte[] stripLeadingZerosAndTruncate(byte[] secret, int length) {
        int i = 0;
        while (i + length < secret.length && secret[i] == 0) {
            ++i;
        }
        return Util.substring(secret, i, i + length);
    }

    @Override
    public KeyPair generateDHKeyPair(int keySize) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
        kpg.initialize(keySize);
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }

    @Override
    public KeyPair generateDHKeyPair(BigInteger p, BigInteger g) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
        kpg.initialize(new DHParameterSpec(p, g));
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }
}

