/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleSignature;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.ChainBuilder;
import net.handle.hdllib.trust.ChainVerificationReport;
import net.handle.hdllib.trust.ChainVerifier;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleRecordTrustVerificationReport;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.IssuedSignature;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;

public class HandleRecordTrustVerifier {
    private final ChainBuilder chainBuilder;
    private final ChainVerifier chainVerifier;
    private boolean isThrowing;

    public HandleRecordTrustVerifier(HandleResolver resolver) {
        this.chainBuilder = new ChainBuilder(resolver);
        this.chainVerifier = new ChainVerifier(resolver.getConfiguration().getRootKeys());
    }

    public HandleRecordTrustVerifier(ChainBuilder chainBuilder, ChainVerifier chainVerifier) {
        this.chainBuilder = chainBuilder;
        this.chainVerifier = chainVerifier;
    }

    public void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
    }

    public boolean validateHandleRecord(HandleRecord handleRecord) throws TrustException {
        HandleRecordTrustVerificationReport report = this.validateHandleRecordReturnReport(handleRecord);
        String errorMessage = report.getErrorMessage();
        if (errorMessage == null) {
            return true;
        }
        if (this.isThrowing) {
            throw new TrustException(errorMessage);
        }
        return false;
    }

    public HandleRecordTrustVerificationReport validateHandleRecordReturnReport(HandleRecord handleRecord) {
        List<JsonWebSignature> signatures;
        HandleRecordTrustVerificationReport report = new HandleRecordTrustVerificationReport();
        List<HandleValue> valuesList = handleRecord.getValues();
        Set allValues = valuesList.stream().filter(value -> HandleRecordTrustVerifier.valueNeedsSignature(handleRecord.getHandle(), value)).map(HandleValue::getIndex).collect(Collectors.toSet());
        HashSet<Integer> donaVerifiedValues = new HashSet<Integer>();
        HashSet<Integer> localCertVerifiedValues = new HashSet<Integer>();
        try {
            signatures = this.getJsonWebSignaturesFromValues(handleRecord.getValuesAsArray());
        }
        catch (TrustException e) {
            report.exceptions.add(e);
            report.exceptionParsingSignature = true;
            return report;
        }
        if (signatures.isEmpty()) {
            report.noSignatures = true;
            return report;
        }
        for (JsonWebSignature jws : signatures) {
            List<IssuedSignature> chain;
            try {
                chain = this.chainBuilder.buildChain(jws);
            }
            catch (TrustException e) {
                report.exceptions.add(e);
                ChainVerificationReport chainReport = this.buildChainReportWhenUnableToBuildChain(handleRecord, jws);
                report.signatureReports.add(chainReport);
                continue;
            }
            ChainVerificationReport chainReport = this.chainVerifier.verifyValues(handleRecord.getHandle(), valuesList, chain);
            report.signatureReports.add(chainReport);
            boolean bl = report.requiredSignerNeeded = report.requiredSignerNeeded || chainReport.chainNeedsRequiredSigner;
            if (chainReport.canTrustAndAuthorized()) {
                donaVerifiedValues.addAll(chainReport.valuesReport.verifiedValues);
            }
            if (!chainReport.canTrustAndAuthorizedUpToRequiredSigner()) continue;
            localCertVerifiedValues.addAll(chainReport.valuesReport.verifiedValues);
        }
        report.signedValues.addAll(donaVerifiedValues);
        report.valuesSignedUpToRequiredSigner.addAll(localCertVerifiedValues);
        HashSet unsignedValues = new HashSet(allValues);
        unsignedValues.removeAll(donaVerifiedValues);
        report.unsignedValues.addAll(unsignedValues);
        HashSet valuesNotSignedUpToRequiredSigner = new HashSet(allValues);
        valuesNotSignedUpToRequiredSigner.removeAll(localCertVerifiedValues);
        report.valuesNotSignedUpToRequiredSigner.addAll(valuesNotSignedUpToRequiredSigner);
        return report;
    }

    private ChainVerificationReport buildChainReportWhenUnableToBuildChain(HandleRecord handleRecord, JsonWebSignature jws) {
        ChainVerificationReport chainReport = new ChainVerificationReport();
        chainReport.unableToBuildChain = true;
        try {
            HandleClaimsSet claims = HandleVerifier.getInstance().getHandleClaimsSet(jws);
            String issuer = claims.iss;
            ValueReference issuerValRef = ValueReference.fromString(issuer);
            HandleValue handleValue = this.chainBuilder.resolveValueReference(issuerValRef);
            if (handleValue != null) {
                PublicKey issuerPublicKey = Util.getPublicKeyFromBytes(handleValue.getData());
                chainReport.valuesReport = HandleVerifier.getInstance().verifyValues(handleRecord.getHandle(), Util.filterOnlyPublicValues(handleRecord.getValues()), jws, issuerPublicKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chainReport;
    }

    private List<JsonWebSignature> getJsonWebSignaturesFromValues(HandleValue[] newValues) throws TrustException {
        HandleValue[] hsSignatureValues = HandleRecordTrustVerifier.getSignatureValues(newValues);
        ArrayList<JsonWebSignature> signatures = new ArrayList<JsonWebSignature>();
        if (hsSignatureValues == null) {
            return signatures;
        }
        for (HandleValue hsSignatureValue : hsSignatureValues) {
            JsonWebSignature signature = JsonWebSignatureFactory.getInstance().deserialize(hsSignatureValue.getDataAsString());
            signatures.add(signature);
        }
        return signatures;
    }

    private static boolean valueNeedsSignature(String handle, HandleValue value) {
        if (value.hasType(Common.HS_SIGNATURE_TYPE)) {
            return false;
        }
        if (!value.getAnyoneCanRead()) {
            return false;
        }
        return !"0.NA/0.NA".equalsIgnoreCase(handle) || !value.hasType(HandleSignature.SIGNATURE_TYPE) && !value.hasType(HandleSignature.METADATA_TYPE);
    }

    private static HandleValue[] getSignatureValues(HandleValue[] newValues) {
        return Util.filterValues(newValues, null, Common.HS_SIGNATURE_TYPE_LIST);
    }
}

