/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.InputStream;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.cnri.util.StreamUtil;
import net.handle.hdllib.BootstrapHandles;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SimpleConfiguration
extends Configuration {
    private HandleValue[] globalValues = null;
    private SiteInfo[] globalSites = null;
    private NamespaceInfo globalNamespace = null;
    private BootstrapHandles bootstrapHandles;
    private List<PublicKey> rootKeys;
    private SiteInfo[] cacheSites = null;
    private int resolutionMethod = 0;
    private Map<String, SiteInfo[]> localSites = null;
    private boolean useCacheSitesForAll = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleConfiguration() {
        try {
            try (InputStream in = this.getClass().getResourceAsStream("/net/handle/etc/bootstrap_handles");){
                String bootstrapHandlesJson = Util.decodeString(StreamUtil.readFully((InputStream)in));
                BootstrapHandles newBootstrapHandles = (BootstrapHandles)GsonUtility.getGson().fromJson(bootstrapHandlesJson, BootstrapHandles.class);
                this.setBootstrapHandles(newBootstrapHandles);
            }
            this.localSites = new HashMap<String, SiteInfo[]>();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SiteInfo[] getGlobalSites() {
        return this.globalSites;
    }

    @Override
    public HandleValue[] getGlobalValues() {
        return this.globalValues;
    }

    @Override
    public void setGlobalSites(SiteInfo[] globalSites) {
        this.globalSites = globalSites;
        for (int i = this.globalSites.length - 1; i >= 0; --i) {
            this.globalSites[i].isRoot = true;
        }
    }

    @Override
    public NamespaceInfo getGlobalNamespace() {
        return this.globalNamespace;
    }

    @Override
    @Deprecated
    public void setGlobalValues(HandleValue[] globalValues) {
        this.globalValues = globalValues;
        this.globalNamespace = Util.getNamespaceFromValues(globalValues);
        SiteInfo[] newSites = Util.getSitesAndAltSitesFromValues(globalValues);
        if (newSites != null) {
            this.setGlobalSites(newSites);
        }
    }

    @Override
    public void persist() {
    }

    @Override
    public int getResolutionMethod() {
        return this.resolutionMethod;
    }

    @Override
    public void setResolutionMethod(int resolutionMethod) {
        this.resolutionMethod = resolutionMethod;
    }

    @Override
    public void setCacheSites(SiteInfo[] cacheSites) {
        this.cacheSites = cacheSites;
    }

    @Override
    public SiteInfo[] getCacheSites() {
        return this.cacheSites;
    }

    @Override
    public void setLocalSites(String na, SiteInfo[] sites) {
        this.localSites.put(na.toUpperCase(Locale.ENGLISH), sites);
    }

    @Override
    public SiteInfo[] getLocalSites(String na) {
        SiteInfo[] res = this.localSites.get(na.toUpperCase(Locale.ENGLISH));
        if (res == null && this.useCacheSitesForAll) {
            return this.cacheSites;
        }
        return res;
    }

    public void setUseCacheSitesForAll(boolean useCacheSitesForAll) {
        this.useCacheSitesForAll = useCacheSitesForAll;
    }

    @Override
    public List<PublicKey> getRootKeys() {
        return this.rootKeys;
    }

    @Override
    public void setRootKeys(List<PublicKey> rootKeys) {
        this.rootKeys = rootKeys;
    }

    @Override
    public BootstrapHandles getBootstrapHandles() {
        return this.bootstrapHandles;
    }

    @Override
    public void setBootstrapHandles(BootstrapHandles bootstrapHandles) {
        this.bootstrapHandles = bootstrapHandles;
        Set<SiteInfo> sites = bootstrapHandles.getSites(null);
        if (sites != null && !sites.isEmpty()) {
            this.setGlobalSites(sites.toArray(new SiteInfo[sites.size()]));
        }
        HandleRecord rootOfResolution = this.bootstrapHandles.handles.get("0.NA/0.NA");
        this.globalValues = rootOfResolution.getValuesAsArray();
        this.globalNamespace = Util.getNamespaceFromValues(rootOfResolution.getValuesAsArray());
        HandleRecord trustRoot = this.bootstrapHandles.handles.get("0.0/0.0");
        List<PublicKey> rootKeys = Util.getPublicKeysFromValues(trustRoot.getValuesAsArray());
        if (rootKeys != null && !rootKeys.isEmpty()) {
            this.setRootKeys(rootKeys);
        }
    }

    @Override
    public boolean isAutoUpdateRootInfo() {
        return true;
    }

    @Override
    public void setAutoUpdateRootInfo(boolean enabled) {
        if (!enabled) {
            throw new UnsupportedOperationException();
        }
    }
}

