/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SSLEngineHelper;
import net.handle.hdllib.Util;

public class SignedOutputStream
extends FilterOutputStream {
    private Signature sig;
    private int streamType;

    public SignedOutputStream(PrivateKey sourceKey, OutputStream out) throws HandleException, IOException {
        super(out);
        this.initializeSigned(sourceKey);
    }

    private void initializeSigned(PrivateKey sourceKey) throws HandleException, IOException {
        this.setAndWriteStreamType(0);
        byte[] hashID = Common.HASH_ALG_SHA1;
        byte[] hashIDLen = new byte[4];
        Encoder.writeInt(hashIDLen, 0, hashID.length);
        this.out.write(hashIDLen);
        this.out.write(hashID);
        try {
            this.sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashID, sourceKey.getAlgorithm()));
            this.sig.initSign(sourceKey);
        }
        catch (InvalidKeyException e) {
            throw new HandleException(10, "Error initializing SignedOutputStream", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(10, "Error initializing SignedOutputStream", e);
        }
    }

    private void setAndWriteStreamType(int streamType) throws IOException {
        this.streamType = streamType;
        byte[] streamTypeBuf = new byte[4];
        Encoder.writeInt(streamTypeBuf, 0, streamType);
        this.out.write(streamTypeBuf);
    }

    public SignedOutputStream(OutputStream out) throws IOException {
        super(out);
        this.setAndWriteStreamType(-1);
    }

    public SignedOutputStream(X509Certificate certificate, PrivateKey sourceKey, OutputStream out, Socket socket) throws HandleException, IOException {
        super(out);
        try {
            SSLContext sslContext = SSLEngineHelper.getServerSSLContext(certificate, sourceKey);
            SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(socket, socket.getRemoteSocketAddress().toString(), socket.getPort(), true);
            sslSocket.setEnabledCipherSuites(SSLEngineHelper.ENABLED_CIPHER_SUITES);
            sslSocket.setEnabledProtocols(SSLEngineHelper.ENABLED_SERVER_PROTOCOLS);
            sslSocket.setUseClientMode(false);
            this.setAndWriteStreamType(1414288128);
            out.flush();
            this.out = new BufferedOutputStream(sslSocket.getOutputStream());
        }
        catch (KeyManagementException e) {
            this.initializeSigned(sourceKey);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.streamType == 0) {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("Error updating signature", e);
            }
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.streamType == 0) {
            try {
                this.sig.update(b);
            }
            catch (SignatureException e) {
                throw new IOException("Error updating signature", e);
            }
        }
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.streamType == 0) {
            try {
                this.sig.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("Error updating signature", e);
            }
        }
        this.out.write(b, off, len);
    }

    public void signBlock() throws IOException, SignatureException {
        if (this.streamType != 0) {
            return;
        }
        byte[] lenbuf = new byte[4];
        byte[] sigBytes = this.sig.sign();
        Encoder.writeInt(lenbuf, 0, sigBytes.length);
        this.out.write(lenbuf);
        this.out.write(sigBytes);
    }
}

