/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class ServiceReferralResponse
extends AbstractResponse {
    public byte[] handle;
    public byte[][] values;

    public ServiceReferralResponse(int responseCode, byte[] handle, byte[][] values) {
        super(1, responseCode);
        this.handle = handle;
        this.values = values;
    }

    public ServiceReferralResponse(AbstractRequest req, int responseCode, byte[] handle, byte[][] clumps) throws HandleException {
        super(req, responseCode);
        this.handle = handle;
        this.values = clumps;
    }

    public HandleValue[] getHandleValues() throws HandleException {
        if (this.values == null) {
            return null;
        }
        HandleValue[] retValues = new HandleValue[this.values.length];
        for (int i = 0; i < retValues.length; ++i) {
            retValues[i] = new HandleValue();
            Encoder.decodeHandleValue(this.values[i], 0, retValues[i]);
        }
        return retValues;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(' ');
        if (this.handle == null) {
            sb.append(String.valueOf(this.handle));
        } else {
            sb.append(Util.decodeString(this.handle));
        }
        sb.append("\n");
        if (this.values != null) {
            try {
                HandleValue[] vals;
                for (HandleValue val : vals = this.getHandleValues()) {
                    sb.append("   ");
                    sb.append(String.valueOf(val));
                    sb.append('\n');
                }
            }
            catch (HandleException handleException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    @Override
    public boolean shouldEncrypt() {
        if (!this.hasEqualOrGreaterVersion(2, 8)) {
            return false;
        }
        if (this.values == null) {
            return false;
        }
        try {
            for (HandleValue value : this.getHandleValues()) {
                if (value.publicRead) continue;
                return true;
            }
        }
        catch (HandleException e) {
            return true;
        }
        return false;
    }
}

