/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Util;

public class ResolutionRequest
extends AbstractRequest {
    public byte[][] requestedTypes = null;
    public int[] requestedIndexes = null;

    public ResolutionRequest(byte[] handle, byte[][] reqTypes, int[] reqIndexes, AuthenticationInfo authInfo) {
        super(handle, 1, authInfo);
        this.requestedIndexes = reqIndexes;
        this.requestedTypes = reqTypes;
        this.authInfo = authInfo;
    }

    private String getTypesString() {
        if (this.requestedTypes == null || this.requestedTypes.length <= 0) {
            return "[ ]";
        }
        StringBuffer sb = new StringBuffer("[");
        for (byte[] requestedType : this.requestedTypes) {
            sb.append(Util.decodeString(requestedType));
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private String getIndexesString() {
        if (this.requestedIndexes == null || this.requestedIndexes.length <= 0) {
            return "[ ]";
        }
        StringBuffer sb = new StringBuffer("[");
        for (int requestedIndexe : this.requestedIndexes) {
            sb.append(requestedIndexe);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + ' ' + this.getTypesString() + ' ' + this.getIndexesString();
    }
}

