/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SiteInfo;

class HappyEyeballsResolver
implements Runnable {
    private final HandleResolver resolver;
    private final SiteInfo[] sites;
    public final AbstractRequest req;
    private final ResponseMessageCallback callback;
    private final int primaries;
    private final SiteInfo preferredPrimary;
    private final int delayMillis;
    private final CountDownLatch waitLatch;
    private final CountDownLatch siblingPreferredPrimaryLatch;
    private volatile Thread hostThread = null;
    private volatile boolean interrupted;
    public AbstractResponse resp = null;
    public HandleException publicException = null;
    public HappyEyeballsResolver siblingResolver = null;

    public HappyEyeballsResolver(HandleResolver resolver, SiteInfo[] sites, AbstractRequest req, ResponseMessageCallback callback, int primaries, SiteInfo preferredPrimary, int delayMillis, boolean mustWaitForSiblingToProcessPreferredPrimary) {
        this.resolver = resolver;
        this.sites = sites;
        this.req = req;
        this.callback = callback;
        this.primaries = primaries;
        this.preferredPrimary = preferredPrimary;
        this.delayMillis = delayMillis;
        this.waitLatch = delayMillis > 0 ? new CountDownLatch(1) : null;
        this.siblingPreferredPrimaryLatch = mustWaitForSiblingToProcessPreferredPrimary ? new CountDownLatch(1) : null;
    }

    public HappyEyeballsResolver() {
        this.resolver = null;
        this.sites = null;
        this.req = null;
        this.callback = null;
        this.primaries = 0;
        this.preferredPrimary = null;
        this.delayMillis = 0;
        this.waitLatch = null;
        this.siblingPreferredPrimaryLatch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.sites.length == 0) {
                return;
            }
            this.hostThread = Thread.currentThread();
            if (this.interrupted) {
                return;
            }
            if (this.siblingPreferredPrimaryLatch != null) {
                try {
                    this.siblingPreferredPrimaryLatch.await();
                }
                catch (InterruptedException e) {
                    if (this.siblingResolver != null) {
                        this.siblingResolver.stopWaiting();
                    }
                    HappyEyeballsResolver happyEyeballsResolver = this;
                    synchronized (happyEyeballsResolver) {
                        this.hostThread = null;
                    }
                    Thread.interrupted();
                    while (this.req.connectionLock.isHeldByCurrentThread()) {
                        this.req.connectionLock.unlock();
                    }
                    if (this.interrupted) {
                        this.resp = null;
                        this.publicException = null;
                        this.req.completed.set(false);
                    }
                    return;
                }
            }
            if (this.interrupted || this.req.completed.get()) {
                return;
            }
            if (this.delayMillis > 0) {
                try {
                    this.waitLatch.await(this.delayMillis, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    if (this.siblingResolver != null) {
                        this.siblingResolver.stopWaiting();
                    }
                    HappyEyeballsResolver happyEyeballsResolver = this;
                    synchronized (happyEyeballsResolver) {
                        this.hostThread = null;
                    }
                    Thread.interrupted();
                    while (this.req.connectionLock.isHeldByCurrentThread()) {
                        this.req.connectionLock.unlock();
                    }
                    if (this.interrupted) {
                        this.resp = null;
                        this.publicException = null;
                        this.req.completed.set(false);
                    }
                    return;
                }
            }
            if (this.interrupted || this.req.completed.get()) {
                return;
            }
            this.sendRequestAndSetResponseOrPublicException();
            if (this.resp != null && !this.interrupted && this.siblingResolver != null) {
                this.stopSibling();
            }
        }
        finally {
            if (this.siblingResolver != null) {
                this.siblingResolver.stopWaiting();
            }
            HappyEyeballsResolver happyEyeballsResolver = this;
            synchronized (happyEyeballsResolver) {
                this.hostThread = null;
            }
            Thread.interrupted();
            while (this.req.connectionLock.isHeldByCurrentThread()) {
                this.req.connectionLock.unlock();
            }
            if (this.interrupted) {
                this.resp = null;
                this.publicException = null;
                this.req.completed.set(false);
            }
        }
    }

    private void stopWaiting() {
        this.siblingPreferredPrimaryDone();
        if (this.waitLatch != null) {
            this.waitLatch.countDown();
        }
    }

    private void siblingPreferredPrimaryDone() {
        if (this.siblingPreferredPrimaryLatch != null) {
            this.siblingPreferredPrimaryLatch.countDown();
        }
    }

    private synchronized void stop() {
        Socket socket;
        this.interrupted = true;
        if (this.hostThread != null) {
            this.hostThread.interrupt();
        }
        if ((socket = this.req.socketRef.get()) != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.req.socketRef.set(null);
        }
    }

    private void stopSibling() {
        this.req.connectionLock.lock();
        try {
            if (!this.interrupted) {
                this.req.completed.set(true);
                this.siblingResolver.stop();
            }
        }
        finally {
            this.req.connectionLock.unlock();
        }
    }

    private void sendRequestAndSetResponseOrPublicException() {
        this.sendRequestToPreferredPrimary();
        if (this.resp == null && this.preferredPrimary != null && this.siblingResolver != null) {
            this.siblingResolver.siblingPreferredPrimaryDone();
        }
        if (this.resp == null && !this.interrupted) {
            this.sendRequestToSites();
        }
    }

    private void sendRequestToPreferredPrimary() {
        if (this.preferredPrimary != null && this.siblingPreferredPrimaryLatch == null) {
            for (int p = 0; p < this.resolver.preferredProtocols.length; ++p) {
                this.sendRequestToSiteViaProtocol(this.preferredPrimary, p);
                if (this.resp == null) continue;
                return;
            }
        }
    }

    private void sendRequestToSites() {
        for (int p = 0; p < this.resolver.preferredProtocols.length; ++p) {
            for (int i = 0; i < this.sites.length; ++i) {
                SiteInfo site = this.sites[i];
                if (site.servers == null || site.servers.length == 0 || !site.isPrimary && (this.req.isAdminRequest || this.req.authoritative) || site == this.preferredPrimary) continue;
                if (this.interrupted) {
                    return;
                }
                this.sendRequestToSiteViaProtocol(site, p);
                if (this.resp == null) continue;
                this.adjustResponseTimesOfUntriedSites(i);
                return;
            }
        }
    }

    private void adjustResponseTimesOfUntriedSites(int indexOfSiteMostRecentlyUsed) {
        long usedSiteResponseTime = this.sites[indexOfSiteMostRecentlyUsed].responseTime;
        long adjustment = usedSiteResponseTime / 128L;
        for (int i = indexOfSiteMostRecentlyUsed + 1; i < this.sites.length; ++i) {
            long thisSiteResponseTime;
            if (this.sites[i] == this.preferredPrimary || this.sites[i].servers.length == 0 || (thisSiteResponseTime = this.sites[i].responseTime) <= usedSiteResponseTime) continue;
            if (thisSiteResponseTime <= usedSiteResponseTime + 256L || thisSiteResponseTime <= usedSiteResponseTime * 2L) {
                if (adjustment == 0L) continue;
                this.resolver.responseTimeTbl.put(this.sites[i].servers[0].getAddressString(), this.sites[i].responseTime - adjustment);
                continue;
            }
            long thisAdjustment = (thisSiteResponseTime - usedSiteResponseTime) / 64L;
            if (thisAdjustment < adjustment) {
                thisAdjustment = adjustment;
            }
            this.resolver.responseTimeTbl.put(this.sites[i].servers[0].getAddressString(), this.sites[i].responseTime - thisAdjustment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestToSiteViaProtocol(SiteInfo site, int p) {
        block7: {
            try {
                this.resp = this.resolver.sendRequestToSite(this.req, site, this.resolver.preferredProtocols[p], this.callback);
                if (this.resp == null) break block7;
                this.setPreferredPrimaryStatus(site);
                this.publicException = null;
            }
            catch (HandleException e) {
                if (!this.interrupted) {
                    this.publicException = e;
                }
            }
            finally {
                if (this.resp != null) break block7;
                while (this.req.connectionLock.isHeldByCurrentThread()) {
                    this.req.connectionLock.unlock();
                }
            }
        }
    }

    private void setPreferredPrimaryStatus(SiteInfo site) {
        if ((this.req.isAdminRequest || this.req.authoritative) && (this.preferredPrimary != null || this.primaries > 1) && site.servers != null && site.servers.length > 0) {
            String ip;
            long now = System.currentTimeMillis();
            String ipPort = ip = site.servers[0].getAddressString();
            if (site.servers[0].interfaces != null && site.servers[0].interfaces.length > 0) {
                ipPort = ip + ":" + site.servers[0].interfaces[0].port;
            }
            this.resolver.preferredPrimaryTbl.put(ipPort, now);
        }
    }
}

