/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import net.cnri.util.FastDateFormat;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.ServiceReferralResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.VerifyAuthResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class GsonUtility {
    public static GsonBuilder setup(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(HandleValue.class, (Object)new HandleValueGsonTypeAdapter());
        gsonBuilder.registerTypeAdapter(Transaction.class, (Object)new TransactionGsonTypeAdapter());
        gsonBuilder.registerTypeAdapter(ValueReference.class, (Object)new ValueReferenceGsonTypeAdapter());
        gsonBuilder.registerTypeAdapter(AdminRecord.class, (Object)new AdminRecordGsonTypeAdapter());
        gsonBuilder.registerTypeAdapter(SiteInfo.class, (Object)new SiteInfoGsonTypeAdapter());
        gsonBuilder.registerTypeAdapter(ServerInfo.class, (Object)new ServerInfoGsonTypeAdapter());
        gsonBuilder.registerTypeAdapter(Interface.class, (Object)new InterfaceGsonTypeAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(AbstractResponse.class, (Object)new ResponseGsonTypeHierarchyAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(PublicKey.class, (Object)new PublicKeyTypeHierarchyAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(PrivateKey.class, (Object)new PrivateKeyTypeHierarchyAdapter());
        return gsonBuilder;
    }

    public static GsonBuilder getNewGsonBuilder() {
        return GsonUtility.setup(new GsonBuilder());
    }

    public static Gson getGson() {
        return GsonHolder.gson;
    }

    public static Gson getPrettyGson() {
        return PrettyGsonHolder.prettyGson;
    }

    private static String lowerCaseFirst(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    static JsonObject lowerCaseIfNeeded(JsonObject json) {
        if (json.has("ServerList") || json.has("Address") || json.has("Port")) {
            JsonObject obj = new JsonObject();
            for (Map.Entry entry : json.entrySet()) {
                obj.add(GsonUtility.lowerCaseFirst((String)entry.getKey()), (JsonElement)entry.getValue());
            }
            return obj;
        }
        return json;
    }

    static String secondsTimestampAsString(int seconds) {
        return FastDateFormat.formatUtc((FastDateFormat.FormatSpec)FastDateFormat.FormatSpec.ISO8601_NO_MS, (long)(1000L * (long)seconds));
    }

    static int secondsTimestampFromString(String s) throws ParseException {
        return (int)(FastDateFormat.parseUtc((String)s) / 1000L);
    }

    static JsonElement serializeData(HandleValue value, JsonSerializationContext context) {
        try {
            if (value.hasType(Common.ADMIN_TYPE)) {
                AdminRecord adminRecord = new AdminRecord();
                Encoder.decodeAdminRecord(value.getData(), 0, adminRecord);
                return GsonUtility.dataOfType("admin", context.serialize((Object)adminRecord));
            }
            if (value.hasType(Common.ADMIN_GROUP_TYPE)) {
                ValueReference[] refs = Encoder.decodeValueReferenceList(value.getData(), 0);
                return GsonUtility.dataOfType("vlist", context.serialize((Object)refs));
            }
            if (value.hasType(Common.SITE_INFO_TYPE) || value.hasType(Common.DERIVED_PREFIX_SITE_TYPE) || value.hasType(Common.LEGACY_DERIVED_PREFIX_SITE_TYPE)) {
                SiteInfo site = new SiteInfo();
                Encoder.decodeSiteInfoRecord(value.getData(), 0, site);
                return GsonUtility.dataOfType("site", context.serialize((Object)site));
            }
            if (value.hasType(Common.PUBLIC_KEY_TYPE)) {
                PublicKey key = Util.getPublicKeyFromBytes(value.getData());
                return GsonUtility.dataOfType("key", context.serialize((Object)key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!Util.looksLikeBinary(value.getData())) {
            return GsonUtility.serializeString(Util.decodeString(value.getData()));
        }
        return GsonUtility.serializeBinary(value.getData());
    }

    private static JsonElement dataOfType(String type, JsonElement value) {
        JsonObject obj = new JsonObject();
        obj.addProperty("format", type);
        obj.add("value", value);
        return obj;
    }

    static JsonElement serializeBinary(byte[] bytes) {
        JsonObject obj = new JsonObject();
        obj.addProperty("format", "base64");
        obj.addProperty("value", Base64.encodeBase64String((byte[])bytes));
        return obj;
    }

    static JsonElement serializeString(String s) {
        JsonObject obj = new JsonObject();
        obj.addProperty("format", "string");
        obj.addProperty("value", s);
        return obj;
    }

    static byte[] deserializeData(JsonElement json, JsonDeserializationContext context) throws DecoderException, ParseException {
        if (json.isJsonPrimitive()) {
            return Util.encodeString(json.getAsString());
        }
        JsonObject obj = json.getAsJsonObject();
        String format = obj.get("format").getAsString();
        JsonElement value = obj.get("value");
        if (format.equalsIgnoreCase("string")) {
            return Util.encodeString(value.getAsString());
        }
        if (format.equalsIgnoreCase("base64")) {
            return Base64.decodeBase64((String)value.getAsString());
        }
        if (format.equalsIgnoreCase("hex")) {
            return Hex.decodeHex((char[])value.getAsString().toCharArray());
        }
        if (format.equalsIgnoreCase("admin")) {
            AdminRecord adminRecord = (AdminRecord)context.deserialize(value, AdminRecord.class);
            return Encoder.encodeAdminRecord(adminRecord);
        }
        if (format.equalsIgnoreCase("vlist")) {
            ValueReference[] refs = (ValueReference[])context.deserialize(value, ValueReference[].class);
            return Encoder.encodeValueReferenceList(refs);
        }
        if (format.equalsIgnoreCase("site")) {
            SiteInfo site = (SiteInfo)context.deserialize(value, SiteInfo.class);
            return Encoder.encodeSiteInfoRecord(site);
        }
        if (format.equalsIgnoreCase("key")) {
            PublicKey key = (PublicKey)context.deserialize(value, PublicKey.class);
            try {
                return Util.getBytesFromPublicKey(key);
            }
            catch (HandleException e) {
                ParseException pe = new ParseException("Unable to deserialize public key", 0);
                pe.initCause(e);
                throw pe;
            }
        }
        throw new ParseException("Unexpected type " + format, 0);
    }

    public static JsonElement serializeResponseToRequest(AbstractRequest req, AbstractResponse resp) {
        JsonObject json = GsonUtility.getGson().toJsonTree((Object)resp).getAsJsonObject();
        if (json.has("handle")) {
            return json;
        }
        if (req != null && req.handle != null && req.handle.length > 0 && !Util.equals(Common.BLANK_HANDLE, req.handle)) {
            json.addProperty("handle", Util.decodeString(req.handle));
        }
        return json;
    }

    private static byte[] unsigned(byte[] arr) {
        if (arr.length == 0) {
            return new byte[1];
        }
        int zeros = 0;
        for (byte element : arr) {
            if (element != 0) break;
            ++zeros;
        }
        if (zeros == arr.length) {
            --zeros;
        }
        if (zeros == 0) {
            return arr;
        }
        byte[] res = new byte[arr.length - zeros];
        System.arraycopy(arr, zeros, res, 0, arr.length - zeros);
        return res;
    }

    private static <T> void ensureNoTrailingComma(T[] arr) {
        if (arr == null || arr.length == 0) {
            return;
        }
        if (arr[arr.length - 1] == null) {
            throw new JsonParseException("While parsing JSON found array ending with null");
        }
    }

    public static class PrivateKeyTypeHierarchyAdapter
    implements JsonSerializer<PrivateKey>,
    JsonDeserializer<PrivateKey> {
        public JsonElement serialize(PrivateKey key, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            if (key instanceof DSAPrivateKey) {
                DSAPrivateKey dsaKey = (DSAPrivateKey)key;
                byte[] x = dsaKey.getX().toByteArray();
                DSAParams dsaParams = dsaKey.getParams();
                byte[] p = dsaParams.getP().toByteArray();
                byte[] q = dsaParams.getQ().toByteArray();
                byte[] g = dsaParams.getG().toByteArray();
                json.addProperty("kty", "DSA");
                json.addProperty("x", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(x)));
                json.addProperty("p", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(p)));
                json.addProperty("q", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(q)));
                json.addProperty("g", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(g)));
            } else if (key instanceof RSAPrivateKey) {
                RSAPrivateKey rsaKey = (RSAPrivateKey)key;
                byte[] n = rsaKey.getModulus().toByteArray();
                byte[] d = rsaKey.getPrivateExponent().toByteArray();
                json.addProperty("kty", "RSA");
                if (key instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rsacrtKey = (RSAPrivateCrtKey)rsaKey;
                    byte[] e = rsacrtKey.getPublicExponent().toByteArray();
                    byte[] p = rsacrtKey.getPrimeP().toByteArray();
                    byte[] q = rsacrtKey.getPrimeQ().toByteArray();
                    byte[] dp = rsacrtKey.getPrimeExponentP().toByteArray();
                    byte[] dq = rsacrtKey.getPrimeExponentQ().toByteArray();
                    byte[] qi = rsacrtKey.getCrtCoefficient().toByteArray();
                    json.addProperty("n", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(n)));
                    json.addProperty("e", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(e)));
                    json.addProperty("d", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(d)));
                    json.addProperty("p", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(p)));
                    json.addProperty("q", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(q)));
                    json.addProperty("dp", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(dp)));
                    json.addProperty("dq", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(dq)));
                    json.addProperty("qi", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(qi)));
                } else {
                    json.addProperty("n", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(n)));
                    json.addProperty("d", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(d)));
                }
            } else {
                throw new UnsupportedOperationException("Unsupported key type " + key.getClass().getName());
            }
            return json;
        }

        public PrivateKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject obj = json.getAsJsonObject();
                String kty = obj.get("kty").getAsString();
                if ("DSA".equalsIgnoreCase(kty)) {
                    byte[] x = Base64.decodeBase64((String)obj.get("x").getAsString());
                    byte[] p = Base64.decodeBase64((String)obj.get("p").getAsString());
                    byte[] q = Base64.decodeBase64((String)obj.get("q").getAsString());
                    byte[] g = Base64.decodeBase64((String)obj.get("g").getAsString());
                    DSAPrivateKeySpec keySpec = new DSAPrivateKeySpec(new BigInteger(1, x), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
                    KeyFactory dsaKeyFactory = KeyFactory.getInstance("DSA");
                    return dsaKeyFactory.generatePrivate(keySpec);
                }
                if ("RSA".equalsIgnoreCase(kty)) {
                    RSAPrivateKeySpec keySpec;
                    byte[] n = Base64.decodeBase64((String)obj.get("n").getAsString());
                    byte[] d = Base64.decodeBase64((String)obj.get("d").getAsString());
                    if (obj.has("qi")) {
                        byte[] e = Base64.decodeBase64((String)obj.get("e").getAsString());
                        byte[] p = Base64.decodeBase64((String)obj.get("p").getAsString());
                        byte[] q = Base64.decodeBase64((String)obj.get("q").getAsString());
                        byte[] dp = Base64.decodeBase64((String)obj.get("dp").getAsString());
                        byte[] dq = Base64.decodeBase64((String)obj.get("dq").getAsString());
                        byte[] qi = Base64.decodeBase64((String)obj.get("qi").getAsString());
                        keySpec = new RSAPrivateCrtKeySpec(new BigInteger(1, n), new BigInteger(1, e), new BigInteger(1, d), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, dp), new BigInteger(1, dq), new BigInteger(1, qi));
                    } else {
                        keySpec = new RSAPrivateKeySpec(new BigInteger(1, n), new BigInteger(1, d));
                    }
                    KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                    return rsaKeyFactory.generatePrivate(keySpec);
                }
                throw new UnsupportedOperationException("Unsupported key type " + kty);
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class PublicKeyTypeHierarchyAdapter
    implements JsonSerializer<PublicKey>,
    JsonDeserializer<PublicKey> {
        public JsonElement serialize(PublicKey key, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            if (key instanceof DSAPublicKey) {
                DSAPublicKey dsaKey = (DSAPublicKey)key;
                byte[] y = dsaKey.getY().toByteArray();
                DSAParams dsaParams = dsaKey.getParams();
                byte[] p = dsaParams.getP().toByteArray();
                byte[] q = dsaParams.getQ().toByteArray();
                byte[] g = dsaParams.getG().toByteArray();
                json.addProperty("kty", "DSA");
                json.addProperty("y", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(y)));
                json.addProperty("p", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(p)));
                json.addProperty("q", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(q)));
                json.addProperty("g", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(g)));
            } else if (key instanceof RSAPublicKey) {
                RSAPublicKey rsaKey = (RSAPublicKey)key;
                byte[] n = rsaKey.getModulus().toByteArray();
                byte[] e = rsaKey.getPublicExponent().toByteArray();
                json.addProperty("kty", "RSA");
                json.addProperty("n", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(n)));
                json.addProperty("e", Base64.encodeBase64URLSafeString((byte[])GsonUtility.unsigned(e)));
            } else {
                throw new UnsupportedOperationException("Unsupported key type " + key.getClass().getName());
            }
            return json;
        }

        public PublicKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject obj = json.getAsJsonObject();
                String kty = obj.get("kty").getAsString();
                if ("DSA".equalsIgnoreCase(kty)) {
                    byte[] y = Base64.decodeBase64((String)obj.get("y").getAsString());
                    byte[] p = Base64.decodeBase64((String)obj.get("p").getAsString());
                    byte[] q = Base64.decodeBase64((String)obj.get("q").getAsString());
                    byte[] g = Base64.decodeBase64((String)obj.get("g").getAsString());
                    DSAPublicKeySpec keySpec = new DSAPublicKeySpec(new BigInteger(1, y), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
                    KeyFactory dsaKeyFactory = KeyFactory.getInstance("DSA");
                    return dsaKeyFactory.generatePublic(keySpec);
                }
                if ("RSA".equalsIgnoreCase(kty)) {
                    byte[] n = Base64.decodeBase64((String)obj.get("n").getAsString());
                    byte[] e = Base64.decodeBase64((String)obj.get("e").getAsString());
                    RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, n), new BigInteger(1, e));
                    KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                    return rsaKeyFactory.generatePublic(keySpec);
                }
                throw new UnsupportedOperationException("Unsupported key type " + kty);
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class ResponseGsonTypeHierarchyAdapter
    implements JsonSerializer<AbstractResponse> {
        public JsonElement serialize(AbstractResponse resp, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("responseCode", (Number)resp.responseCode);
            if (resp instanceof ResolutionResponse) {
                ResolutionResponse rresp = (ResolutionResponse)resp;
                json.addProperty("handle", Util.decodeString(rresp.handle));
                try {
                    HandleValue[] values = rresp.getHandleValues();
                    json.add("values", context.serialize((Object)values));
                }
                catch (Exception e) {
                    json.addProperty("responseCode", (Number)2);
                    json.addProperty("message", "Error decoding values of resolution response " + e.toString());
                }
            } else if (resp instanceof ServiceReferralResponse) {
                ServiceReferralResponse rresp = (ServiceReferralResponse)resp;
                if (rresp.handle.length > 0) {
                    json.addProperty("referralHandle", Util.decodeString(rresp.handle));
                }
                if (rresp.values != null && rresp.values.length > 0) {
                    try {
                        HandleValue[] values = rresp.getHandleValues();
                        json.add("values", context.serialize((Object)values));
                    }
                    catch (Exception e) {
                        json.addProperty("responseCode", (Number)2);
                        json.addProperty("message", "Error decoding values of resolution response " + e.toString());
                    }
                }
            } else if (resp instanceof ErrorResponse) {
                ErrorResponse eresp = (ErrorResponse)resp;
                if (eresp.message != null && eresp.message.length > 0) {
                    json.addProperty("message", Util.decodeString(eresp.message));
                }
                if (resp.opCode == 1 && resp.responseCode == 200) {
                    json.add("values", (JsonElement)new JsonArray());
                }
            } else if (resp instanceof GetSiteInfoResponse) {
                GetSiteInfoResponse gresp = (GetSiteInfoResponse)resp;
                json.add("site", context.serialize((Object)gresp.siteInfo));
            } else if (resp instanceof VerifyAuthResponse) {
                json.addProperty("isValid", Boolean.valueOf(((VerifyAuthResponse)resp).isValid));
            } else if (resp instanceof CreateHandleResponse) {
                CreateHandleResponse creResp = (CreateHandleResponse)resp;
                if (creResp.handle != null) {
                    json.addProperty("handle", Util.decodeString(creResp.handle));
                }
            }
            return json;
        }
    }

    public static class InterfaceGsonTypeAdapter
    implements JsonSerializer<Interface>,
    JsonDeserializer<Interface> {
        public JsonElement serialize(Interface intf, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("query", Boolean.valueOf((intf.type & 2) != 0));
            json.addProperty("admin", Boolean.valueOf((intf.type & 1) != 0));
            InterfaceGsonTypeAdapter.serializeProtocol(json, intf.protocol);
            json.addProperty("port", (Number)intf.port);
            return json;
        }

        private static void serializeProtocol(JsonObject json, byte protocol) {
            if (protocol == 0) {
                json.addProperty("protocol", "UDP");
            } else if (protocol == 1) {
                json.addProperty("protocol", "TCP");
            } else if (protocol == 2) {
                json.addProperty("protocol", "HTTP");
            } else if (protocol == 3) {
                json.addProperty("protocol", "HTTPS");
            } else {
                json.addProperty("protocol", (Number)protocol);
            }
        }

        public Interface deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                boolean admin;
                JsonObject obj = json.getAsJsonObject();
                obj = GsonUtility.lowerCaseIfNeeded(obj);
                Interface intf = new Interface();
                boolean query = obj.has("query") && obj.get("query").getAsBoolean();
                boolean bl = admin = obj.has("admin") && obj.get("admin").getAsBoolean();
                intf.type = (byte)(query ? (admin ? 3 : 2) : (admin ? 1 : 0));
                String protocol = obj.get("protocol").getAsString();
                intf.protocol = "UDP".equals(protocol) ? (byte)0 : ("TCP".equals(protocol) ? (byte)1 : ("HTTP".equals(protocol) ? (byte)2 : ("HTTPS".equals(protocol) ? (byte)3 : obj.get("protocol").getAsByte())));
                intf.port = obj.get("port").getAsInt();
                return intf;
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class ServerInfoGsonTypeAdapter
    implements JsonSerializer<ServerInfo>,
    JsonDeserializer<ServerInfo> {
        private static byte[] fill16(byte[] bytes) {
            if (bytes.length == 16) {
                return bytes;
            }
            byte[] res = new byte[16];
            System.arraycopy(bytes, 0, res, 16 - bytes.length, bytes.length);
            return res;
        }

        public JsonElement serialize(ServerInfo server, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("serverId", (Number)server.serverId);
            json.addProperty("address", server.getAddressString());
            try {
                PublicKey key = Util.getPublicKeyFromBytes(server.publicKey);
                json.add("publicKey", GsonUtility.dataOfType("key", context.serialize((Object)key)));
            }
            catch (Exception e) {
                json.add("publicKey", GsonUtility.serializeBinary(server.publicKey));
            }
            json.add("interfaces", context.serialize((Object)server.interfaces));
            return json;
        }

        public ServerInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonElement interfaces;
                JsonObject origObj = json.getAsJsonObject();
                JsonObject obj = GsonUtility.lowerCaseIfNeeded(origObj);
                boolean legacy = obj != origObj;
                ServerInfo server = new ServerInfo();
                if (obj.has("serverId")) {
                    server.serverId = obj.get("serverId").getAsInt();
                }
                server.ipAddress = ServerInfoGsonTypeAdapter.fill16(InetAddress.getByName(obj.get("address").getAsString()).getAddress());
                if (obj.has("publicKey")) {
                    server.publicKey = legacy && obj.get("publicKey").isJsonPrimitive() ? Hex.decodeHex((char[])obj.get("publicKey").getAsString().toCharArray()) : GsonUtility.deserializeData(obj.get("publicKey"), context);
                }
                if ((interfaces = obj.get("interfaces")) == null) {
                    interfaces = obj.get("interfaceList");
                }
                server.interfaces = (Interface[])context.deserialize(interfaces, Interface[].class);
                GsonUtility.ensureNoTrailingComma(server.interfaces);
                return server;
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SiteInfoGsonTypeAdapter
    implements JsonSerializer<SiteInfo>,
    JsonDeserializer<SiteInfo> {
        private static JsonElement serializeAttributes(Attribute[] attributes) {
            JsonArray json = new JsonArray();
            for (Attribute att : attributes) {
                JsonObject attJson = new JsonObject();
                attJson.addProperty("name", Util.decodeString(att.name));
                attJson.addProperty("value", Util.decodeString(att.value));
                json.add((JsonElement)attJson);
            }
            return json;
        }

        private static Attribute[] deserializeAttributes(JsonElement json) {
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            if (json.isJsonArray()) {
                for (JsonElement el : json.getAsJsonArray()) {
                    JsonObject obj = el.getAsJsonObject();
                    atts.add(new Attribute(Util.encodeString(obj.get("name").getAsString()), Util.encodeString(obj.get("value").getAsString())));
                }
            } else {
                for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                    if (((JsonElement)entry.getValue()).isJsonArray()) {
                        for (JsonElement el : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                            atts.add(new Attribute(Util.encodeString((String)entry.getKey()), Util.encodeString(el.getAsString())));
                        }
                        continue;
                    }
                    atts.add(new Attribute(Util.encodeString((String)entry.getKey()), Util.encodeString(((JsonElement)entry.getValue()).getAsString())));
                }
            }
            return atts.toArray(new Attribute[atts.size()]);
        }

        public JsonElement serialize(SiteInfo site, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("version", (Number)site.dataFormatVersion);
            json.addProperty("protocolVersion", "" + Integer.valueOf(site.majorProtocolVersion) + "." + Integer.valueOf(site.minorProtocolVersion));
            json.addProperty("serialNumber", (Number)site.serialNumber);
            json.addProperty("primarySite", Boolean.valueOf(site.isPrimary));
            json.addProperty("multiPrimary", Boolean.valueOf(site.multiPrimary));
            if (site.hashOption != 2) {
                json.addProperty("hashOption", (Number)site.hashOption);
            }
            if (site.hashFilter != null && site.hashFilter.length > 0) {
                json.addProperty("hashFilter", Util.decodeString(site.hashFilter));
            }
            if (site.attributes != null) {
                json.add("attributes", SiteInfoGsonTypeAdapter.serializeAttributes(site.attributes));
            }
            if (site.servers != null) {
                json.add("servers", context.serialize((Object)site.servers));
            }
            return json;
        }

        public SiteInfo deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonElement servers;
                JsonObject obj = json.getAsJsonObject();
                obj = GsonUtility.lowerCaseIfNeeded(obj);
                SiteInfo site = new SiteInfo();
                if (obj.has("version")) {
                    site.dataFormatVersion = obj.get("version").getAsInt();
                }
                if (obj.has("protocolVersion")) {
                    String versionString = obj.get("protocolVersion").getAsString();
                    int point = versionString.indexOf(46);
                    site.majorProtocolVersion = Byte.parseByte(versionString.substring(0, point));
                    site.minorProtocolVersion = Byte.parseByte(versionString.substring(point + 1));
                }
                if (obj.has("serialNumber")) {
                    site.serialNumber = obj.get("serialNumber").getAsInt();
                }
                if (obj.has("primarySite")) {
                    site.isPrimary = obj.get("primarySite").getAsBoolean();
                }
                if (obj.has("multiPrimary")) {
                    site.multiPrimary = obj.get("multiPrimary").getAsBoolean();
                }
                if (obj.has("hashOption")) {
                    site.hashOption = obj.get("hashOption").getAsByte();
                }
                if (obj.has("hashFilter")) {
                    site.hashFilter = Util.encodeString(obj.get("hashFilter").getAsString());
                }
                if (obj.has("attributes")) {
                    site.attributes = SiteInfoGsonTypeAdapter.deserializeAttributes(obj.get("attributes"));
                }
                if ((servers = obj.get("servers")) == null) {
                    servers = obj.get("serverList");
                }
                site.servers = (ServerInfo[])context.deserialize(servers, ServerInfo[].class);
                GsonUtility.ensureNoTrailingComma(site.servers);
                return site;
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class AdminRecordGsonTypeAdapter
    implements JsonSerializer<AdminRecord>,
    JsonDeserializer<AdminRecord> {
        private static boolean[] allTrueArray = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true};

        private static String permsArrayToString(boolean[] perms) {
            if (perms == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder(perms.length);
            for (int i = perms.length - 1; i >= 0; --i) {
                sb.append(perms[i] ? (char)'1' : '0');
            }
            return sb.toString();
        }

        private static boolean[] permsStringToArray(String perms) {
            if ("*".equals(perms)) {
                return (boolean[])allTrueArray.clone();
            }
            boolean[] res = new boolean[12];
            if (perms == null) {
                return res;
            }
            for (int i = 0; i < res.length && perms.length() > i; ++i) {
                res[i] = '1' == perms.charAt(perms.length() - 1 - i);
            }
            return res;
        }

        private static boolean[] permsPrimitiveToArray(JsonPrimitive perms) {
            if (perms.isBoolean()) {
                if (perms.getAsBoolean()) {
                    return (boolean[])allTrueArray.clone();
                }
                return new boolean[12];
            }
            if (perms.isString()) {
                return AdminRecordGsonTypeAdapter.permsStringToArray(perms.getAsString());
            }
            return AdminRecordGsonTypeAdapter.permsStringToArray(Integer.toBinaryString(perms.getAsInt()));
        }

        private static boolean[] permsArrayToArray(JsonArray perms) {
            boolean[] res = new boolean[12];
            for (int i = 0; i < 12 && i < perms.size(); ++i) {
                res[i] = AdminRecordGsonTypeAdapter.isTruthy(perms.get(i));
            }
            return res;
        }

        private static boolean isTruthy(JsonElement json) {
            if (json == null || json.isJsonNull()) {
                return false;
            }
            if (!json.isJsonPrimitive()) {
                return true;
            }
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return jsonPrimitive.getAsBoolean();
            }
            if (jsonPrimitive.isString()) {
                return !jsonPrimitive.getAsString().isEmpty();
            }
            double num = jsonPrimitive.getAsNumber().doubleValue();
            if (Double.isNaN(num)) {
                return false;
            }
            return num != 0.0;
        }

        private static boolean[] permsElementToArray(JsonElement perms) {
            if (perms == null || perms.isJsonNull()) {
                return new boolean[12];
            }
            if (perms.isJsonPrimitive()) {
                return AdminRecordGsonTypeAdapter.permsPrimitiveToArray(perms.getAsJsonPrimitive());
            }
            if (perms.isJsonArray()) {
                return AdminRecordGsonTypeAdapter.permsArrayToArray(perms.getAsJsonArray());
            }
            throw new IllegalStateException("Did not expect permissions object");
        }

        public JsonElement serialize(AdminRecord src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("handle", Util.decodeString(src.adminId));
            json.addProperty("index", (Number)src.adminIdIndex);
            json.addProperty("permissions", AdminRecordGsonTypeAdapter.permsArrayToString(src.perms));
            if (src.legacyByteLength) {
                json.addProperty("legacyByteLength", Boolean.valueOf(true));
            }
            return json;
        }

        public AdminRecord deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject obj = json.getAsJsonObject();
                String handle = obj.get("handle").getAsString();
                int index = obj.get("index").getAsInt();
                JsonElement perms = obj.get("permissions");
                boolean[] permsArray = AdminRecordGsonTypeAdapter.permsElementToArray(perms);
                AdminRecord res = new AdminRecord(Util.encodeString(handle), index, permsArray[0], permsArray[1], permsArray[2], permsArray[3], permsArray[4], permsArray[5], permsArray[6], permsArray[7], permsArray[8], permsArray[9], permsArray[10], permsArray[11]);
                JsonElement legacyByteLengthElement = obj.get("legacyByteLength");
                if (legacyByteLengthElement != null && legacyByteLengthElement.getAsBoolean()) {
                    res.legacyByteLength = true;
                }
                return res;
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class ValueReferenceGsonTypeAdapter
    implements JsonSerializer<ValueReference>,
    JsonDeserializer<ValueReference> {
        public JsonElement serialize(ValueReference valueRef, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("handle", Util.decodeString(valueRef.handle));
            json.addProperty("index", (Number)valueRef.index);
            return json;
        }

        public ValueReference deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject obj = json.getAsJsonObject();
                String handle = obj.get("handle").getAsString();
                int index = obj.get("index").getAsInt();
                return new ValueReference(Util.encodeString(handle), index);
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class TransactionGsonTypeAdapter
    implements JsonSerializer<Transaction>,
    JsonDeserializer<Transaction> {
        public JsonElement serialize(Transaction txn, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("txnId", (Number)txn.txnId);
            json.addProperty("handle", Util.decodeString(txn.handle));
            json.addProperty("action", Transaction.actionToString(txn.action));
            json.addProperty("date", FastDateFormat.getUtcFormat().format(txn.date));
            return json;
        }

        public Transaction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonObject obj = json.getAsJsonObject();
                int txnId = obj.get("txnId").getAsInt();
                String handleString = obj.get("handle").getAsString();
                byte[] handle = Util.encodeString(handleString);
                byte action = Transaction.stringToAction(obj.get("action").getAsString());
                long date = FastDateFormat.parseUtc((String)obj.get("date").getAsString());
                return new Transaction(txnId, handle, action, date);
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class HandleValueGsonTypeAdapter
    implements JsonSerializer<HandleValue>,
    JsonDeserializer<HandleValue> {
        public JsonElement serialize(HandleValue value, Type type, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("index", (Number)value.index);
            json.addProperty("type", Util.decodeString(value.type));
            json.add("data", GsonUtility.serializeData(value, context));
            if (HandleValueGsonTypeAdapter.unusualPermissions(value)) {
                json.add("permissions", HandleValueGsonTypeAdapter.serializePermissions(value));
            }
            json.add("ttl", HandleValueGsonTypeAdapter.serializeTtl(value));
            if (value.timestamp != 0) {
                json.addProperty("timestamp", GsonUtility.secondsTimestampAsString(value.timestamp));
            }
            if (value.references != null && value.references.length > 0) {
                json.add("references", context.serialize((Object)value.references));
            }
            return json;
        }

        public HandleValue deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonElement refs;
                JsonObject obj = json.getAsJsonObject();
                HandleValue value = new HandleValue();
                value.index = obj.get("index").getAsInt();
                value.type = Util.encodeString(obj.get("type").getAsString());
                value.data = GsonUtility.deserializeData(obj.get("data"), context);
                HandleValueGsonTypeAdapter.deserializePermissions(value, obj);
                HandleValueGsonTypeAdapter.deserializeTtl(value, obj);
                if (obj.has("timestamp")) {
                    value.timestamp = GsonUtility.secondsTimestampFromString(obj.get("timestamp").getAsString());
                }
                if ((refs = obj.get("references")) != null && !refs.isJsonNull()) {
                    value.references = (ValueReference[])context.deserialize(refs, ValueReference[].class);
                    GsonUtility.ensureNoTrailingComma(value.references);
                }
                return value;
            }
            catch (JsonParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        private static boolean unusualPermissions(HandleValue value) {
            return !value.adminRead || !value.adminWrite || !value.publicRead || value.publicWrite;
        }

        private static JsonElement serializeTtl(HandleValue value) {
            if (value.ttlType == 0) {
                return new JsonPrimitive((Number)value.ttl);
            }
            return new JsonPrimitive(GsonUtility.secondsTimestampAsString(value.ttl));
        }

        private static void deserializeTtl(HandleValue value, JsonObject obj) throws ParseException {
            JsonElement ttl = obj.get("ttl");
            if (ttl != null) {
                JsonPrimitive ttlPrim = ttl.getAsJsonPrimitive();
                if (ttlPrim.isString()) {
                    value.ttlType = 1;
                    value.ttl = GsonUtility.secondsTimestampFromString(ttlPrim.getAsString());
                } else if (ttlPrim.isNumber()) {
                    value.ttlType = 0;
                    value.ttl = ttlPrim.getAsInt();
                } else {
                    throw new NumberFormatException("bad ttl");
                }
            }
        }

        private static String bit(boolean b) {
            return b ? "1" : "0";
        }

        private static JsonElement serializePermissions(HandleValue value) {
            return new JsonPrimitive(HandleValueGsonTypeAdapter.bit(value.adminRead) + HandleValueGsonTypeAdapter.bit(value.adminWrite) + HandleValueGsonTypeAdapter.bit(value.publicRead) + HandleValueGsonTypeAdapter.bit(value.publicWrite));
        }

        private static void deserializePermissions(HandleValue value, JsonObject obj) {
            if (obj.has("permissions")) {
                String perms = obj.get("permissions").getAsString();
                if ("*".equals(perms)) {
                    value.adminWrite = true;
                    value.adminRead = true;
                    value.publicWrite = true;
                    value.publicRead = true;
                } else {
                    if (perms.length() > 1) {
                        boolean bl = value.publicWrite = '1' == perms.charAt(perms.length() - 1);
                    }
                    if (perms.length() > 2) {
                        boolean bl = value.publicRead = '1' == perms.charAt(perms.length() - 2);
                    }
                    if (perms.length() > 3) {
                        boolean bl = value.adminWrite = '1' == perms.charAt(perms.length() - 3);
                    }
                    if (perms.length() > 4) {
                        value.adminRead = '1' == perms.charAt(perms.length() - 4);
                    }
                }
            }
        }
    }

    private static class PrettyGsonHolder {
        static Gson prettyGson = GsonUtility.setup(new GsonBuilder().disableHtmlEscaping().setPrettyPrinting()).create();

        private PrettyGsonHolder() {
        }
    }

    private static class GsonHolder {
        static Gson gson = GsonUtility.setup(new GsonBuilder().disableHtmlEscaping()).create();

        private GsonHolder() {
        }
    }
}

