/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Arrays;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SessionInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;

public class ClientSideSessionInfo
extends SessionInfo {
    private final ServerInfo server;
    private byte[] exchangeKeyHandle = null;
    private int exchangeKeyIndex = -1;
    private byte[] exchangePublicKey = null;

    @Deprecated
    public ClientSideSessionInfo(int sessionid, byte[] sessionkey, byte[] identityHandle, int identityindex, ServerInfo server, int majorProtocolVersion, int minorProtocolVersion) {
        this(sessionid, sessionkey, identityHandle, identityindex, 1, server, majorProtocolVersion, minorProtocolVersion);
    }

    public ClientSideSessionInfo(int sessionid, byte[] sessionkey, byte[] identityHandle, int identityindex, int algorithmCode, ServerInfo server, int majorProtocolVersion, int minorProtocolVersion) {
        super(sessionid, sessionkey, identityHandle, identityindex, algorithmCode, majorProtocolVersion, minorProtocolVersion);
        this.server = server;
    }

    public void setExchangeKeyRef(byte[] keyrefHandle, int keyrefindex) {
        this.exchangeKeyHandle = keyrefHandle;
        this.exchangeKeyIndex = keyrefindex;
    }

    public void setExchangePublicKey(byte[] key) {
        this.exchangePublicKey = key;
    }

    public byte[] getExchangeKeyRefHandle() {
        return this.exchangeKeyHandle;
    }

    public int getExchangeKeyRefindex() {
        return this.exchangeKeyIndex;
    }

    public byte[] getExchagePublicKey() {
        return this.exchangePublicKey;
    }

    public void takeValuesFromOption(SessionSetupInfo option) {
        this.exchangeKeyHandle = option.exchangeKeyHandle;
        this.exchangeKeyIndex = option.exchangeKeyIndex;
        this.exchangePublicKey = option.publicExchangeKey;
        this.timeOut = option.timeout;
        this.encryptMessage = option.encrypted;
        this.authenticateMessage = option.authenticated;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.exchangeKeyHandle);
        result = 31 * result + this.exchangeKeyIndex;
        result = 31 * result + Arrays.hashCode(this.exchangePublicKey);
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClientSideSessionInfo info = (ClientSideSessionInfo)obj;
        if (this.server == null && info.server != null || this.server != null && info.server == null || this.server != null && !this.server.equals(info.server)) {
            return false;
        }
        if (this.exchangeKeyIndex != info.getExchangeKeyRefindex()) {
            return false;
        }
        if (!Util.equals(this.exchangeKeyHandle, info.getExchangeKeyRefHandle())) {
            return false;
        }
        if (!Util.equals(this.exchangePublicKey, info.getExchagePublicKey())) {
            return false;
        }
        return super.equals(info);
    }
}

