/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.SecureRandom;
import java.util.Random;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;

public class ChallengeResponse
extends AbstractResponse {
    private static Random random = null;
    private static final String randomLock = "randomLock";
    public byte[] nonce;

    public ChallengeResponse(int opCode, byte[] nonce) {
        super(opCode, 402);
        this.nonce = nonce;
    }

    public ChallengeResponse(AbstractRequest req) throws HandleException {
        this(req, false);
    }

    public ChallengeResponse(AbstractRequest req, boolean compatibility) throws HandleException {
        super(req, 402);
        if (this.requestDigest == null) {
            this.takeDigestOfRequest(req);
        }
        this.returnRequestDigest = true;
        this.nonce = ChallengeResponse.generateNonce();
        if (compatibility) {
            this.suggestMajorProtocolVersion = (byte)2;
            this.suggestMinorProtocolVersion = (byte)3;
        }
    }

    public static final void initializeRandom() {
        ChallengeResponse.initializeRandom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void initializeRandom(byte[] seed) {
        if (random != null) return;
        String string = randomLock;
        synchronized (randomLock) {
            if (random != null) return;
            if (seed == null) {
                random = new SecureRandom();
                random.setSeed(System.nanoTime());
            } else {
                random = new SecureRandom(seed);
            }
            random.nextInt();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static Random getRandom() {
        if (random == null) {
            ChallengeResponse.initializeRandom();
        }
        return random;
    }

    public static byte[] generateNonce() {
        byte[] nonce = new byte[16];
        ChallengeResponse.getRandom().nextBytes(nonce);
        return nonce;
    }
}

