/*
 * Decompiled with CFR 0.152.
 */
package net.handle.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JLabel;

public class AwtUtil {
    public static final JLabel PadLabel = new JLabel(" test ");
    private static GridBagConstraints c = new GridBagConstraints();
    private static final Insets DEFAULT_INSETS = AwtUtil.c.insets;
    private static final int DEFAULT_ANCHOR = AwtUtil.c.anchor;
    private static final int DEFAULT_IPADX = AwtUtil.c.ipadx;
    private static final int DEFAULT_IPADY = AwtUtil.c.ipady;
    public static final int WINDOW_BOTTOM_RIGHT = 0;
    public static final int WINDOW_BOTTOM_LEFT = 1;
    public static final int WINDOW_TOP_LEFT = 2;
    public static final int WINDOW_TOP_RIGHT = 3;
    public static final int WINDOW_CENTER = 4;

    private static GridBagConstraints getDefaultGC() {
        AwtUtil.c.gridx = 0;
        AwtUtil.c.gridy = 0;
        AwtUtil.c.weightx = 1.0;
        AwtUtil.c.weighty = 1.0;
        AwtUtil.c.anchor = 10;
        AwtUtil.c.gridwidth = 1;
        AwtUtil.c.gridheight = 1;
        AwtUtil.c.fill = 1;
        return c;
    }

    public static GridBagConstraints getConstraints(int gridx, int gridy, double weightx, double weighty, int gridwidth, int gridheight, boolean fillHorizontal, boolean fillVertical) {
        return AwtUtil.getConstraints(gridx, gridy, weightx, weighty, gridwidth, gridheight, DEFAULT_INSETS, DEFAULT_ANCHOR, fillHorizontal, fillVertical);
    }

    public static GridBagConstraints getConstraints(int gridx, int gridy, double weightx, double weighty, int gridwidth, int gridheight, Insets insets, boolean fillHorizontal, boolean fillVertical) {
        return AwtUtil.getConstraints(gridx, gridy, weightx, weighty, gridwidth, gridheight, insets, DEFAULT_ANCHOR, fillHorizontal, fillVertical);
    }

    public static GridBagConstraints getConstraints(int gridx, int gridy, double weightx, double weighty, int gridwidth, int gridheight, Insets insets, int align, boolean fillHorizontal, boolean fillVertical) {
        return AwtUtil.getConstraints(gridx, gridy, weightx, weighty, gridwidth, gridheight, DEFAULT_IPADX, DEFAULT_IPADY, insets, align, fillHorizontal, fillVertical);
    }

    public static GridBagConstraints getConstraints(int gridx, int gridy, double weightx, double weighty, int gridwidth, int gridheight, int ipadx, int ipady, Insets insets, int align, boolean fillHorizontal, boolean fillVertical) {
        GridBagConstraints gc = AwtUtil.getDefaultGC();
        gc.gridx = gridx;
        gc.gridy = gridy;
        gc.weightx = weightx;
        gc.weighty = weighty;
        gc.gridwidth = gridwidth;
        gc.gridheight = gridheight;
        gc.ipadx = ipadx;
        gc.ipady = ipady;
        gc.insets = insets;
        gc.anchor = align;
        gc.fill = fillHorizontal && fillVertical ? 1 : (fillHorizontal ? 2 : (fillVertical ? 3 : 0));
        return gc;
    }

    public static Frame getFrame(Component comp) {
        while (comp != null && !(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public static final void setWindowPosition(Window win, int position) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (tk == null) {
            win.setLocation(20, 20);
            return;
        }
        Dimension ssz = tk.getScreenSize();
        Dimension sz = win.getSize();
        switch (position) {
            case 0: {
                win.setLocation(ssz.width - sz.width, ssz.height - sz.height);
                break;
            }
            case 1: {
                win.setLocation(0, ssz.height - sz.height);
                break;
            }
            case 3: {
                win.setLocation(ssz.width - sz.width, 0);
                break;
            }
            case 2: {
                win.setLocation(0, 0);
                break;
            }
            default: {
                win.setLocation(ssz.width / 2 - sz.width / 2, ssz.height / 2 - sz.height / 2);
            }
        }
    }

    public static final void setWindowPosition(Window child, Component parent) {
        Dimension pSz;
        Point pLoc;
        Component parentComp = AwtUtil.getFrame(parent);
        if (parentComp == null) {
            parentComp = parent;
        }
        if (parentComp == null) {
            pLoc = new Point(0, 0);
            pSz = Toolkit.getDefaultToolkit().getScreenSize();
        } else {
            pLoc = parent.getLocationOnScreen();
            pSz = parent.getSize();
        }
        Dimension cSz = child.getSize();
        try {
            child.setLocation(pLoc.x + pSz.width / 2 - cSz.width / 2, pLoc.y + pSz.height / 2 - cSz.height / 2);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

