/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.simple;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import net.cnri.util.SimpleCommandLine;
import net.cnri.util.StreamUtil;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import org.apache.commons.codec.binary.Base64;

public class KeyConverter {
    private static Pattern firstLinePattern = Pattern.compile("^\\s*-----BEGIN (.*) KEY-----\\s*$");
    private final byte[] bytes;
    private final boolean encrypt;
    private String outputFilename;
    private byte[] passIn;
    private byte[] passOut;
    private String format;

    private static BytesAndKeyType readPemFile(Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        StringBuilder base64Only = new StringBuilder();
        String keyType = null;
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                if (keyType == null) {
                    Matcher m = firstLinePattern.matcher(line);
                    keyType = m.matches() ? m.group(1) : "";
                }
                if (line.startsWith("-----")) continue;
                base64Only.append(line);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        byte[] bytes = Base64.decodeBase64((String)base64Only.toString());
        return new BytesAndKeyType(bytes, keyType);
    }

    public static String toX509Pem(PublicKey publicKey) {
        byte[] data;
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PUBLIC KEY-----\r\n");
        for (byte b : data = Base64.encodeBase64((byte[])publicKey.getEncoded(), (boolean)true)) {
            sb.append((char)b);
        }
        if (data[data.length - 1] != 10) {
            sb.append("\r\n");
        }
        sb.append("-----END PUBLIC KEY-----\r\n");
        return sb.toString();
    }

    public static PublicKey publicKeyFromBytes(byte[] bytes) throws Exception {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            try {
                return KeyFactory.getInstance("RSA").generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                return KeyFactory.getInstance("DSA").generatePublic(keySpec);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("Neither RSA nor DSA public key generator can parse", e);
        }
    }

    public static PublicKey fromX509Pem(String pem) throws Exception {
        BytesAndKeyType bytesAndKeyType = KeyConverter.readPemFile(new StringReader(pem));
        if (!"PUBLIC".equals(bytesAndKeyType.keyType)) {
            throw new Exception("Expected -----BEGIN PUBLIC KEY-----");
        }
        return KeyConverter.publicKeyFromBytes(bytesAndKeyType.bytes);
    }

    public static String toPkcs8UnencryptedPem(PrivateKey privateKey) {
        byte[] data;
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PRIVATE KEY-----\r\n");
        for (byte b : data = Base64.encodeBase64((byte[])privateKey.getEncoded(), (boolean)true)) {
            sb.append((char)b);
        }
        if (data[data.length - 1] != 10) {
            sb.append("\r\n");
        }
        sb.append("-----END PRIVATE KEY-----\r\n");
        return sb.toString();
    }

    public static String toPkcs8EncryptedPem(PrivateKey privateKey, String passphrase) {
        byte[] data;
        byte[] encryptedPkcs8;
        String alg = "PBEWithSHA1AndDESede";
        int count = 10000;
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[16];
        random.nextBytes(salt);
        try {
            PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, count);
            PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(alg);
            SecretKey pbeKey = keyFac.generateSecret(pbeKeySpec);
            Cipher pbeCipher = Cipher.getInstance(alg);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            byte[] ciphertext = pbeCipher.doFinal(privateKey.getEncoded());
            AlgorithmParameters algparms = AlgorithmParameters.getInstance(alg);
            algparms.init(pbeParamSpec);
            EncryptedPrivateKeyInfo encinfo = new EncryptedPrivateKeyInfo(algparms, ciphertext);
            encryptedPkcs8 = encinfo.getEncoded();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN ENCRYPTED PRIVATE KEY-----\r\n");
        for (byte b : data = Base64.encodeBase64((byte[])encryptedPkcs8, (boolean)true)) {
            sb.append((char)b);
        }
        if (data[data.length - 1] != 10) {
            sb.append("\r\n");
        }
        sb.append("-----END ENCRYPTED PRIVATE KEY-----\r\n");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey privateKeyFromBytes(byte[] bytes, boolean encrypted, String passphrase) throws Exception {
        KeySpec keySpec;
        if (encrypted) {
            if (passphrase == null) {
                throw new Exception("Encrypted key, passphrase required");
            }
            try {
                keySpec = KeyConverter.keySpecFromEncryptedBytes(bytes, passphrase);
            }
            catch (Exception e) {
                throw new Exception("Unable to decrypt private key", e);
            }
        } else {
            keySpec = new PKCS8EncodedKeySpec(bytes);
        }
        try {
            try {
                return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                try {
                    return KeyFactory.getInstance("DSA").generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e2) {
                    throw new Exception("Neither RSA nor DSA private key generator can parse", e2);
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static PrivateKey fromPkcs8Pem(String pem, String passphrase) throws Exception {
        BytesAndKeyType bytesAndKeyType = KeyConverter.readPemFile(new StringReader(pem));
        boolean encrypted = "ENCRYPTED PRIVATE".equals(bytesAndKeyType.keyType);
        if (!encrypted && !"PRIVATE".equals(bytesAndKeyType.keyType)) {
            throw new Exception("Expected -----BEGIN [ENCRYPTED] PRIVATE KEY-----");
        }
        return KeyConverter.privateKeyFromBytes(bytesAndKeyType.bytes, encrypted, passphrase);
    }

    private static KeySpec keySpecFromEncryptedBytes(byte[] bytes, String passphrase) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(bytes);
        Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.getAlgName());
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        SecretKey pbeKey = secretKeyFactory.generateSecret(pbeKeySpec);
        cipher.init(2, (Key)pbeKey, encryptedPrivateKeyInfo.getAlgParameters());
        PKCS8EncodedKeySpec keySpec = encryptedPrivateKeyInfo.getKeySpec(cipher);
        return keySpec;
    }

    private static void printUsageAndExit() {
        System.err.println("arguments: [-crypt] [-passin input-password] [-passout output-password] [-format format] [input-filename] [-o output-filename]");
        System.err.println();
        System.err.println("This utility converts public and private keys multidirectionally between");
        System.err.println("Handle protocol format, JWK format, and standard PEM format: public keys");
        System.err.println("in X.509 SubjectPublicKeyInfo format (with files beginning");
        System.err.println("-----BEGIN PUBLIC KEY-----) and private keys in PKCS#8 PrivateKeyInfo");
        System.err.println("format (with files beginning -----BEGIN PRIVATE KEY----- or");
        System.err.println("-----BEGIN ENCRYPTED PRIVATE KEY-----).");
        System.err.println();
        System.err.println("If input and/or output filename is omitted or -, the utility will use standard");
        System.err.println("input and/or output.");
        System.err.println();
        System.err.println("The -f or -format option can be used to specify the output format.  If omitted");
        System.err.println("Handle protocol format is assumed, unless the input has that format, in which");
        System.err.println("case PEM format is assumed.  Allowed values: jwk, pem, handle.");
        System.err.println();
        System.err.println("The -passin option argument will be used to decrypt an input encrypted private");
        System.err.println("key.  If absent the utility will ask the user for a passphrase.");
        System.err.println();
        System.err.println("If the -crypt option is given with a private key, the utility will encrypt any");
        System.err.println("private key output using the -passout option argument (if present) or using a");
        System.err.println("passphrase obtained by asking the user.");
    }

    KeyConverter(byte[] bytes, boolean encrypt, String format) {
        this.bytes = bytes;
        this.encrypt = encrypt;
        this.format = format;
    }

    public KeyConverter(byte[] bytes, boolean encrypt, String outputFilename, byte[] passIn, byte[] passOut, String format) {
        this.bytes = bytes;
        this.encrypt = encrypt;
        this.outputFilename = outputFilename;
        this.passIn = passIn;
        this.passOut = passOut;
        this.format = format;
    }

    byte[] getPassIn() throws Exception {
        if (this.passIn != null) {
            return this.passIn;
        }
        return Util.getPassphrase("Enter the passphrase to decrypt the input private key: ");
    }

    byte[] getPassOut() throws Exception {
        byte[] secKey2;
        byte[] secKey;
        if (this.passOut != null) {
            return this.passOut;
        }
        while (!Util.equals(secKey = Util.getPassphrase("\nPlease enter the passphrase to encrypt the output private key: "), secKey2 = Util.getPassphrase("\nPlease re-enter the private key passphrase: "))) {
            System.err.println("\nPassphrases do not match!  Try again.\n");
        }
        return secKey;
    }

    private static void convert(String inputFilename, String outputFilename, boolean encrypt, byte[] passIn, byte[] passOut, String format) throws Exception {
        byte[] bytes;
        if (inputFilename == null) {
            bytes = StreamUtil.readFully((InputStream)System.in);
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFilename));){
                bytes = StreamUtil.readFully((InputStream)in);
            }
        }
        new KeyConverter(bytes, encrypt, outputFilename, passIn, passOut, format).convert();
    }

    void convert() throws Exception {
        if (Util.looksLikeBinary(this.bytes)) {
            this.convertFromHs();
        } else {
            this.convertToHs();
        }
    }

    private static boolean isPrivateKey(byte[] bytes) {
        int firstInt = Encoder.readInt(bytes, 0);
        return firstInt < 9;
    }

    private void convertFromHs() throws Exception {
        if (this.format == null) {
            this.format = "pem";
        }
        if (KeyConverter.isPrivateKey(this.bytes)) {
            byte[] secKey = null;
            if (Util.requiresSecretKey(this.bytes)) {
                secKey = this.getPassIn();
            }
            byte[] keyBytes = Util.decrypt(this.bytes, secKey);
            PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes);
            this.outputPrivateKey(privateKey);
        } else {
            PublicKey publicKey = Util.getPublicKeyFromBytes(this.bytes);
            this.outputPublicKey(publicKey);
        }
    }

    private void convertToHs() throws Exception {
        if (this.format == null) {
            this.format = "handle";
        }
        String string = new String(this.bytes, "UTF-8");
        try {
            JsonObject jsonObject = JsonParser.parseString((String)string).getAsJsonObject();
            this.convertJwk(jsonObject);
            return;
        }
        catch (Exception jsonObject) {
            BytesAndKeyType bytesAndKeyType = KeyConverter.readPemFile(new StringReader(string));
            byte[] bytes = bytesAndKeyType.bytes;
            if ("PUBLIC".equals(bytesAndKeyType.keyType)) {
                PublicKey publicKey = KeyConverter.publicKeyFromBytes(bytes);
                this.outputPublicKey(publicKey);
            } else {
                boolean encryptedInput = "ENCRYPTED PRIVATE".equals(bytesAndKeyType.keyType);
                if (!encryptedInput && !"PRIVATE".equals(bytesAndKeyType.keyType)) {
                    throw new Exception("Unrecognized input file");
                }
                String passphrase = null;
                if (encryptedInput) {
                    byte[] secKey = this.getPassIn();
                    passphrase = Util.decodeString(secKey);
                }
                PrivateKey privateKey = KeyConverter.privateKeyFromBytes(bytes, encryptedInput, passphrase);
                this.outputPrivateKey(privateKey);
            }
            return;
        }
    }

    private void convertJwk(JsonObject jwk) throws Exception {
        boolean isPrivate;
        String kty;
        if (this.format == null) {
            this.format = "handle";
        }
        if ("DSA".equalsIgnoreCase(kty = jwk.get("kty").getAsString())) {
            isPrivate = jwk.has("x");
        } else if ("RSA".equalsIgnoreCase(kty)) {
            isPrivate = jwk.has("d");
        } else {
            throw new Exception("Unexpected kty " + kty);
        }
        if (isPrivate) {
            PrivateKey privateKey = (PrivateKey)GsonUtility.getGson().fromJson((JsonElement)jwk, PrivateKey.class);
            this.outputPrivateKey(privateKey);
        } else {
            PublicKey publicKey = (PublicKey)GsonUtility.getGson().fromJson((JsonElement)jwk, PublicKey.class);
            this.outputPublicKey(publicKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputPrivateKey(PrivateKey privateKey) throws Exception {
        if (!this.encrypt) {
            if (this.format.equalsIgnoreCase("pem")) {
                this.sendOutput(KeyConverter.toPkcs8UnencryptedPem(privateKey));
                return;
            } else if (this.format.equalsIgnoreCase("jwk")) {
                this.sendOutput(GsonUtility.getPrettyGson().toJson((Object)privateKey));
                return;
            } else {
                if (!this.format.equalsIgnoreCase("handle")) throw new Exception("Bad format " + this.format);
                this.sendOutput(Util.encrypt(Util.getBytesFromPrivateKey(privateKey), null, 1));
            }
            return;
        } else {
            byte[] secKey = this.getPassOut();
            if (this.format.equalsIgnoreCase("pem")) {
                this.sendOutput(KeyConverter.toPkcs8EncryptedPem(privateKey, Util.decodeString(secKey)));
                return;
            } else if (this.format.equalsIgnoreCase("jwk")) {
                System.err.println("Encrypted private key not possible with format jwk");
                return;
            } else {
                if (!this.format.equalsIgnoreCase("handle")) throw new Exception("Bad format " + this.format);
                this.sendOutput(Util.encrypt(Util.getBytesFromPrivateKey(privateKey), secKey));
            }
        }
    }

    private void outputPublicKey(PublicKey publicKey) throws Exception, HandleException {
        if (this.format.equalsIgnoreCase("pem")) {
            this.sendOutput(KeyConverter.toX509Pem(publicKey));
        } else if (this.format.equalsIgnoreCase("jwk")) {
            this.sendOutput(GsonUtility.getPrettyGson().toJson((Object)publicKey));
        } else if (this.format.equalsIgnoreCase("handle")) {
            this.sendOutput(Util.getBytesFromPublicKey(publicKey));
        } else {
            throw new Exception("Bad format " + this.format);
        }
    }

    void sendOutput(String string) throws Exception {
        if (this.outputFilename == null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            writer.write(string);
            ((Writer)writer).flush();
        } else {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFilename), "UTF-8"));){
                writer.write(string);
            }
        }
    }

    void sendOutput(byte[] bytes) throws Exception {
        if (this.outputFilename == null) {
            BufferedOutputStream out = new BufferedOutputStream(System.out);
            ((OutputStream)out).write(bytes);
            ((OutputStream)out).flush();
        } else {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.outputFilename));){
                ((OutputStream)out).write(bytes);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String format;
        String outputFilename;
        SimpleCommandLine commandLine = new SimpleCommandLine(new String[]{"o", "output", "passin", "passout", "f", "format"});
        commandLine.parse(args);
        if (commandLine.hasOption("h") || commandLine.hasOption("help")) {
            KeyConverter.printUsageAndExit();
            return;
        }
        boolean encrypt = commandLine.hasOption("crypt");
        String passInString = commandLine.getOptionArgument("passin");
        byte[] passIn = null;
        if (passInString != null) {
            passIn = Util.encodeString(passInString);
        }
        String passOutString = commandLine.getOptionArgument("passout");
        byte[] passOut = null;
        if (passOutString != null) {
            passOut = Util.encodeString(passOutString);
        }
        if ((outputFilename = commandLine.getOptionArgument("output")) == null) {
            outputFilename = commandLine.getOptionArgument("o");
        }
        if (outputFilename == null && commandLine.getOperands().size() >= 2) {
            outputFilename = (String)commandLine.getOperands().get(1);
        }
        if ("-".equals(outputFilename)) {
            outputFilename = null;
        }
        String inputFilename = null;
        if (!commandLine.getOperands().isEmpty()) {
            inputFilename = (String)commandLine.getOperands().get(0);
        }
        if ("-".equals(inputFilename)) {
            inputFilename = null;
        }
        if ((format = commandLine.getOptionArgument("format")) == null) {
            format = commandLine.getOptionArgument("f");
        }
        KeyConverter.convert(inputFilename, outputFilename, encrypt, passIn, passOut, format);
    }

    private static class BytesAndKeyType {
        byte[] bytes;
        String keyType;

        public BytesAndKeyType(byte[] bytes, String keyType) {
            this.bytes = bytes;
            this.keyType = keyType;
        }
    }
}

