/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;

public class ServiceHandleAccumulator
implements HandleRecordOperationInterface {
    Map<String, List<String>> rootServiceHandlesMap = new HashMap<String, List<String>>();

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        List<HandleValue> servValues = BatchUtil.getValuesOfType(values, "HS_SERV");
        for (HandleValue servValue : servValues) {
            String serviceHandle = servValue.getDataAsString();
            this.add(serviceHandle, handle);
        }
    }

    private void add(String serviceHandle, String handle) {
        List<String> serviceUsers = this.rootServiceHandlesMap.get(serviceHandle);
        if (serviceUsers == null) {
            serviceUsers = new ArrayList<String>();
            this.rootServiceHandlesMap.put(serviceHandle, serviceUsers);
        }
        serviceUsers.add(handle);
    }

    public Map<String, List<String>> getRootServiceHandlesMap() {
        return this.rootServiceHandlesMap;
    }
}

