/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class HsAdminModifierOperation
implements HandleRecordOperationInterface {
    public String oldAdmin;
    public int oldAdminIndex;
    public String replacementAdmin;
    public int replacementAdminIndex;

    public HsAdminModifierOperation(String oldAdmin, int oldAdminIndex, String replacementAdmin, int replacementAdminIndex) {
        this.oldAdmin = oldAdmin;
        this.oldAdminIndex = oldAdminIndex;
        this.replacementAdmin = replacementAdmin;
        this.replacementAdminIndex = replacementAdminIndex;
    }

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        List<HandleValue> hsAdmins = BatchUtil.getValuesOfType(values, "HS_ADMIN");
        if (hsAdmins.size() != 1) {
            throw new HandleException(0, handle + " has does not have exactly 1 admin value.");
        }
        HandleValue hsAdmin = hsAdmins.get(0);
        int indexOfThisHsAdminValue = hsAdmin.getIndex();
        AdminRecord adminRecord = Encoder.decodeAdminRecord(hsAdmin.getData(), 0);
        byte[] currentAdminIdBytes = adminRecord.adminId;
        String currentAdmin = Util.decodeString(currentAdminIdBytes);
        int currentAdminIndex = adminRecord.adminIdIndex;
        if (!this.oldAdmin.equals(currentAdmin) || this.oldAdminIndex != currentAdminIndex) {
            return;
        }
        adminRecord.adminIdIndex = this.replacementAdminIndex;
        adminRecord.adminId = Util.encodeString(this.replacementAdmin);
        byte[] replacementBytes = Encoder.encodeAdminRecord(adminRecord);
        HandleValue replacementHandleValue = new HandleValue();
        replacementHandleValue.setIndex(indexOfThisHsAdminValue);
        replacementHandleValue.setType(Common.ADMIN_TYPE);
        replacementHandleValue.setData(replacementBytes);
        AbstractResponse response = BatchUtil.modifyHandleValue(handle, replacementHandleValue, resolver, authInfo, site);
        if (response.responseCode != 1) {
            throw new HandleException(1, response.toString());
        }
    }
}

