/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch;

import java.util.ArrayList;
import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ListNAsRequest;
import net.handle.hdllib.ListNAsResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ListPrefixesUtil {
    private final SiteInfo site;
    private final AuthenticationInfo authInfo;
    private final HandleResolver resolver;

    public ListPrefixesUtil(SiteInfo site, AuthenticationInfo authInfo, HandleResolver resolver) {
        this.site = site;
        this.authInfo = authInfo;
        this.resolver = resolver;
    }

    public List<String> getAllPrefixes() throws HandleException {
        ListNAsRequest request = new ListNAsRequest(Common.BLANK_HANDLE, this.authInfo);
        ListHandlesAccumulator handlesAccumulator = new ListHandlesAccumulator();
        AbstractResponse response = this.resolver.sendRequestToSite((AbstractRequest)request, this.site, handlesAccumulator);
        BatchUtil.throwIfNotSuccess(response);
        List<String> allPrefixes = handlesAccumulator.handlesList;
        return allPrefixes;
    }

    public static class ListHandlesAccumulator
    implements ResponseMessageCallback {
        public List<String> handlesList = new ArrayList<String>();

        @Override
        public void handleResponse(AbstractResponse response) throws HandleException {
            if (response.responseCode == 1) {
                byte[][] handles;
                for (byte[] handleBytes : handles = ((ListNAsResponse)response).handles) {
                    String handle = Util.decodeString(handleBytes);
                    this.handlesList.add(handle);
                }
            }
        }
    }
}

