/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.Map;
import net.cnri.util.StreamObject;
import net.cnri.util.StreamTable;
import net.cnri.util.StreamVector;

public class JsonToStreamObjectConverter {
    public static StreamObject toStreamObject(JsonElement jsonElement) {
        Cloneable result = null;
        result = jsonElement.isJsonObject() ? JsonToStreamObjectConverter.toStreamTable((JsonObject)jsonElement) : JsonToStreamObjectConverter.toStreamVector((JsonArray)jsonElement);
        return result;
    }

    private static StreamTable toStreamTable(JsonObject jsonObject) {
        StreamTable streamTable = new StreamTable();
        for (Map.Entry properties : jsonObject.entrySet()) {
            String key = (String)properties.getKey();
            JsonElement value = (JsonElement)properties.getValue();
            if (value.isJsonObject() || value.isJsonArray()) {
                StreamObject childObject = JsonToStreamObjectConverter.toStreamObject(value);
                streamTable.put(key, childObject);
                continue;
            }
            if (!value.isJsonPrimitive()) continue;
            JsonPrimitive jsonPrimitive = value.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                String stringValue = value.getAsJsonPrimitive().getAsString();
                streamTable.put(key, stringValue);
                continue;
            }
            if (jsonPrimitive.isBoolean()) {
                boolean booleanValue = jsonPrimitive.getAsBoolean();
                streamTable.put(key, booleanValue);
                continue;
            }
            if (jsonPrimitive.isNumber()) {
                BigDecimal number = jsonPrimitive.getAsBigDecimal();
                String numberAsString = number.toPlainString();
                streamTable.put(key, numberAsString);
                continue;
            }
            if (!jsonPrimitive.isJsonNull()) continue;
            streamTable.put(key, "null");
        }
        return streamTable;
    }

    private static StreamVector toStreamVector(JsonArray jsonArray) {
        StreamVector streamVector = new StreamVector();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement item = jsonArray.get(i);
            if (item.isJsonObject() || item.isJsonArray()) {
                StreamObject childObject = JsonToStreamObjectConverter.toStreamObject(item);
                streamVector.add(childObject);
                continue;
            }
            if (!item.isJsonPrimitive()) continue;
            JsonPrimitive jsonPrimitive = item.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                String stringValue = item.getAsJsonPrimitive().getAsString();
                streamVector.add(stringValue);
                continue;
            }
            if (jsonPrimitive.isBoolean()) {
                boolean booleanValue = jsonPrimitive.getAsBoolean();
                streamVector.add(String.valueOf(booleanValue));
                continue;
            }
            if (jsonPrimitive.isNumber()) {
                BigDecimal number = jsonPrimitive.getAsBigDecimal();
                String numberAsString = number.toPlainString();
                streamVector.add(numberAsString);
                continue;
            }
            if (!jsonPrimitive.isJsonNull()) continue;
            streamVector.add("null");
        }
        return streamVector;
    }
}

