/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipSegment;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.util.InDoipMessageUtil;

public class ErrorMessageUtil {
    public static String getMessageFromErrorResponse(DoipClientResponse resp) throws IOException {
        JsonElement response = ErrorMessageUtil.getJsonResponseFromErrorResponse(resp);
        if (response != null && response.isJsonObject() && response.getAsJsonObject().has("message")) {
            return response.getAsJsonObject().get("message").getAsString();
        }
        return "DOIP Error: " + resp.getStatus();
    }

    public static JsonElement getJsonResponseFromErrorResponse(DoipClientResponse resp) throws IOException {
        try (InDoipMessage in = resp.getOutput();){
            InDoipSegment firstSegment;
            if (in != null && (firstSegment = InDoipMessageUtil.getFirstSegment(in)) != null) {
                JsonElement el;
                JsonElement jsonElement = el = firstSegment.getJson();
                return jsonElement;
            }
            JsonObject jsonObject = resp.getAttributes();
            return jsonObject;
        }
    }
}

