/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.Writer;
import net.dona.doip.DoipResponseHeadersWithRequestId;
import net.dona.doip.OutDoipMessage;
import net.dona.doip.server.DoipServerResponse;
import net.dona.doip.util.GsonUtility;

public class DoipServerResponseImpl
implements DoipServerResponse {
    private final OutDoipMessage outDoipMessage;
    private final String requestId;
    private String status = "0.DOIP/Status.001";
    private JsonObject attributes;
    private boolean wroteCompactOutput;
    private boolean committed;

    public DoipServerResponseImpl(String requestId, OutDoipMessage outDoipMessage) {
        this.requestId = requestId;
        this.outDoipMessage = outDoipMessage;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public void setAttribute(String key, JsonElement value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.add(key, value);
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(key, value);
    }

    @Override
    public void setAttributes(JsonObject attributes) {
        this.attributes = attributes;
    }

    @Override
    public JsonObject getAttributes() {
        return this.attributes;
    }

    @Override
    public void commit() throws IOException {
        if (this.wroteCompactOutput || this.committed) {
            return;
        }
        this.committed = true;
        this.writeInitialSegment(null);
    }

    protected void writeInitialSegment(JsonElement output) throws IOException {
        DoipResponseHeadersWithRequestId segment = new DoipResponseHeadersWithRequestId();
        segment.requestId = this.requestId;
        segment.status = this.status;
        segment.attributes = this.attributes;
        segment.output = output;
        try (Writer writer = this.outDoipMessage.getJsonWriter();){
            GsonUtility.getGson().toJson((Object)segment, (Appendable)writer);
        }
        catch (JsonParseException e) {
            throw new IOException("Error writing initial segment", e);
        }
    }

    @Override
    public void writeCompactOutput(JsonElement output) throws IOException {
        if (this.wroteCompactOutput) {
            throw new IllegalStateException("already wrote compact output");
        }
        if (this.committed) {
            throw new IllegalStateException("already committed");
        }
        this.wroteCompactOutput = true;
        this.writeInitialSegment(output);
        this.outDoipMessage.close();
    }

    @Override
    public OutDoipMessage getOutput() throws IOException {
        if (this.wroteCompactOutput) {
            throw new IllegalStateException("already wrote compact output");
        }
        if (!this.committed) {
            this.committed = true;
            this.writeInitialSegment(null);
        }
        return this.outDoipMessage;
    }
}

