/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.server;

import com.google.gson.JsonObject;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class DoipServerConfig {
    public String listenAddress;
    public List<String> listenAddresses = new ArrayList<String>();
    public int port;
    public int backlog = 50;
    public int maxIdleTimeMillis = 300000;
    public int numThreads = 200;
    public String processorClass;
    public JsonObject processorConfig;
    public LogConfig logConfig;
    public TlsConfig tlsConfig;

    public int hashCode() {
        return Objects.hash(this.backlog, this.listenAddress, this.listenAddresses, this.maxIdleTimeMillis, this.numThreads, this.port, this.processorClass, this.processorConfig, this.tlsConfig, this.logConfig);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoipServerConfig other = (DoipServerConfig)obj;
        return this.backlog == other.backlog && Objects.equals(this.listenAddress, other.listenAddress) && Objects.equals(this.listenAddresses, other.listenAddresses) && this.maxIdleTimeMillis == other.maxIdleTimeMillis && this.numThreads == other.numThreads && this.port == other.port && Objects.equals(this.processorClass, other.processorClass) && Objects.equals(this.processorConfig, other.processorConfig) && Objects.equals(this.tlsConfig, other.tlsConfig) && Objects.equals(this.logConfig, other.logConfig);
    }

    public static class TlsConfig {
        public String id;
        public PublicKey publicKey;
        public PrivateKey privateKey;
        public X509Certificate[] certificateChain;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.certificateChain);
            result = 31 * result + Objects.hash(this.id, this.privateKey, this.publicKey);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TlsConfig other = (TlsConfig)obj;
            return Arrays.equals(this.certificateChain, other.certificateChain) && Objects.equals(this.id, other.id) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.publicKey, other.publicKey);
        }
    }

    public static class LogConfig {
        public boolean logAccesses = false;
        public String loggerName = "doipAccessLogger";

        public int hashCode() {
            return Objects.hash(this.logAccesses, this.loggerName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogConfig other = (LogConfig)obj;
            return Objects.equals(this.logAccesses, other.logAccesses) && Objects.equals(this.loggerName, other.loggerName);
        }
    }
}

