/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import java.util.Collections;
import java.util.List;
import net.dona.doip.client.FacetSpecification;
import net.dona.doip.client.SortField;

public class QueryParams {
    public static final QueryParams DEFAULT = new QueryParams();
    private final List<SortField> sortFields;
    private final int pageNum;
    private final int pageSize;
    private final List<FacetSpecification> facets;

    public QueryParams() {
        this(0, -1);
    }

    public QueryParams(int pageNum, int pageSize) {
        this(pageNum, pageSize, Collections.emptyList());
    }

    public QueryParams(int pageNum, int pageSize, List<SortField> sortFields) {
        this(pageNum, pageSize, sortFields, Collections.emptyList());
    }

    public QueryParams(int pageNum, int pageSize, List<SortField> sortFields, List<FacetSpecification> facets) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.sortFields = sortFields;
        this.facets = facets;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<SortField> getSortFields() {
        return this.sortFields;
    }

    public List<FacetSpecification> getFacets() {
        return this.facets;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int pageNum = 0;
        private int pageSize = -1;
        private List<SortField> sortFields = Collections.emptyList();
        private List<FacetSpecification> facets = Collections.emptyList();

        public Builder pageNum(int pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder sortFields(List<SortField> sortFields) {
            this.sortFields = sortFields;
            return this;
        }

        public Builder facets(List<FacetSpecification> facets) {
            this.facets = facets;
            return this;
        }

        public QueryParams build() {
            return new QueryParams(this.pageNum, this.pageSize, this.sortFields, this.facets);
        }
    }
}

