/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.gson.JsonArray;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.dona.doip.BadDoipException;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipSegment;
import net.dona.doip.client.DigitalObject;
import net.dona.doip.client.DoipException;
import net.dona.doip.client.SearchResults;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.util.GsonUtility;
import net.dona.doip.util.InDoipMessageUtil;

public class DoipSearchResults<T>
implements SearchResults<T> {
    private final DoipClientResponse resp;
    private final InDoipMessage in;
    private final JsonReader jsonReader;
    private final Class<T> klass;
    private final int size;
    private JsonArray facets;
    private boolean closed = false;

    public DoipSearchResults(DoipClientResponse resp, Class<T> klass) throws IOException {
        this.klass = klass;
        this.resp = resp;
        this.in = resp.getOutput();
        InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(this.in);
        if (firstSegment == null) {
            throw new BadDoipException("Missing input");
        }
        InputStream inputStream = firstSegment.getInputStream();
        InputStreamReader isr = new InputStreamReader(inputStream, "UTF-8");
        this.jsonReader = new JsonReader((Reader)isr);
        this.jsonReader.beginObject();
        int size = -1;
        while (this.jsonReader.hasNext()) {
            String name = this.jsonReader.nextName();
            if ("size".equals(name)) {
                size = this.jsonReader.nextInt();
                continue;
            }
            if ("facets".equals(name)) {
                this.facets = this.readFacets();
                continue;
            }
            if ("results".equals(name)) {
                this.jsonReader.beginArray();
                break;
            }
            this.jsonReader.nextString();
        }
        this.size = size;
    }

    private JsonArray readFacets() {
        JsonArray result = (JsonArray)GsonUtility.getGson().fromJson(this.jsonReader, JsonArray.class);
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public JsonArray getFacets() {
        return this.facets;
    }

    @Override
    public Iterator<T> iterator() {
        return new DoipMessageIterator();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.resp != null) {
                try {
                    this.resp.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class DoipMessageIterator
    implements Iterator<T> {
        private Boolean hasNextResult;

        private DoipMessageIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.hasNextResult != null) {
                return this.hasNextResult;
            }
            if (DoipSearchResults.this.closed) {
                throw new IllegalStateException("Already closed");
            }
            try {
                boolean res = DoipSearchResults.this.jsonReader.hasNext();
                this.hasNextResult = res;
                if (!res) {
                    DoipSearchResults.this.close();
                }
                return res;
            }
            catch (IOException e) {
                throw new RuntimeException(new DoipException(e));
            }
        }

        @Override
        public T next() {
            if (this.hasNextResult == null) {
                this.hasNext();
            }
            if (!this.hasNextResult.booleanValue()) {
                throw new NoSuchElementException();
            }
            this.hasNextResult = null;
            try {
                if (DoipSearchResults.this.klass == DigitalObject.class) {
                    DigitalObject dobj = (DigitalObject)net.handle.hdllib.GsonUtility.getGson().fromJson(DoipSearchResults.this.jsonReader, DigitalObject.class);
                    return dobj;
                }
                if (DoipSearchResults.this.klass == String.class) {
                    String handle = DoipSearchResults.this.jsonReader.nextString();
                    return handle;
                }
                throw new AssertionError((Object)("Unexpected class " + DoipSearchResults.this.klass));
            }
            catch (Exception e) {
                throw new RuntimeException(new DoipException(e));
            }
        }
    }
}

