/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.client.AbstractDoipClient;
import net.dona.doip.client.ConnectionAndPool;
import net.dona.doip.client.DigitalObject;
import net.dona.doip.client.DoipException;
import net.dona.doip.client.ServiceInfo;
import net.dona.doip.client.transport.ConnectionOptions;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.DoipConnectionPool;
import net.dona.doip.client.transport.TransportDoipClient;
import net.dona.doip.util.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoipClient
extends AbstractDoipClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DoipClient.class);
    private static final String DOIP_SERVICE_INFO = "DOIPServiceInfo";
    private static final String TYPE_DOIP_SERVICE_INFO = "0.TYPE/DOIPServiceInfo";
    private static final String DOIP_SERVICE = "DOIPService";
    private static final String TYPE_DOIP_SERVICE = "0.TYPE/DOIPService";
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_HOP_COUNT = 20;
    private final Cache<String, ServiceInfoAndPool> serviceHandleToPoolsMap;
    private final Cache<String, String> targetIdToServiceHandleMap;
    private final TransportDoipClient doipClient = new TransportDoipClient();
    private final HandleResolver resolver = new HandleResolver();
    private boolean closed;

    public DoipClient() {
        this.serviceHandleToPoolsMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).removalListener((RemovalListener)new PoolRemovalListener()).build();
        this.targetIdToServiceHandleMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        for (ServiceInfoAndPool serviceInfoAndPool : this.serviceHandleToPoolsMap.asMap().values()) {
            try {
                serviceInfoAndPool.pool.shutdown();
            }
            catch (Exception e) {
                logger.warn("Error closing", (Throwable)e);
            }
        }
        try {
            this.doipClient.close();
        }
        catch (Exception e) {
            logger.warn("Error closing", (Throwable)e);
        }
    }

    @Override
    public DoipClientResponse performOperation(DoipRequestHeaders headers, InDoipMessage input, ServiceInfo serviceInfo) throws DoipException {
        ConnectionAndPool connectionAndPool = this.connectionAndPoolForOptions(serviceInfo, headers.targetId);
        return this.performOperationWithConnection(headers, input, connectionAndPool);
    }

    private ConnectionAndPool connectionAndPoolForOptions(ServiceInfo serviceInfo, String targetId) throws DoipException {
        ConnectionAndPool connectionAndPool;
        if (serviceInfo == null) {
            connectionAndPool = this.getConnectionFor(targetId);
        } else if (serviceInfo.ipAddress != null) {
            ServiceInfoAndPool serviceInfoAndPool = this.getOrCreatePool(serviceInfo);
            connectionAndPool = new ConnectionAndPool(serviceInfoAndPool.pool);
        } else if (serviceInfo.serviceId != null) {
            connectionAndPool = this.getConnectionFor(serviceInfo.serviceId);
        } else {
            throw new DoipException("Missing options");
        }
        return connectionAndPool;
    }

    private DoipClientResponse performOperationWithConnection(DoipRequestHeaders headers, InDoipMessage input, ConnectionAndPool connectionAndPool) throws DoipException {
        DoipClientResponse response;
        DoipConnection conn = connectionAndPool.getConnection();
        try {
            response = input != null ? conn.sendRequest(headers, input) : conn.sendCompactRequest(headers);
        }
        catch (Exception e) {
            try {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
                connectionAndPool.releaseConnection();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            throw new DoipException(e);
        }
        response.setOnClose(() -> {
            try {
                connectionAndPool.releaseConnection();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        return response;
    }

    private ConnectionAndPool getConnectionFor(String targetId) throws DoipException {
        ServiceInfoAndPool serviceInfoAndPool;
        String serviceHandle = (String)this.targetIdToServiceHandleMap.getIfPresent((Object)targetId);
        if (serviceHandle == null) {
            serviceInfoAndPool = this.getServiceInfoAndPoolFor(targetId);
            this.targetIdToServiceHandleMap.put((Object)targetId, (Object)serviceInfoAndPool.serviceInfo.serviceId);
        } else {
            serviceInfoAndPool = (ServiceInfoAndPool)this.serviceHandleToPoolsMap.getIfPresent((Object)serviceHandle);
            if (serviceInfoAndPool == null) {
                serviceInfoAndPool = this.getServiceInfoAndPoolFor(serviceHandle);
            }
        }
        ConnectionAndPool result = new ConnectionAndPool(serviceInfoAndPool.pool);
        return result;
    }

    private ServiceInfoAndPool getServiceInfoAndPoolFor(String handle) throws DoipException {
        try {
            ServiceInfo serviceInfo = this.getServiceInfoFor(handle, 0);
            if (serviceInfo == null) {
                throw new DoipException("DOIPServiceInfo not found for " + handle);
            }
            ServiceInfoAndPool serviceInfoAndPool = this.getOrCreatePool(serviceInfo);
            return serviceInfoAndPool;
        }
        catch (HandleException he) {
            throw new DoipException(he);
        }
    }

    private synchronized ServiceInfoAndPool getOrCreatePool(ServiceInfo serviceInfo) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        ServiceInfoAndPool serviceInfoAndPool = (ServiceInfoAndPool)this.serviceHandleToPoolsMap.getIfPresent((Object)serviceInfo.serviceId);
        if (serviceInfoAndPool == null) {
            DoipConnectionPool pool = new DoipConnectionPool(100, this.doipClient, this.connectionOptionsForServiceInfo(serviceInfo));
            serviceInfoAndPool = new ServiceInfoAndPool(serviceInfo, pool);
            this.serviceHandleToPoolsMap.put((Object)serviceInfo.serviceId, (Object)serviceInfoAndPool);
        }
        return serviceInfoAndPool;
    }

    private ConnectionOptions connectionOptionsForServiceInfo(ServiceInfo serviceInfo) {
        ConnectionOptions res = new ConnectionOptions();
        res.serverId = serviceInfo.serviceId;
        res.address = serviceInfo.ipAddress;
        res.port = serviceInfo.port;
        if (serviceInfo.publicKey != null) {
            res.trustedServerPublicKeys = Collections.singletonList(serviceInfo.publicKey);
        }
        return res;
    }

    private ServiceInfo getServiceInfoFor(String handle, int hopCount) throws HandleException {
        String type;
        HandleValue[] values;
        for (HandleValue value : values = this.resolver.resolveHandle(handle, new String[]{DOIP_SERVICE, TYPE_DOIP_SERVICE, DOIP_SERVICE_INFO, TYPE_DOIP_SERVICE_INFO}, null)) {
            type = value.getTypeAsString();
            if (!DOIP_SERVICE_INFO.equals(type) && !TYPE_DOIP_SERVICE_INFO.equals(type)) continue;
            String json = value.getDataAsString();
            DigitalObject dobj = (DigitalObject)GsonUtility.getGson().fromJson(json, DigitalObject.class);
            ServiceInfo result = (ServiceInfo)GsonUtility.getGson().fromJson((JsonElement)dobj.attributes, ServiceInfo.class);
            result.serviceId = handle;
            return result;
        }
        for (HandleValue value : values) {
            type = value.getTypeAsString();
            if (!DOIP_SERVICE.equals(type) && !TYPE_DOIP_SERVICE.equals(type)) continue;
            String doipServiceHandle = value.getDataAsString();
            if (hopCount >= 20) {
                return null;
            }
            return this.getServiceInfoFor(doipServiceHandle, hopCount + 1);
        }
        return null;
    }

    private static class PoolRemovalListener
    implements RemovalListener<String, ServiceInfoAndPool> {
        private PoolRemovalListener() {
        }

        public void onRemoval(RemovalNotification<String, ServiceInfoAndPool> notification) {
            ServiceInfoAndPool serviceInfoAndPool = (ServiceInfoAndPool)notification.getValue();
            serviceInfoAndPool.pool.shutdown();
        }
    }

    private static class ServiceInfoAndPool {
        public final ServiceInfo serviceInfo;
        public final DoipConnectionPool pool;

        public ServiceInfoAndPool(ServiceInfo serviceInfo, DoipConnectionPool pool) {
            this.serviceInfo = serviceInfo;
            this.pool = pool;
        }
    }
}

