/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.dona.doip.BadDoipException;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipMessageFromCollection;
import net.dona.doip.InDoipSegment;
import net.dona.doip.InDoipSegmentFromInputStream;
import net.dona.doip.InDoipSegmentFromJson;
import net.dona.doip.client.AuthenticationInfo;
import net.dona.doip.client.DelegatedCloseableInputStream;
import net.dona.doip.client.DigitalObject;
import net.dona.doip.client.DoipClientInterface;
import net.dona.doip.client.DoipException;
import net.dona.doip.client.DoipSearchResults;
import net.dona.doip.client.Element;
import net.dona.doip.client.FacetSpecification;
import net.dona.doip.client.QueryParams;
import net.dona.doip.client.SearchResults;
import net.dona.doip.client.ServiceInfo;
import net.dona.doip.client.SortField;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.util.ErrorMessageUtil;
import net.dona.doip.util.GsonUtility;
import net.dona.doip.util.InDoipMessageUtil;

public abstract class AbstractDoipClient
implements DoipClientInterface {
    @Override
    public void close() {
    }

    @Override
    public JsonElement performOperationWithJsonResponse(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException {
        return this.performOperationWithJsonResponse(targetId, operationId, authInfo, attributes, null);
    }

    @Override
    public JsonElement performOperationWithJsonResponse(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, ServiceInfo serviceInfo) throws DoipException {
        return this.performOperationWithJsonResponse(targetId, operationId, authInfo, attributes, null, serviceInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonElement performOperationWithJsonResponse(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input, ServiceInfo serviceInfo) throws DoipException {
        try (DoipClientResponse response = this.performOperation(targetId, operationId, authInfo, attributes, input, serviceInfo);){
            if (!response.getStatus().equals("0.DOIP/Status.001")) throw AbstractDoipClient.doipExceptionFromDoipResponse(response);
            try (InDoipMessage in = response.getOutput();){
                JsonElement json;
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new BadDoipException("Missing input");
                }
                if (!firstSegment.isJson()) {
                    throw new DoipException("Missing expected JSON first segment");
                }
                JsonElement jsonElement = json = firstSegment.getJson();
                return jsonElement;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    @Override
    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException {
        DoipRequestHeaders headers = AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, null);
    }

    @Override
    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input) throws DoipException {
        DoipRequestHeaders headers = AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes, input);
        return this.performOperation(headers, null);
    }

    @Override
    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, InDoipMessage input) throws DoipException {
        DoipRequestHeaders headers = AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, input);
    }

    @Override
    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, ServiceInfo serviceInfo) throws DoipException {
        DoipRequestHeaders headers = AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, null, serviceInfo);
    }

    @Override
    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input, ServiceInfo serviceInfo) throws DoipException {
        DoipRequestHeaders headers = AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes, input);
        return this.performOperation(headers, null, serviceInfo);
    }

    @Override
    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, InDoipMessage input, ServiceInfo serviceInfo) throws DoipException {
        DoipRequestHeaders headers = AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, input, serviceInfo);
    }

    @Override
    public DoipClientResponse performOperation(DoipRequestHeaders headers, InDoipMessage input) throws DoipException {
        return this.performOperation(headers, input, null);
    }

    @Override
    public abstract DoipClientResponse performOperation(DoipRequestHeaders var1, InDoipMessage var2, ServiceInfo var3) throws DoipException;

    @Override
    public DigitalObject create(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.create(dobj, authInfo, serviceInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DigitalObject create(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException {
        String targetId = serviceInfo != null && serviceInfo.serviceId != null ? serviceInfo.serviceId : "service";
        try (InDoipMessage inMessage = this.buildCreateOrUpdateMessageFrom(dobj, false);
             DoipClientResponse resp = this.performOperation(targetId, "0.DOIP/Op.Create", authInfo, attributes, inMessage, serviceInfo);){
            if (!resp.getStatus().equals("0.DOIP/Status.001")) throw AbstractDoipClient.doipExceptionFromDoipResponse(resp);
            try (InDoipMessage in = resp.getOutput();){
                DigitalObject resultDo;
                DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                return digitalObject;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    private InDoipMessage buildCreateOrUpdateMessageFrom(DigitalObject dobj, boolean isUpdate) {
        JsonObject dobjJson = GsonUtility.getGson().toJsonTree((Object)dobj).getAsJsonObject();
        ArrayList<InDoipSegment> segments = new ArrayList<InDoipSegment>();
        InDoipSegmentFromJson dobjSegment = new InDoipSegmentFromJson((JsonElement)dobjJson);
        segments.add(dobjSegment);
        if (dobj.elements != null) {
            for (Element el : dobj.elements) {
                if (isUpdate && el.in == null) continue;
                JsonObject elementSegmentJson = new JsonObject();
                elementSegmentJson.addProperty("id", el.id);
                InDoipSegmentFromJson elementHeaderSegment = new InDoipSegmentFromJson((JsonElement)elementSegmentJson);
                segments.add(elementHeaderSegment);
                InDoipSegmentFromInputStream elementBytesSegment = new InDoipSegmentFromInputStream(false, el.in);
                segments.add(elementBytesSegment);
            }
        }
        return new InDoipMessageFromCollection(segments);
    }

    @Override
    public DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo) throws DoipException {
        return this.update(dobj, authInfo, null);
    }

    @Override
    public DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.update(dobj, authInfo, serviceInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException {
        try (InDoipMessage inMessage = this.buildCreateOrUpdateMessageFrom(dobj, true);
             DoipClientResponse resp = this.performOperation(dobj.id, "0.DOIP/Op.Update", authInfo, attributes, inMessage, serviceInfo);){
            if (!resp.getStatus().equals("0.DOIP/Status.001")) throw AbstractDoipClient.doipExceptionFromDoipResponse(resp);
            try (InDoipMessage in = resp.getOutput();){
                DigitalObject resultDo;
                DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                return digitalObject;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    @Override
    public DigitalObject retrieve(String targetId, AuthenticationInfo authInfo) throws DoipException {
        return this.retrieve(targetId, false, authInfo, null);
    }

    @Override
    public DigitalObject retrieve(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.retrieve(targetId, false, authInfo, serviceInfo);
    }

    @Override
    public DigitalObject retrieve(String targetId, boolean includeElementData, AuthenticationInfo authInfo) throws DoipException {
        return this.retrieve(targetId, includeElementData, authInfo, null);
    }

    @Override
    public DigitalObject retrieve(String targetId, boolean includeElementData, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonObject attributes = new JsonObject();
        if (includeElementData) {
            attributes.addProperty("includeElementData", Boolean.valueOf(includeElementData));
        }
        return this.retrieve(targetId, attributes, authInfo, serviceInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DigitalObject retrieve(String targetId, JsonObject attributes, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        try (DoipClientResponse response = this.performOperation(targetId, "0.DOIP/Op.Retrieve", authInfo, attributes, serviceInfo);){
            if (response.getStatus().equals("0.DOIP/Status.001")) {
                try (InDoipMessage in = response.getOutput();){
                    DigitalObject resultDo;
                    DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                    return digitalObject;
                }
            }
            if (!response.getStatus().equals("0.DOIP/Status.104")) throw AbstractDoipClient.doipExceptionFromDoipResponse(response);
            DigitalObject digitalObject = null;
            return digitalObject;
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    @Override
    public void delete(String targetId, AuthenticationInfo authInfo) throws DoipException {
        this.delete(targetId, authInfo, null);
    }

    @Override
    public void delete(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        this.delete(targetId, authInfo, serviceInfo, null);
    }

    @Override
    public void delete(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException {
        JsonElement input = null;
        try (DoipClientResponse resp = this.performOperation(targetId, "0.DOIP/Op.Delete", authInfo, attributes, input, serviceInfo);){
            if (resp.getStatus().equals("0.DOIP/Status.001")) {
                return;
            }
            throw AbstractDoipClient.doipExceptionFromDoipResponse(resp);
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    @Override
    public List<String> listOperations(String targetId, AuthenticationInfo authInfo) throws DoipException {
        return this.listOperations(targetId, authInfo, null);
    }

    @Override
    public List<String> listOperations(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.listOperations(targetId, authInfo, serviceInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> listOperations(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException {
        JsonElement input = null;
        try (DoipClientResponse resp = this.performOperation(targetId, "0.DOIP/Op.ListOperations", authInfo, attributes, input, serviceInfo);){
            if (!resp.getStatus().equals("0.DOIP/Status.001")) throw AbstractDoipClient.doipExceptionFromDoipResponse(resp);
            try (InDoipMessage in = resp.getOutput();){
                List results;
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new DoipException("Missing first segment in response");
                }
                List list = results = (List)GsonUtility.getGson().fromJson(firstSegment.getJson(), new TypeToken<List<String>>(){}.getType());
                return list;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    @Override
    public SearchResults<String> searchIds(String targetId, String query, QueryParams params, AuthenticationInfo authInfo) throws DoipException {
        return this.searchIds(targetId, query, params, authInfo, null);
    }

    @Override
    public SearchResults<String> searchIds(String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.searchIdsOrFull("id", String.class, targetId, query, params, authInfo, serviceInfo);
    }

    @Override
    public SearchResults<DigitalObject> search(String targetId, String query, QueryParams params, AuthenticationInfo authInfo) throws DoipException {
        return this.search(targetId, query, params, authInfo, null);
    }

    @Override
    public SearchResults<DigitalObject> search(String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.searchIdsOrFull("full", DigitalObject.class, targetId, query, params, authInfo, serviceInfo);
    }

    private <T> SearchResults<T> searchIdsOrFull(String type, Class<T> klass, String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        DoipClientResponse resp = null;
        try {
            JsonObject attributes = AbstractDoipClient.getSearchAttributes(type, query, params);
            resp = this.performOperation(targetId, "0.DOIP/Op.Search", authInfo, attributes, serviceInfo);
            if (resp.getStatus().equals("0.DOIP/Status.001")) {
                return new DoipSearchResults<T>(resp, klass);
            }
            throw AbstractDoipClient.doipExceptionFromDoipResponse(resp);
        }
        catch (Exception e) {
            AbstractDoipClient.closeQuietly(resp);
            if (e instanceof DoipException) {
                throw (DoipException)e;
            }
            throw new DoipException(e);
        }
    }

    private static void closeQuietly(DoipClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static JsonObject getSearchAttributes(String type, String query, QueryParams params) {
        String sortFields;
        if (params == null) {
            params = QueryParams.DEFAULT;
        }
        JsonObject attributes = new JsonObject();
        attributes.addProperty("query", query);
        attributes.addProperty("pageNum", (Number)params.getPageNum());
        attributes.addProperty("pageSize", (Number)params.getPageSize());
        if (type == null) {
            type = "full";
        }
        attributes.addProperty("type", type);
        if (params.getSortFields() != null && (sortFields = AbstractDoipClient.sortFieldsToString(params.getSortFields())) != null) {
            attributes.addProperty("sortFields", sortFields);
        }
        try {
            List<FacetSpecification> facets = params.getFacets();
            if (facets != null && !facets.isEmpty()) {
                attributes.add("facets", GsonUtility.getGson().toJsonTree(facets));
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
        return attributes;
    }

    private static String sortFieldsToString(List<SortField> sortFields) {
        if (sortFields != null && !sortFields.isEmpty()) {
            ArrayList<String> sortFieldsForTransport = new ArrayList<String>(sortFields.size());
            for (SortField sortField : sortFields) {
                if (sortField.isReverse()) {
                    sortFieldsForTransport.add(sortField.getName() + " DESC");
                    continue;
                }
                sortFieldsForTransport.add(sortField.getName());
            }
            if (!sortFieldsForTransport.isEmpty()) {
                return String.join((CharSequence)",", sortFieldsForTransport);
            }
        }
        return null;
    }

    @Override
    public DigitalObject hello(String targetId, AuthenticationInfo authInfo) throws DoipException {
        return this.hello(targetId, authInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DigitalObject hello(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonElement input = null;
        try (DoipClientResponse response = this.performOperation(targetId, "0.DOIP/Op.Hello", authInfo, null, input, serviceInfo);){
            if (!response.getStatus().equals("0.DOIP/Status.001")) throw AbstractDoipClient.doipExceptionFromDoipResponse(response);
            try (InDoipMessage in = response.getOutput();){
                DigitalObject resultDo;
                DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                return digitalObject;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    @Override
    public InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo) throws DoipException {
        return this.retrieveElement(targetId, elementId, authInfo, null);
    }

    @Override
    public InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.retrieveElement(targetId, elementId, authInfo, serviceInfo, null);
    }

    @Override
    public InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException {
        if (attributes == null) {
            attributes = new JsonObject();
        }
        attributes.addProperty("element", elementId);
        DoipClientResponse response = null;
        try {
            response = this.performOperation(targetId, "0.DOIP/Op.Retrieve", authInfo, attributes, serviceInfo);
            if (response.getStatus().equals("0.DOIP/Status.001")) {
                InDoipMessage in = response.getOutput();
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new DoipException("Missing first segment");
                }
                return AbstractDoipClient.getElementInputStreamWithCorrectClose(firstSegment, response);
            }
            throw AbstractDoipClient.doipExceptionFromDoipResponse(response);
        }
        catch (Exception e) {
            AbstractDoipClient.closeQuietly(response);
            if (e instanceof DoipException) {
                throw (DoipException)e;
            }
            throw new DoipException(e);
        }
    }

    @Override
    public InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo) throws DoipException {
        return this.retrievePartialElement(targetId, elementId, start, end, authInfo, null);
    }

    @Override
    public InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.retrievePartialElement(targetId, elementId, start, end, authInfo, serviceInfo, null);
    }

    @Override
    public InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo, ServiceInfo serviceInfo, JsonObject attributes) throws DoipException {
        if (attributes == null) {
            attributes = new JsonObject();
        }
        attributes.addProperty("element", elementId);
        JsonObject range = new JsonObject();
        range.addProperty("start", (Number)start);
        range.addProperty("end", (Number)end);
        attributes.add("range", (JsonElement)range);
        DoipClientResponse response = null;
        try {
            response = this.performOperation(targetId, "0.DOIP/Op.Retrieve", authInfo, attributes, serviceInfo);
            if (response.getStatus().equals("0.DOIP/Status.001")) {
                InDoipMessage in = response.getOutput();
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new DoipException("Missing first segment");
                }
                return AbstractDoipClient.getElementInputStreamWithCorrectClose(firstSegment, response);
            }
            throw AbstractDoipClient.doipExceptionFromDoipResponse(response);
        }
        catch (Exception e) {
            AbstractDoipClient.closeQuietly(response);
            if (e instanceof DoipException) {
                throw (DoipException)e;
            }
            throw new DoipException(e);
        }
    }

    private static InputStream getElementInputStreamWithCorrectClose(InDoipSegment doipSegment, DoipClientResponse response) {
        InputStream in = doipSegment.getInputStream();
        return new DelegatedCloseableInputStream(in, () -> AbstractDoipClient.closeQuietly(response));
    }

    private static DoipRequestHeaders headersFrom(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input) throws DoipException {
        DoipRequestHeaders headers = new DoipRequestHeaders();
        headers.targetId = targetId;
        headers.operationId = operationId;
        if (authInfo != null) {
            headers.clientId = authInfo.getClientId();
            JsonElement authentication = authInfo.getAuthentication();
            if (authentication != null) {
                headers.authentication = authentication;
            }
        }
        headers.attributes = attributes;
        if (input != null) {
            headers.input = input;
        }
        return headers;
    }

    private static DoipRequestHeaders headersFrom(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException {
        return AbstractDoipClient.headersFrom(targetId, operationId, authInfo, attributes, null);
    }

    DigitalObject digitalObjectFromSegments(InDoipMessage input) throws IOException, DoipException {
        InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(input);
        if (firstSegment == null) {
            throw new BadDoipException("Missing input");
        }
        DigitalObject digitalObject = (DigitalObject)GsonUtility.getGson().fromJson(firstSegment.getJson(), DigitalObject.class);
        if (digitalObject.elements != null) {
            HashMap<String, Element> elements = new HashMap<String, Element>();
            for (Element el : digitalObject.elements) {
                elements.put(el.id, el);
            }
            Iterator segments = input.iterator();
            while (segments.hasNext()) {
                String elementId;
                InDoipSegment headerSegment = (InDoipSegment)segments.next();
                try {
                    elementId = headerSegment.getJson().getAsJsonObject().get("id").getAsString();
                }
                catch (Exception e) {
                    throw new DoipException("Unexpected element header");
                }
                if (!segments.hasNext()) {
                    throw new DoipException("Unexpected end of input");
                }
                InDoipSegment elementBytesSegment = (InDoipSegment)segments.next();
                Element el = (Element)elements.get(elementId);
                if (el == null) {
                    throw new DoipException("No such element " + elementId);
                }
                InputStream in = elementBytesSegment.getInputStream();
                el.in = AbstractDoipClient.persistInputStream(in);
            }
        } else if (!InDoipMessageUtil.isEmpty(input)) {
            throw new DoipException("Unexpected input segments");
        }
        return digitalObject;
    }

    private static ByteArrayInputStream persistInputStream(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((r = in.read(buf)) > 0) {
            bout.write(buf, 0, r);
        }
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public static DoipException doipExceptionFromDoipResponse(DoipClientResponse resp) throws IOException {
        JsonElement response = ErrorMessageUtil.getJsonResponseFromErrorResponse(resp);
        DoipException e = new DoipException(resp.getStatus(), response);
        return e;
    }
}

