/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.util.tls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.dona.doip.util.tls.AllTrustingTrustManager;

public class TlsProtocolAndCipherSuiteConfigurationUtil {
    public static final String[] ENABLED_PROTOCOLS;
    public static final String[] ENABLED_CIPHER_SUITES;
    private static final String[] DESIRED_CIPHER_SUITES;

    public static Socket configureEnabledProtocolsAndCipherSuites(Socket s) {
        if (s instanceof SSLSocket) {
            ((SSLSocket)s).setEnabledProtocols(ENABLED_PROTOCOLS);
            ((SSLSocket)s).setEnabledCipherSuites(ENABLED_CIPHER_SUITES);
        }
        return s;
    }

    public static ServerSocket configureEnabledProtocolsAndCipherSuites(ServerSocket s) {
        if (s instanceof SSLServerSocket) {
            ((SSLServerSocket)s).setEnabledProtocols(ENABLED_PROTOCOLS);
            ((SSLServerSocket)s).setEnabledCipherSuites(ENABLED_CIPHER_SUITES);
        }
        return s;
    }

    public static SSLContext getAllTrustingClientSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new AllTrustingTrustManager()};
            sslContext.init(null, tm, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        DESIRED_CIPHER_SUITES = new String[]{"TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256"};
        SSLContext context = TlsProtocolAndCipherSuiteConfigurationUtil.getAllTrustingClientSSLContext();
        String[] supportedCipherSuitesArray = context.getSupportedSSLParameters().getCipherSuites();
        List<String> supportedCipherSuites = Arrays.asList(supportedCipherSuitesArray);
        ArrayList<String> enabledCipherSuites = new ArrayList<String>(Arrays.asList(DESIRED_CIPHER_SUITES));
        enabledCipherSuites.retainAll(supportedCipherSuites);
        ENABLED_CIPHER_SUITES = enabledCipherSuites.toArray(new String[0]);
        context = TlsProtocolAndCipherSuiteConfigurationUtil.getAllTrustingClientSSLContext();
        String[] supportedProtocols = context.getSupportedSSLParameters().getProtocols();
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        for (String protocol : supportedProtocols) {
            if (protocol.startsWith("SSL") || "TLSv1.2".compareTo(protocol) > 0) continue;
            enabledProtocols.add(protocol);
        }
        ENABLED_PROTOCOLS = enabledProtocols.toArray(new String[0]);
    }

    public static class ServerSocketFactoryWrapper
    extends SSLServerSocketFactory {
        private final SSLServerSocketFactory delegate;

        public ServerSocketFactoryWrapper(SSLServerSocketFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createServerSocket());
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return this.delegate.createServerSocket(port, backlog, ifAddress);
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return this.delegate.createServerSocket(port, backlog);
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.delegate.createServerSocket(port);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class SocketFactoryWrapper
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;

        public SocketFactoryWrapper(SSLSocketFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public Socket createSocket() throws IOException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createSocket(address, port, localAddress, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.delegate.createSocket(host, port));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

