/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.dona.doip.client.transport.ConnectionOptions;
import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.DoipConnectionImpl;
import net.dona.doip.util.tls.AllTrustingTrustManager;
import net.dona.doip.util.tls.AutoSelfSignedKeyManager;
import net.dona.doip.util.tls.TlsProtocolAndCipherSuiteConfigurationUtil;
import net.dona.doip.util.tls.TrustManagerForSpecifiedServerIdAndKeys;

public class TransportDoipClient
implements AutoCloseable {
    private static final int DEFAULT_TIMEOUT_MS = 60000;
    private final AtomicLong counter = new AtomicLong();
    private final ConcurrentMap<Long, DoipConnection> openConnections = new ConcurrentHashMap<Long, DoipConnection>();
    private volatile boolean closed;

    public DoipConnection connect(InetAddress address, int port) throws IOException {
        return this.connect(address, port, 60000, 60000);
    }

    public DoipConnection connect(InetAddress address, int port, int connectTimeoutMs, int readTimeoutMs) throws IOException {
        return this.connect(address, port, null, null, connectTimeoutMs, readTimeoutMs);
    }

    public DoipConnection connect(ConnectionOptions options) throws IOException {
        int readTimeoutMs;
        int connectTimeoutMs;
        InetAddress address = InetAddress.getByName(options.address);
        int port = options.port;
        int n = connectTimeoutMs = options.connectTimeoutMs == null ? 60000 : options.connectTimeoutMs;
        if (connectTimeoutMs < 0) {
            connectTimeoutMs = 60000;
        }
        int n2 = readTimeoutMs = options.readTimeoutMs == null ? 60000 : options.connectTimeoutMs;
        if (readTimeoutMs < 0) {
            readTimeoutMs = 60000;
        }
        TrustManagerForSpecifiedServerIdAndKeys serverTrustManager = null;
        if (options.serverId != null) {
            serverTrustManager = new TrustManagerForSpecifiedServerIdAndKeys(options.serverId, options.trustedServerPublicKeys);
        }
        AutoSelfSignedKeyManager clientKeyManager = null;
        if (options.clientId != null) {
            clientKeyManager = new AutoSelfSignedKeyManager(options.clientId, options.clientPublicKey, options.clientPrivateKey);
        }
        return this.connect(address, port, serverTrustManager, clientKeyManager, connectTimeoutMs, readTimeoutMs);
    }

    public DoipConnection connect(InetAddress address, int port, X509TrustManager serverTrustManager, X509KeyManager clientKeyManager, int connectTimeoutMs, int readTimeoutMs) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        SSLContext sslContext = this.getSSLContext(serverTrustManager, clientKeyManager);
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        Socket socket = socketFactory.createSocket();
        TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(socket);
        socket.setSoTimeout(readTimeoutMs);
        socket.connect(new InetSocketAddress(address, port), connectTimeoutMs);
        final long count = this.counter.getAndIncrement();
        DoipConnectionImpl res = new DoipConnectionImpl(socket){

            @Override
            public void close() {
                super.close();
                TransportDoipClient.this.openConnections.remove(count);
            }
        };
        this.openConnections.put(count, res);
        return res;
    }

    private SSLContext getSSLContext(X509TrustManager serverTrustManager, X509KeyManager clientKeyManager) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            if (serverTrustManager == null) {
                serverTrustManager = new AllTrustingTrustManager();
            }
            TrustManager[] tms = new TrustManager[]{serverTrustManager};
            KeyManager[] kms = null;
            if (clientKeyManager != null) {
                kms = new KeyManager[]{clientKeyManager};
            }
            sslContext.init(kms, tms, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (KeyManagementException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        boolean found = true;
        while (found) {
            found = false;
            Iterator iter = this.openConnections.values().iterator();
            while (iter.hasNext()) {
                found = true;
                ((DoipConnection)iter.next()).close();
            }
        }
    }
}

