/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.dona.doip.client.transport.ConnectionOptions;
import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.ReleaseOnceDoipConnection;
import net.dona.doip.client.transport.TransportDoipClient;

public class DoipConnectionPool {
    private final List<DoipConnection> allActiveConnections;
    private final BlockingQueue<DoipConnection> pool;
    private final TransportDoipClient client;
    private final int maxSize;
    private final ConnectionOptions connectionOptions;
    private volatile boolean isShutdown = false;

    public DoipConnectionPool(int maxSize, TransportDoipClient client, ConnectionOptions connectionOptions) {
        this.maxSize = maxSize;
        this.pool = new LinkedBlockingQueue<DoipConnection>();
        this.client = client;
        this.connectionOptions = connectionOptions;
        this.allActiveConnections = new ArrayList<DoipConnection>();
    }

    private DoipConnection getNewDoipConnection() throws IOException {
        return this.client.connect(this.connectionOptions);
    }

    public void release(DoipConnection connection) throws InterruptedException {
        if (connection instanceof ReleaseOnceDoipConnection) {
            ReleaseOnceDoipConnection releaseOnceDoipConnection = (ReleaseOnceDoipConnection)connection;
            if (this.isShutdown) {
                connection.close();
            } else {
                releaseOnceDoipConnection.release();
                this.pool.put(releaseOnceDoipConnection.getConnection());
            }
        } else {
            throw new IllegalStateException("Attempt to release underlying connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipConnection get() {
        if (this.isShutdown) {
            return null;
        }
        try {
            DoipConnection newConnection;
            DoipConnection connection = (DoipConnection)this.pool.poll();
            DoipConnectionPool doipConnectionPool = this;
            synchronized (doipConnectionPool) {
                if (connection == null && this.allActiveConnections.size() < this.maxSize) {
                    connection = this.getNewDoipConnection();
                    this.allActiveConnections.add(connection);
                    return new ReleaseOnceDoipConnection(connection);
                }
            }
            if (connection == null) {
                connection = this.pool.take();
            }
            if (this.isGood(connection)) {
                return new ReleaseOnceDoipConnection(connection);
            }
            DoipConnectionPool doipConnectionPool2 = this;
            synchronized (doipConnectionPool2) {
                this.allActiveConnections.remove(connection);
                newConnection = this.getNewDoipConnection();
                this.allActiveConnections.add(newConnection);
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new ReleaseOnceDoipConnection(newConnection);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isGood(DoipConnection connection) {
        return !connection.isClosed();
    }

    public void shutdown() {
        if (!this.isShutdown) {
            for (DoipConnection connection : this.pool) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
            this.isShutdown = true;
        }
    }
}

