/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.dona.doip.BadDoipException;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipMessageFromCollection;
import net.dona.doip.InDoipSegment;
import net.dona.doip.InDoipSegmentFromInputStream;
import net.dona.doip.InDoipSegmentFromJson;
import net.dona.doip.client.AuthenticationInfo;
import net.dona.doip.client.ConnectionAndPool;
import net.dona.doip.client.DelegatedCloseableInputStream;
import net.dona.doip.client.DigitalObject;
import net.dona.doip.client.DoipException;
import net.dona.doip.client.DoipSearchResults;
import net.dona.doip.client.Element;
import net.dona.doip.client.QueryParams;
import net.dona.doip.client.SearchResults;
import net.dona.doip.client.ServiceInfo;
import net.dona.doip.client.SortField;
import net.dona.doip.client.transport.ConnectionOptions;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.DoipConnectionPool;
import net.dona.doip.client.transport.TransportDoipClient;
import net.dona.doip.util.GsonUtility;
import net.dona.doip.util.InDoipMessageUtil;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoipClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DoipClient.class);
    private static final String DOIP_SERVICE_INFO = "DOIPServiceInfo";
    private static final String TYPE_DOIP_SERVICE_INFO = "0.TYPE/DOIPServiceInfo";
    private static final String DOIP_SERVICE = "DOIPService";
    private static final String TYPE_DOIP_SERVICE = "0.TYPE/DOIPService";
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_HOP_COUNT = 20;
    private final Cache<String, ServiceInfoAndPool> serviceHandleToPoolsMap;
    private final Cache<String, String> targetIdToServiceHandleMap;
    private final TransportDoipClient doipClient = new TransportDoipClient();
    private final HandleResolver resolver = new HandleResolver();
    private boolean closed;

    public DoipClient() {
        this.serviceHandleToPoolsMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).removalListener((RemovalListener)new PoolRemovalListener()).build();
        this.targetIdToServiceHandleMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        for (ServiceInfoAndPool serviceInfoAndPool : this.serviceHandleToPoolsMap.asMap().values()) {
            try {
                serviceInfoAndPool.pool.shutdown();
            }
            catch (Exception e) {
                logger.warn("Error closing", (Throwable)e);
            }
        }
        try {
            this.doipClient.close();
        }
        catch (Exception e) {
            logger.warn("Error closing", (Throwable)e);
        }
    }

    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException {
        DoipRequestHeaders headers = DoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, null);
    }

    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input) throws DoipException {
        DoipRequestHeaders headers = DoipClient.headersFrom(targetId, operationId, authInfo, attributes, input);
        return this.performOperation(headers, null);
    }

    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, InDoipMessage input) throws DoipException {
        DoipRequestHeaders headers = DoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, input);
    }

    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, ServiceInfo serviceInfo) throws DoipException {
        DoipRequestHeaders headers = DoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, null, serviceInfo);
    }

    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input, ServiceInfo serviceInfo) throws DoipException {
        DoipRequestHeaders headers = DoipClient.headersFrom(targetId, operationId, authInfo, attributes, input);
        return this.performOperation(headers, null, serviceInfo);
    }

    public DoipClientResponse performOperation(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, InDoipMessage input, ServiceInfo serviceInfo) throws DoipException {
        DoipRequestHeaders headers = DoipClient.headersFrom(targetId, operationId, authInfo, attributes);
        return this.performOperation(headers, input, serviceInfo);
    }

    public DoipClientResponse performOperation(DoipRequestHeaders headers, InDoipMessage input) throws DoipException {
        return this.performOperation(headers, input, null);
    }

    public DoipClientResponse performOperation(DoipRequestHeaders headers, InDoipMessage input, ServiceInfo serviceInfo) throws DoipException {
        ConnectionAndPool connectionAndPool = this.connectionAndPoolForOptions(serviceInfo, headers.targetId);
        return this.performOperationWithConnection(headers, input, connectionAndPool);
    }

    private ConnectionAndPool connectionAndPoolForOptions(ServiceInfo serviceInfo, String targetId) throws DoipException {
        ConnectionAndPool connectionAndPool;
        if (serviceInfo == null) {
            connectionAndPool = this.getConnectionFor(targetId);
        } else if (serviceInfo.ipAddress != null) {
            ServiceInfoAndPool serviceInfoAndPool = this.getOrCreatePool(serviceInfo);
            connectionAndPool = new ConnectionAndPool(serviceInfoAndPool.pool);
        } else if (serviceInfo.serviceId != null) {
            connectionAndPool = this.getConnectionFor(serviceInfo.serviceId);
        } else {
            throw new DoipException("Missing options");
        }
        return connectionAndPool;
    }

    private DoipClientResponse performOperationWithConnection(DoipRequestHeaders headers, InDoipMessage input, ConnectionAndPool connectionAndPool) throws DoipException {
        DoipClientResponse response;
        DoipConnection conn = connectionAndPool.getConnection();
        try {
            response = input != null ? conn.sendRequest(headers, input) : conn.sendCompactRequest(headers);
        }
        catch (IOException ioe) {
            try {
                connectionAndPool.releaseConnection();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            throw new DoipException(ioe);
        }
        response.setOnClose(() -> {
            try {
                connectionAndPool.releaseConnection();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        return response;
    }

    private static DoipRequestHeaders headersFrom(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes, JsonElement input) throws DoipException {
        DoipRequestHeaders headers = new DoipRequestHeaders();
        headers.targetId = targetId;
        headers.operationId = operationId;
        if (authInfo != null) {
            headers.clientId = authInfo.getClientId();
            JsonElement authentication = authInfo.getAuthentication();
            if (authentication != null) {
                headers.authentication = authentication;
            }
        }
        headers.attributes = attributes;
        if (input != null) {
            headers.input = input;
        }
        return headers;
    }

    private static DoipRequestHeaders headersFrom(String targetId, String operationId, AuthenticationInfo authInfo, JsonObject attributes) throws DoipException {
        return DoipClient.headersFrom(targetId, operationId, authInfo, attributes, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DigitalObject create(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        if (serviceInfo.serviceId == null) throw new DoipException("Missing service id for create");
        String targetId = serviceInfo.serviceId;
        try (InDoipMessage inMessage = this.buildCreateOrUpdateMessageFrom(dobj, false);
             DoipClientResponse resp = this.performOperation(targetId, "0.DOIP/Op.Create", authInfo, null, inMessage, serviceInfo);){
            if (!resp.getStatus().equals("0.DOIP/Status.001")) throw DoipClient.doipExceptionFromDoipResponse(resp);
            try (InDoipMessage in = resp.getOutput();){
                DigitalObject resultDo;
                DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                return digitalObject;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    public DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo) throws DoipException {
        return this.update(dobj, authInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DigitalObject update(DigitalObject dobj, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        try (InDoipMessage inMessage = this.buildCreateOrUpdateMessageFrom(dobj, true);
             DoipClientResponse resp = this.performOperation(dobj.id, "0.DOIP/Op.Update", authInfo, null, inMessage, serviceInfo);){
            if (!resp.getStatus().equals("0.DOIP/Status.001")) throw DoipClient.doipExceptionFromDoipResponse(resp);
            try (InDoipMessage in = resp.getOutput();){
                DigitalObject resultDo;
                DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                return digitalObject;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    private InDoipMessage buildCreateOrUpdateMessageFrom(DigitalObject dobj, boolean isUpdate) {
        JsonObject dobjJson = GsonUtility.getGson().toJsonTree((Object)dobj).getAsJsonObject();
        ArrayList<InDoipSegment> segments = new ArrayList<InDoipSegment>();
        InDoipSegmentFromJson dobjSegment = new InDoipSegmentFromJson((JsonElement)dobjJson);
        segments.add(dobjSegment);
        if (dobj.elements != null) {
            for (Element el : dobj.elements) {
                if (isUpdate && el.in == null) continue;
                JsonObject elementSegmentJson = new JsonObject();
                elementSegmentJson.addProperty("id", el.id);
                InDoipSegmentFromJson elementHeaderSegment = new InDoipSegmentFromJson((JsonElement)elementSegmentJson);
                segments.add(elementHeaderSegment);
                InDoipSegmentFromInputStream elementBytesSegment = new InDoipSegmentFromInputStream(false, el.in);
                segments.add(elementBytesSegment);
            }
        }
        return new InDoipMessageFromCollection(segments);
    }

    public DigitalObject retrieve(String targetId, AuthenticationInfo authInfo) throws DoipException {
        return this.retrieve(targetId, false, authInfo, null);
    }

    public DigitalObject retrieve(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.retrieve(targetId, false, authInfo, serviceInfo);
    }

    public DigitalObject retrieve(String targetId, boolean includeElementData, AuthenticationInfo authInfo) throws DoipException {
        return this.retrieve(targetId, includeElementData, authInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DigitalObject retrieve(String targetId, boolean includeElementData, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonObject attributes = new JsonObject();
        if (includeElementData) {
            attributes.addProperty("includeElementData", "true");
        }
        try (DoipClientResponse response = this.performOperation(targetId, "0.DOIP/Op.Retrieve", authInfo, attributes, serviceInfo);){
            if (response.getStatus().equals("0.DOIP/Status.001")) {
                try (InDoipMessage in = response.getOutput();){
                    DigitalObject resultDo;
                    DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                    return digitalObject;
                }
            }
            if (!response.getStatus().equals("0.DOIP/Status.104")) throw DoipClient.doipExceptionFromDoipResponse(response);
            DigitalObject digitalObject = null;
            return digitalObject;
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    public void delete(String targetId, AuthenticationInfo authInfo) throws DoipException {
        this.delete(targetId, authInfo, null);
    }

    public void delete(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonElement input = null;
        try (DoipClientResponse resp = this.performOperation(targetId, "0.DOIP/Op.Delete", authInfo, null, input, serviceInfo);){
            if (resp.getStatus().equals("0.DOIP/Status.001")) {
                return;
            }
            throw DoipClient.doipExceptionFromDoipResponse(resp);
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    public List<String> listOperations(String targetId, AuthenticationInfo authInfo) throws DoipException {
        return this.listOperations(targetId, authInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listOperations(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonElement input = null;
        try (DoipClientResponse resp = this.performOperation(targetId, "0.DOIP/Op.ListOperations", authInfo, null, input, serviceInfo);){
            if (!resp.getStatus().equals("0.DOIP/Status.001")) throw DoipClient.doipExceptionFromDoipResponse(resp);
            try (InDoipMessage in = resp.getOutput();){
                List results;
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new DoipException("Missing first segment in response");
                }
                List list = results = (List)GsonUtility.getGson().fromJson(firstSegment.getJson(), new TypeToken<List<String>>(){}.getType());
                return list;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    public static DoipException doipExceptionFromDoipResponse(DoipClientResponse resp) {
        String message = DoipClient.getMessageFromErrorResponse(resp);
        DoipException e = new DoipException(resp.getStatus(), message);
        return e;
    }

    private static String getMessageFromErrorResponse(DoipClientResponse resp) {
        String message = null;
        JsonObject attributes = resp.getAttributes();
        message = attributes != null && attributes.has("message") ? attributes.get("message").getAsString() : "DOIP Error: " + resp.getStatus();
        return message;
    }

    public SearchResults<String> searchIds(String targetId, String query, QueryParams params, AuthenticationInfo authInfo) throws DoipException {
        return this.searchIds(targetId, query, params, authInfo, null);
    }

    public SearchResults<String> searchIds(String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.searchIdsOrFull("id", String.class, targetId, query, params, authInfo, serviceInfo);
    }

    public SearchResults<DigitalObject> search(String targetId, String query, QueryParams params, AuthenticationInfo authInfo) throws DoipException {
        return this.search(targetId, query, params, authInfo, null);
    }

    public SearchResults<DigitalObject> search(String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        return this.searchIdsOrFull("full", DigitalObject.class, targetId, query, params, authInfo, serviceInfo);
    }

    private <T> SearchResults<T> searchIdsOrFull(String type, Class<T> klass, String targetId, String query, QueryParams params, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        DoipClientResponse resp = null;
        try {
            JsonObject attributes = DoipClient.getSearchAttributes(type, query, params);
            resp = this.performOperation(targetId, "0.DOIP/Op.Search", authInfo, attributes, serviceInfo);
            if (resp.getStatus().equals("0.DOIP/Status.001")) {
                return new DoipSearchResults<T>(resp, klass);
            }
            throw DoipClient.doipExceptionFromDoipResponse(resp);
        }
        catch (Exception e) {
            DoipClient.closeQuietly(resp);
            if (e instanceof DoipException) {
                throw (DoipException)e;
            }
            throw new DoipException(e);
        }
    }

    private static JsonObject getSearchAttributes(String type, String query, QueryParams params) {
        if (params == null) {
            params = QueryParams.DEFAULT;
        }
        JsonObject attributes = new JsonObject();
        attributes.addProperty("query", query);
        attributes.addProperty("pageNum", (Number)params.getPageNumber());
        attributes.addProperty("pageSize", (Number)params.getPageSize());
        if (type == null) {
            type = "full";
        }
        attributes.addProperty("type", type);
        if (params.getSortFields() != null) {
            String sortFields = DoipClient.sortFieldsToString(params.getSortFields());
            attributes.addProperty("sortFields", sortFields);
        }
        return attributes;
    }

    private static String sortFieldsToString(List<SortField> sortFields) {
        if (sortFields != null && !sortFields.isEmpty()) {
            ArrayList<String> sortFieldsForTransport = new ArrayList<String>(sortFields.size());
            for (SortField sortField : sortFields) {
                if (sortField.isReverse()) {
                    sortFieldsForTransport.add(sortField.getName() + " DESC");
                    continue;
                }
                sortFieldsForTransport.add(sortField.getName());
            }
            if (!sortFieldsForTransport.isEmpty()) {
                return String.join((CharSequence)",", sortFieldsForTransport);
            }
        }
        return null;
    }

    public DigitalObject hello(String targetId, AuthenticationInfo authInfo) throws DoipException {
        return this.hello(targetId, authInfo, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DigitalObject hello(String targetId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonElement input = null;
        try (DoipClientResponse response = this.performOperation(targetId, "0.DOIP/Op.Hello", authInfo, null, input, serviceInfo);){
            if (!response.getStatus().equals("0.DOIP/Status.001")) throw DoipClient.doipExceptionFromDoipResponse(response);
            try (InDoipMessage in = response.getOutput();){
                DigitalObject resultDo;
                DigitalObject digitalObject = resultDo = this.digitalObjectFromSegments(in);
                return digitalObject;
            }
        }
        catch (DoipException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DoipException(e);
        }
    }

    public InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo) throws DoipException {
        return this.retrieveElement(targetId, elementId, authInfo, null);
    }

    public InputStream retrieveElement(String targetId, String elementId, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonObject attributes = new JsonObject();
        attributes.addProperty("element", elementId);
        DoipClientResponse response = null;
        try {
            response = this.performOperation(targetId, "0.DOIP/Op.Retrieve", authInfo, attributes, serviceInfo);
            if (response.getStatus().equals("0.DOIP/Status.001")) {
                InDoipMessage in = response.getOutput();
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new DoipException("Missing first segment");
                }
                return DoipClient.getElementInputStreamWithCorrectClose(firstSegment, response);
            }
            throw DoipClient.doipExceptionFromDoipResponse(response);
        }
        catch (Exception e) {
            DoipClient.closeQuietly(response);
            if (e instanceof DoipException) {
                throw (DoipException)e;
            }
            throw new DoipException(e);
        }
    }

    public InputStream retrievePartialElement(String targetId, String elementId, Long start, Long end, AuthenticationInfo authInfo, ServiceInfo serviceInfo) throws DoipException {
        JsonObject attributes = new JsonObject();
        attributes.addProperty("element", elementId);
        JsonObject range = new JsonObject();
        range.addProperty("start", (Number)start);
        range.addProperty("end", (Number)end);
        attributes.add("range", (JsonElement)range);
        DoipClientResponse response = null;
        try {
            response = this.performOperation(targetId, "0.DOIP/Op.Retrieve", authInfo, attributes, serviceInfo);
            if (response.getStatus().equals("0.DOIP/Status.001")) {
                InDoipMessage in = response.getOutput();
                InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(in);
                if (firstSegment == null) {
                    throw new DoipException("Missing first segment");
                }
                return DoipClient.getElementInputStreamWithCorrectClose(firstSegment, response);
            }
            throw DoipClient.doipExceptionFromDoipResponse(response);
        }
        catch (Exception e) {
            DoipClient.closeQuietly(response);
            if (e instanceof DoipException) {
                throw (DoipException)e;
            }
            throw new DoipException(e);
        }
    }

    private static InputStream getElementInputStreamWithCorrectClose(InDoipSegment doipSegment, DoipClientResponse response) {
        return new DelegatedCloseableInputStream(doipSegment.getInputStream(), () -> DoipClient.closeQuietly(response));
    }

    private static void closeQuietly(DoipClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private DigitalObject digitalObjectFromSegments(InDoipMessage input) throws IOException, DoipException {
        InDoipSegment firstSegment = InDoipMessageUtil.getFirstSegment(input);
        if (firstSegment == null) {
            throw new BadDoipException("Missing input");
        }
        DigitalObject digitalObject = (DigitalObject)GsonUtility.getGson().fromJson(firstSegment.getJson(), DigitalObject.class);
        if (digitalObject.elements != null) {
            HashMap<String, Element> elements = new HashMap<String, Element>();
            for (Element el : digitalObject.elements) {
                elements.put(el.id, el);
            }
            Iterator segments = input.iterator();
            while (segments.hasNext()) {
                String elementId;
                InDoipSegment headerSegment = (InDoipSegment)segments.next();
                try {
                    elementId = headerSegment.getJson().getAsJsonObject().get("id").getAsString();
                }
                catch (Exception e) {
                    throw new DoipException("Unexpected element header");
                }
                if (!segments.hasNext()) {
                    throw new DoipException("Unexpected end of input");
                }
                InDoipSegment elementBytesSegment = (InDoipSegment)segments.next();
                Element el = (Element)elements.get(elementId);
                if (el == null) {
                    throw new DoipException("No such element " + elementId);
                }
                el.in = DoipClient.persistInputStream(elementBytesSegment.getInputStream());
            }
        } else if (!InDoipMessageUtil.isEmpty(input)) {
            throw new DoipException("Unexpected input segments");
        }
        return digitalObject;
    }

    private static ByteArrayInputStream persistInputStream(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((r = in.read(buf)) > 0) {
            bout.write(buf, 0, r);
        }
        return new ByteArrayInputStream(bout.toByteArray());
    }

    private ConnectionAndPool getConnectionFor(String targetId) throws DoipException {
        String serviceHandle = (String)this.targetIdToServiceHandleMap.getIfPresent((Object)targetId);
        ServiceInfoAndPool serviceInfoAndPool = null;
        if (serviceHandle == null) {
            serviceInfoAndPool = this.getServiceInfoAndPoolFor(targetId);
            this.targetIdToServiceHandleMap.put((Object)targetId, (Object)serviceInfoAndPool.serviceInfo.serviceId);
        } else {
            serviceInfoAndPool = (ServiceInfoAndPool)this.serviceHandleToPoolsMap.getIfPresent((Object)serviceHandle);
            if (serviceInfoAndPool == null) {
                serviceInfoAndPool = this.getServiceInfoAndPoolFor(serviceHandle);
            }
        }
        ConnectionAndPool result = new ConnectionAndPool(serviceInfoAndPool.pool);
        return result;
    }

    private ServiceInfoAndPool getServiceInfoAndPoolFor(String handle) throws DoipException {
        try {
            ServiceInfo serviceInfo = this.getServiceInfoFor(handle, 0);
            if (serviceInfo == null) {
                throw new DoipException("DOIPServiceInfo not found for " + handle);
            }
            ServiceInfoAndPool serviceInfoAndPool = this.getOrCreatePool(serviceInfo);
            return serviceInfoAndPool;
        }
        catch (HandleException he) {
            throw new DoipException(he);
        }
    }

    private synchronized ServiceInfoAndPool getOrCreatePool(ServiceInfo serviceInfo) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        ServiceInfoAndPool serviceInfoAndPool = (ServiceInfoAndPool)this.serviceHandleToPoolsMap.getIfPresent((Object)serviceInfo.serviceId);
        if (serviceInfoAndPool == null) {
            DoipConnectionPool pool = new DoipConnectionPool(100, this.doipClient, this.connectionOptionsForServiceInfo(serviceInfo));
            serviceInfoAndPool = new ServiceInfoAndPool(serviceInfo, pool);
            this.serviceHandleToPoolsMap.put((Object)serviceInfo.serviceId, (Object)serviceInfoAndPool);
        }
        return serviceInfoAndPool;
    }

    private ConnectionOptions connectionOptionsForServiceInfo(ServiceInfo serviceInfo) {
        ConnectionOptions res = new ConnectionOptions();
        res.serverId = serviceInfo.serviceId;
        res.address = serviceInfo.ipAddress;
        res.port = serviceInfo.port;
        if (serviceInfo.publicKey != null) {
            res.trustedServerPublicKeys = Collections.singletonList(serviceInfo.publicKey);
        }
        return res;
    }

    private ServiceInfo getServiceInfoFor(String handle, int hopCount) throws HandleException {
        HandleValue[] values;
        for (HandleValue value : values = this.resolver.resolveHandle(handle, new String[]{DOIP_SERVICE, TYPE_DOIP_SERVICE, DOIP_SERVICE_INFO, TYPE_DOIP_SERVICE_INFO}, null)) {
            String type = value.getTypeAsString();
            if (DOIP_SERVICE_INFO.equals(type) || TYPE_DOIP_SERVICE_INFO.equals(type)) {
                String json = value.getDataAsString();
                DigitalObject dobj = (DigitalObject)GsonUtility.getGson().fromJson(json, DigitalObject.class);
                ServiceInfo result = (ServiceInfo)GsonUtility.getGson().fromJson((JsonElement)dobj.attributes, ServiceInfo.class);
                result.serviceId = handle;
                return result;
            }
            if (!DOIP_SERVICE.equals(type) && !TYPE_DOIP_SERVICE.equals(type)) continue;
            String doipServiceHandle = value.getDataAsString();
            if (hopCount >= 20) {
                return null;
            }
            return this.getServiceInfoFor(doipServiceHandle, hopCount + 1);
        }
        return null;
    }

    private static class PoolRemovalListener
    implements RemovalListener<String, ServiceInfoAndPool> {
        private PoolRemovalListener() {
        }

        public void onRemoval(RemovalNotification<String, ServiceInfoAndPool> notification) {
            ServiceInfoAndPool serviceInfoAndPool = (ServiceInfoAndPool)notification.getValue();
            serviceInfoAndPool.pool.shutdown();
        }
    }

    private static class ServiceInfoAndPool {
        public final ServiceInfo serviceInfo;
        public final DoipConnectionPool pool;

        public ServiceInfoAndPool(ServiceInfo serviceInfo, DoipConnectionPool pool) {
            this.serviceInfo = serviceInfo;
            this.pool = pool;
        }
    }
}

