/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.util.tls;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;

public class X509IdParser {
    private static String parseIdentityHandleFromRfc2253Dn(String dn) {
        return new Rfc2253DnParser(dn).getHandle();
    }

    public static String parseIdentityHandle(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return X509IdParser.parseIdentityHandleFromRfc2253Dn(cert.getSubjectX500Principal().getName());
    }

    public static String parseIdentityHandle(X509Certificate[] cert) {
        if (cert == null || cert.length == 0) {
            return null;
        }
        return X509IdParser.parseIdentityHandle(cert[0]);
    }

    private static class Rfc2253DnParser {
        private final String dn;
        private int index;

        Rfc2253DnParser(String dn) {
            this.dn = dn;
        }

        private static String trim(String s) {
            char ch;
            int start = 0;
            int end = 0;
            for (start = 0; start < s.length() && (ch = s.charAt(start)) == ' '; ++start) {
            }
            boolean escaped = false;
            for (int i = start; i < s.length(); ++i) {
                char ch2 = s.charAt(i);
                boolean isSpace = false;
                if (escaped) {
                    escaped = false;
                } else if (ch2 == '\\') {
                    escaped = true;
                } else if (ch2 == ' ') {
                    isSpace = true;
                }
                if (isSpace) continue;
                end = i;
            }
            if (start > end) {
                return "";
            }
            return s.substring(start, end + 1);
        }

        private String getType() {
            int start = this.index;
            this.index = this.dn.indexOf(61, start);
            if (this.index < 0) {
                return null;
            }
            String type = this.dn.substring(start, this.index);
            ++this.index;
            return Rfc2253DnParser.trim(type);
        }

        private char findSeparator() {
            boolean quoted = false;
            boolean escaped = false;
            while (this.index < this.dn.length()) {
                char ch = this.dn.charAt(this.index);
                if (!(quoted || escaped || ch != '+' && ch != ',' && ch != ';')) {
                    return ch;
                }
                if (escaped) {
                    escaped = false;
                } else if (ch == '\\') {
                    escaped = true;
                } else if (ch == '\"') {
                    quoted = !quoted;
                }
                ++this.index;
            }
            return ',';
        }

        private static boolean isHexChar(byte ch) {
            return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
        }

        private static int nibbleDecode(byte b) {
            if (b >= 48 && b <= 57) {
                return b - 48;
            }
            if (b >= 97 && b <= 102) {
                return 10 + b - 97;
            }
            if (b >= 65 && b <= 70) {
                return 10 + b - 65;
            }
            return b;
        }

        private static byte hexDecode(byte b1, byte b2) {
            return (byte)((Rfc2253DnParser.nibbleDecode(b1) << 4 | Rfc2253DnParser.nibbleDecode(b2)) & 0xFF);
        }

        private static String unescape(String value) {
            boolean quoted = false;
            boolean escaped = false;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (escaped) {
                    escaped = false;
                    if (Rfc2253DnParser.isHexChar(b)) {
                        if (++i >= bytes.length) break;
                        byte b2 = bytes[i];
                        bout.write(Rfc2253DnParser.hexDecode(b, b2));
                        continue;
                    }
                    bout.write(b);
                    continue;
                }
                if (b == 92) {
                    escaped = true;
                    continue;
                }
                if (b == 34) {
                    quoted = !quoted;
                    continue;
                }
                bout.write(b);
            }
            return new String(bout.toByteArray(), StandardCharsets.UTF_8);
        }

        private String getValue() {
            int start = this.index;
            this.findSeparator();
            String value = this.dn.substring(start, this.index);
            ++this.index;
            value = Rfc2253DnParser.trim(value);
            if (value.startsWith("#")) {
                return null;
            }
            return Rfc2253DnParser.unescape(value);
        }

        String getHandleOrValueReference() {
            String type;
            String uid = null;
            String cn = null;
            String o = null;
            while (this.index >= 0 && this.index < this.dn.length() && (type = this.getType()) != null) {
                String value = this.getValue();
                if (value == null) continue;
                if ("UID".equalsIgnoreCase(type) && uid == null) {
                    uid = value;
                }
                if ("CN".equalsIgnoreCase(type) && cn == null) {
                    cn = value;
                }
                if (!"O".equalsIgnoreCase(type) || o != null) continue;
                o = value;
            }
            if (uid != null) {
                return uid;
            }
            if (cn != null) {
                return cn;
            }
            return o;
        }

        private static boolean isDigits(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                return false;
            }
            return true;
        }

        String getHandle() {
            String handleOr = this.getHandleOrValueReference();
            if (handleOr == null) {
                return null;
            }
            int colon = handleOr.indexOf(58);
            if (colon < 0) {
                return handleOr;
            }
            String maybeIndex = handleOr.substring(0, colon);
            if (Rfc2253DnParser.isDigits(maybeIndex)) {
                String handle = handleOr.substring(colon + 1);
                return handle;
            }
            return handleOr;
        }
    }
}

