/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.util.tls;

import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import net.dona.doip.util.tls.X509CertificateGenerator;

public class AutoSelfSignedKeyManager
extends X509ExtendedKeyManager {
    private static final String ALIAS = "ALIAS";
    private volatile X509Certificate myCert = null;
    private X509Certificate[] configuredChain = null;
    private final String id;
    private final PrivateKey privKey;
    private final PublicKey publicKey;

    public AutoSelfSignedKeyManager(String id, X509Certificate[] chain, PrivateKey privKey) {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Empty X509Certificate chain");
        }
        this.id = id;
        this.configuredChain = chain;
        this.myCert = chain[0];
        this.privKey = privKey;
        this.publicKey = this.myCert.getPublicKey();
    }

    public AutoSelfSignedKeyManager(String id, X509Certificate cert, PrivateKey privKey) {
        this.id = id;
        this.myCert = cert;
        this.privKey = privKey;
        this.publicKey = cert.getPublicKey();
    }

    public AutoSelfSignedKeyManager(String id, PublicKey pubKey, PrivateKey privKey) {
        this.id = id;
        this.privKey = privKey;
        this.publicKey = pubKey;
    }

    public AutoSelfSignedKeyManager(String id) throws Exception {
        this.id = id;
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair keys = kpg.generateKeyPair();
        this.privKey = keys.getPrivate();
        this.publicKey = keys.getPublic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate getCertificate() {
        if (this.myCert == null) {
            AutoSelfSignedKeyManager autoSelfSignedKeyManager = this;
            synchronized (autoSelfSignedKeyManager) {
                if (this.myCert == null) {
                    try {
                        this.myCert = X509CertificateGenerator.generate(this.id, this.publicKey, this.privKey);
                    }
                    catch (Exception e) {
                        System.err.println("Error generating certificate");
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        }
        return this.myCert;
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return ALIAS;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return ALIAS;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return new String[]{ALIAS};
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        if (this.configuredChain != null) {
            return this.configuredChain;
        }
        if (this.getCertificate() != null) {
            return new X509Certificate[]{this.getCertificate()};
        }
        return new X509Certificate[0];
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return new String[]{ALIAS};
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.privKey;
    }

    @Override
    public String chooseEngineClientAlias(String[] as, Principal[] aprincipal, SSLEngine sslengine) {
        return this.chooseClientAlias(as, aprincipal, null);
    }

    @Override
    public String chooseEngineServerAlias(String s, Principal[] aprincipal, SSLEngine sslengine) {
        return this.chooseServerAlias(s, aprincipal, null);
    }
}

