/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.server;

import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import net.dona.doip.BadDoipException;
import net.dona.doip.DoipResponseHeadersWithRequestId;
import net.dona.doip.InDoipMessageImpl;
import net.dona.doip.OutDoipMessageImpl;
import net.dona.doip.server.DoipProcessor;
import net.dona.doip.server.DoipServerConfig;
import net.dona.doip.server.DoipServerRequestImpl;
import net.dona.doip.server.DoipServerResponseImpl;
import net.dona.doip.util.GsonUtility;
import net.dona.doip.util.tls.AllTrustingTrustManager;
import net.dona.doip.util.tls.AutoSelfSignedKeyManager;
import net.dona.doip.util.tls.TlsProtocolAndCipherSuiteConfigurationUtil;
import net.dona.doip.util.tls.X509IdParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoipServer {
    private static final Logger logger = LoggerFactory.getLogger(DoipServer.class);
    private static final AtomicInteger serverCount = new AtomicInteger(1);
    private final DoipServerConfig config;
    private final boolean willShutdownDoipProcessorLifecycle;
    private ServerSocket serverSocket;
    private DoipProcessor doipProcessor;
    private ExecutorService execServ;
    private int port;
    private volatile boolean keepServing;
    private final ConcurrentMap<Long, Socket> activeSockets = new ConcurrentHashMap<Long, Socket>();

    public DoipServer(DoipServerConfig config) {
        this.config = config;
        this.willShutdownDoipProcessorLifecycle = true;
        this.port = config.port;
    }

    public DoipServer(DoipServerConfig config, DoipProcessor doipProcessor) {
        this.config = config;
        this.doipProcessor = doipProcessor;
        this.willShutdownDoipProcessorLifecycle = false;
        this.port = config.port;
    }

    public void init() throws Exception {
        if (this.doipProcessor == null) {
            this.doipProcessor = (DoipProcessor)Class.forName(this.config.processorClass).newInstance();
            this.doipProcessor.init(this.config.processorConfig);
        }
        this.initServerSocket();
        AtomicInteger threadCount = new AtomicInteger(1);
        int thisServerCount = serverCount.getAndIncrement();
        this.execServ = Executors.newFixedThreadPool(this.config.numThreads, r -> new Thread(r, "doip-server-" + thisServerCount + "-" + threadCount.getAndIncrement()));
        this.keepServing = true;
        new Thread(this::serveRequests, "DOIP-Socket-Accept-Thread").start();
    }

    public int getPort() {
        return this.port;
    }

    private void initServerSocket() throws KeyManagementException, IOException, UnknownHostException {
        String ephemeralDHKeySize = System.getProperty("jdk.tls.ephemeralDHKeySize");
        if (ephemeralDHKeySize == null) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
        }
        SSLContext sslContext = DoipServer.getServerSSLContext(this.config.tlsConfig);
        SSLServerSocketFactory serverSocketFactory = sslContext.getServerSocketFactory();
        this.serverSocket = serverSocketFactory.createServerSocket();
        ((SSLServerSocket)this.serverSocket).setWantClientAuth(true);
        TlsProtocolAndCipherSuiteConfigurationUtil.configureEnabledProtocolsAndCipherSuites(this.serverSocket);
        this.serverSocket.bind(new InetSocketAddress(InetAddress.getByName(this.config.listenAddress), this.config.port), this.config.backlog);
        this.port = this.serverSocket.getLocalPort();
    }

    private static SSLContext getServerSSLContext(DoipServerConfig.TlsConfig tlsConfig) throws KeyManagementException {
        try {
            AutoSelfSignedKeyManager km;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            try {
                km = tlsConfig == null ? new AutoSelfSignedKeyManager(null) : (tlsConfig.certificateChain != null ? new AutoSelfSignedKeyManager(null, tlsConfig.certificateChain, tlsConfig.privateKey) : (tlsConfig.publicKey != null ? new AutoSelfSignedKeyManager(tlsConfig.id, tlsConfig.publicKey, tlsConfig.privateKey) : new AutoSelfSignedKeyManager(tlsConfig.id)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            KeyManager[] kms = new KeyManager[]{km};
            TrustManager[] tms = new TrustManager[]{new AllTrustingTrustManager()};
            sslContext.init(kms, tms, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void serveRequests() {
        while (this.keepServing) {
            try {
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(this.config.maxIdleTimeMillis);
                this.execServ.execute(() -> this.handle(socket));
            }
            catch (Exception e) {
                if (!this.keepServing) continue;
                logger.error("Exception accepting request", (Throwable)e);
            }
        }
    }

    private void handle(Socket socket) {
        this.activeSockets.put(Thread.currentThread().getId(), socket);
        try {
            if (this.keepServing) {
                this.handleMessagesThrowing(socket);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.activeSockets.remove(Thread.currentThread().getId());
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleMessagesThrowing(Socket socket) throws IOException {
        int ch;
        PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(socket.getInputStream()));
        while ((ch = in.read()) > -1) {
            in.unread(ch);
            InDoipMessageImpl inDoipMessage = new InDoipMessageImpl(in);
            OutDoipMessageImpl outDoipMessage = new OutDoipMessageImpl(new BufferedOutputStream(socket.getOutputStream()));
            String requestId = null;
            try {
                X509Certificate[] clientCertChain = this.getClientCertChain(socket);
                String clientCertId = X509IdParser.parseIdentityHandle(clientCertChain);
                PublicKey clientCertPublicKey = null;
                if (clientCertChain != null && clientCertChain.length > 0) {
                    clientCertPublicKey = clientCertChain[0].getPublicKey();
                }
                DoipServerRequestImpl req = new DoipServerRequestImpl(inDoipMessage, clientCertId, clientCertPublicKey, clientCertChain);
                requestId = req.getRequestId();
                DoipServerResponseImpl resp = new DoipServerResponseImpl(requestId, outDoipMessage);
                try {
                    this.doipProcessor.process(req, resp);
                    resp.commit();
                    outDoipMessage.close();
                    inDoipMessage.close();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
            }
            catch (BadDoipException e) {
                outDoipMessage.closeSegmentOutput();
                this.writeBadDoipException(requestId, socket.getOutputStream(), e.getMessage());
                throw e;
            }
            catch (SocketTimeoutException e) {
                outDoipMessage.closeSegmentOutput();
                this.writeBadDoipException(requestId, socket.getOutputStream(), e.getMessage());
                throw e;
            }
            catch (Exception e) {
                if (this.keepServing) {
                    logger.warn("Exception handling message", (Throwable)e);
                }
                outDoipMessage.closeSegmentOutput();
                this.writeServerException(requestId, socket.getOutputStream(), "An unexpected server error occurred");
                throw e;
            }
        }
    }

    private X509Certificate[] getClientCertChain(Socket socket) {
        if (!(socket instanceof SSLSocket)) {
            return null;
        }
        try {
            Certificate[] certs = ((SSLSocket)socket).getSession().getPeerCertificates();
            if (certs == null || certs.length == 0) {
                return null;
            }
            X509Certificate[] res = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                if (!(certs[i] instanceof X509Certificate)) {
                    return null;
                }
                res[i] = (X509Certificate)certs[i];
            }
            return res;
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    private void writeBadDoipException(String requestId, OutputStream out, String message) throws IOException {
        DoipResponseHeadersWithRequestId segment = new DoipResponseHeadersWithRequestId();
        segment.requestId = requestId;
        segment.status = "0.DOIP/Status.101";
        segment.attributes = new JsonObject();
        segment.attributes.addProperty("message", message);
        String resp = GsonUtility.getGson().toJson((Object)segment);
        resp = resp + "\n#\n#\n";
        out.write(resp.getBytes(StandardCharsets.UTF_8));
        out.flush();
    }

    private void writeServerException(String requestId, OutputStream out, String message) throws IOException {
        DoipResponseHeadersWithRequestId segment = new DoipResponseHeadersWithRequestId();
        segment.requestId = requestId;
        segment.status = "0.DOIP/Status.500";
        segment.attributes = new JsonObject();
        segment.attributes.addProperty("message", message);
        String resp = GsonUtility.getGson().toJson((Object)segment);
        resp = resp + "\n#\n#\n";
        out.write(resp.getBytes(StandardCharsets.UTF_8));
        out.flush();
    }

    public void shutdown() {
        this.keepServing = false;
        try {
            this.execServ.shutdown();
        }
        catch (Exception e) {
            logger.error("Shutdown error", (Throwable)e);
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            logger.error("Shutdown error", (Throwable)e);
        }
        for (Socket socket : this.activeSockets.values()) {
            try {
                socket.close();
            }
            catch (Exception e) {
                logger.error("Shutdown error", (Throwable)e);
            }
        }
        try {
            this.execServ.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Exception e) {
            logger.error("Shutdown error", (Throwable)e);
        }
        if (this.willShutdownDoipProcessorLifecycle) {
            try {
                this.doipProcessor.shutdown();
            }
            catch (Exception e) {
                logger.error("Shutdown error", (Throwable)e);
            }
        }
    }
}

