/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip;

import com.google.gson.JsonElement;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import net.dona.doip.OutDoipMessage;

public class OutDoipMessageImpl
implements OutDoipMessage {
    private static final byte[] SEGMENT_TERMINATOR = new byte[]{10, 35, 10};
    private static final byte[] EMPTY_SEGMENT = new byte[]{35, 10};
    private final OutputStream out;
    private boolean isClosed;
    private Closeable openCloseable;

    public OutDoipMessageImpl(OutputStream out) {
        this.out = out;
    }

    @Override
    public void writeJson(JsonElement json) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        this.writeJson(json.toString());
    }

    @Override
    public void writeJson(String json) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        this.writeJson(json.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void writeJson(byte[] json) throws IOException {
        if (json == null) {
            throw new NullPointerException();
        }
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        this.out.write(json);
        this.out.write(SEGMENT_TERMINATOR);
        this.out.flush();
    }

    @Override
    public Writer getJsonWriter() {
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        JsonSegmentWriter writer = new JsonSegmentWriter(this.out);
        this.openCloseable = writer;
        return new BufferedWriter(writer);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        this.out.write(64);
        this.writeChunkString(bytes.length);
        this.out.write(bytes);
        this.out.write(SEGMENT_TERMINATOR);
        this.out.flush();
    }

    @Override
    public void writeBytes(InputStream in) throws IOException {
        int r;
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        this.out.write(64);
        byte[] bytes = new byte[8192];
        while ((r = in.read(bytes)) > 0) {
            this.writeChunkString(r);
            this.out.write(bytes, 0, r);
        }
        this.out.write(SEGMENT_TERMINATOR);
        this.out.flush();
    }

    private void writeChunkString(int size) throws IOException {
        String chunkString = "\n" + size + "\n";
        this.out.write(chunkString.getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public OutputStream getBytesOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("closed");
        }
        if (this.openCloseable != null) {
            throw new IllegalStateException("already opened segment output stream or writer");
        }
        this.out.write(64);
        BytesSegmentOutputStream output = new BytesSegmentOutputStream();
        this.openCloseable = output;
        return new BufferedOutputStream(output);
    }

    public void closeSegmentOutput() throws IOException {
        if (this.openCloseable != null) {
            this.openCloseable.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.openCloseable != null) {
            this.openCloseable.close();
        }
        this.isClosed = true;
        this.out.write(EMPTY_SEGMENT);
        this.out.flush();
    }

    private class BytesSegmentOutputStream
    extends OutputStream {
        private BytesSegmentOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            OutDoipMessageImpl.this.writeChunkString(1);
            OutDoipMessageImpl.this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            if (b.length == 0) {
                return;
            }
            OutDoipMessageImpl.this.writeChunkString(b.length);
            OutDoipMessageImpl.this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            if (len == 0) {
                return;
            }
            OutDoipMessageImpl.this.writeChunkString(len);
            OutDoipMessageImpl.this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.flush();
        }

        @Override
        public void close() throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            this.flush();
            OutDoipMessageImpl.this.out.write(SEGMENT_TERMINATOR);
            OutDoipMessageImpl.this.out.flush();
            super.close();
            OutDoipMessageImpl.this.openCloseable = null;
        }
    }

    private class JsonSegmentWriter
    extends OutputStreamWriter {
        private JsonSegmentWriter(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int c) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.write(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.write(cbuf, off, len);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.write(str, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.flush();
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.write(cbuf);
        }

        @Override
        public void write(String str) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            super.write(str);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            return super.append(csq);
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            return super.append(csq, start, end);
        }

        @Override
        public Writer append(char c) throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            return super.append(c);
        }

        @Override
        public void close() throws IOException {
            if (OutDoipMessageImpl.this.isClosed) {
                throw new IllegalStateException("closed");
            }
            this.flush();
            OutDoipMessageImpl.this.out.write(SEGMENT_TERMINATOR);
            OutDoipMessageImpl.this.out.flush();
            OutDoipMessageImpl.this.openCloseable = null;
        }
    }
}

