/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.ByteArrayOutputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;

public class X509HSTrustManager
implements X509TrustManager {
    private final HandleResolver resolver;

    public X509HSTrustManager(HandleResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or empty certificate chain");
        }
        this.authenticate(chain[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or empty certificate chain");
        }
        this.authenticate(chain[0]);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private void authenticate(X509Certificate cert) throws CertificateException {
        ValueReference identity = X509HSTrustManager.parseIdentity(cert);
        if (identity == null) {
            throw new CertificateException("Unable to parse identity from certificate");
        }
        try {
            byte[][] reqTypes;
            int[] reqIndexes;
            if (identity.index == 0) {
                reqIndexes = null;
                reqTypes = new byte[][]{Common.PUBLIC_KEY_TYPE};
            } else {
                reqTypes = null;
                reqIndexes = new int[]{identity.index};
            }
            ResolutionRequest resReq = new ResolutionRequest(identity.handle, reqTypes, reqIndexes, null);
            AbstractResponse resp = this.resolver.processRequest(resReq);
            if (!(resp instanceof ResolutionResponse)) {
                throw new CertificateException("Unexpected response validating X509 certificate", HandleException.ofResponse(resp));
            }
            HandleValue[] values = ((ResolutionResponse)resp).getHandleValues();
            byte[] pubKeyBytes = this.getPublicKeyBytesFromCertificate(cert);
            X509HSTrustManager.authenticate(identity, values, pubKeyBytes);
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException("Exception validating X509 certificate", e);
        }
    }

    private static void authenticate(ValueReference identity, HandleValue[] values, byte[] pubKeyBytes) throws CertificateException {
        for (HandleValue value : values) {
            if (identity.index != 0 && value.getIndex() != identity.index) continue;
            if (Util.equals(value.getData(), pubKeyBytes)) {
                return;
            }
            if (value.hasType(Common.SITE_INFO_TYPE) || value.hasType(Common.DERIVED_PREFIX_SITE_TYPE) || value.hasType(Common.LEGACY_DERIVED_PREFIX_SITE_TYPE)) {
                try {
                    SiteInfo site = new SiteInfo();
                    Encoder.decodeSiteInfoRecord(value.getData(), 0, site);
                    for (ServerInfo server : site.servers) {
                        if (!Util.equals(server.publicKey, pubKeyBytes)) continue;
                        return;
                    }
                    continue;
                }
                catch (Exception site) {
                    continue;
                }
            }
            if (!value.hasType(Common.HS_CERT_TYPE)) continue;
            try {
                JsonWebSignature jws = JsonWebSignatureFactory.getInstance().deserialize(value.getDataAsString());
                HandleClaimsSet claims = HandleVerifier.getInstance().getHandleClaimsSet(jws);
                if (!Util.equals(pubKeyBytes, Util.getBytesFromPublicKey(claims.publicKey))) continue;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new CertificateException("Unable to validate X509 certificate, no matching handle value");
    }

    private byte[] getPublicKeyBytesFromCertificate(Certificate certificate) throws Exception {
        return Util.getBytesFromPublicKey(certificate.getPublicKey());
    }

    private static ValueReference parseIdentityFromRfc2253Dn(String dn) {
        return new Rfc2253DnParser(dn).getValueReference();
    }

    public static ValueReference parseIdentity(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return X509HSTrustManager.parseIdentityFromRfc2253Dn(cert.getSubjectX500Principal().getName());
    }

    public static ValueReference parseIdentity(X509Certificate[] cert) {
        if (cert == null || cert.length == 0) {
            return null;
        }
        return X509HSTrustManager.parseIdentity(cert[0]);
    }

    private static String parseIdentityHandleFromRfc2253Dn(String dn) {
        return new Rfc2253DnParser(dn).getHandle();
    }

    public static String parseIdentityHandle(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        return X509HSTrustManager.parseIdentityHandleFromRfc2253Dn(cert.getSubjectX500Principal().getName());
    }

    public static String parseIdentityHandle(X509Certificate[] cert) {
        if (cert == null || cert.length == 0) {
            return null;
        }
        return X509HSTrustManager.parseIdentityHandle(cert[0]);
    }

    private static class Rfc2253DnParser {
        private final String dn;
        private int index;

        Rfc2253DnParser(String dn) {
            this.dn = dn;
        }

        private static String trim(String s) {
            char ch;
            int start = 0;
            int end = 0;
            for (start = 0; start < s.length() && (ch = s.charAt(start)) == ' '; ++start) {
            }
            boolean escaped = false;
            for (int i = start; i < s.length(); ++i) {
                char ch2 = s.charAt(i);
                boolean isSpace = false;
                if (escaped) {
                    escaped = false;
                } else if (ch2 == '\\') {
                    escaped = true;
                } else if (ch2 == ' ') {
                    isSpace = true;
                }
                if (isSpace) continue;
                end = i;
            }
            if (start > end) {
                return "";
            }
            return s.substring(start, end + 1);
        }

        private String getType() {
            int start = this.index;
            this.index = this.dn.indexOf(61, start);
            if (this.index < 0) {
                return null;
            }
            String type = this.dn.substring(start, this.index);
            ++this.index;
            return Rfc2253DnParser.trim(type);
        }

        private char findSeparator() {
            boolean quoted = false;
            boolean escaped = false;
            while (this.index < this.dn.length()) {
                char ch = this.dn.charAt(this.index);
                if (!(quoted || escaped || ch != '+' && ch != ',' && ch != ';')) {
                    return ch;
                }
                if (escaped) {
                    escaped = false;
                } else if (ch == '\\') {
                    escaped = true;
                } else if (ch == '\"') {
                    quoted = !quoted;
                }
                ++this.index;
            }
            return ',';
        }

        private static boolean isHexChar(byte ch) {
            return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
        }

        private static int nibbleDecode(byte b) {
            if (b >= 48 && b <= 57) {
                return b - 48;
            }
            if (b >= 97 && b <= 102) {
                return 10 + b - 97;
            }
            if (b >= 65 && b <= 70) {
                return 10 + b - 65;
            }
            return b;
        }

        private static byte hexDecode(byte b1, byte b2) {
            return (byte)((Rfc2253DnParser.nibbleDecode(b1) << 4 | Rfc2253DnParser.nibbleDecode(b2)) & 0xFF);
        }

        private static String unescape(String value) {
            boolean quoted = false;
            boolean escaped = false;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] bytes = Util.encodeString(value);
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (escaped) {
                    escaped = false;
                    if (Rfc2253DnParser.isHexChar(b)) {
                        if (++i >= bytes.length) break;
                        byte b2 = bytes[i];
                        bout.write(Rfc2253DnParser.hexDecode(b, b2));
                        continue;
                    }
                    bout.write(b);
                    continue;
                }
                if (b == 92) {
                    escaped = true;
                    continue;
                }
                if (b == 34) {
                    quoted = !quoted;
                    continue;
                }
                bout.write(b);
            }
            return Util.decodeString(bout.toByteArray());
        }

        private String getValue() {
            int start = this.index;
            this.findSeparator();
            String value = this.dn.substring(start, this.index);
            ++this.index;
            value = Rfc2253DnParser.trim(value);
            if (value.startsWith("#")) {
                return null;
            }
            return Rfc2253DnParser.unescape(value);
        }

        String getHandleOrValueReference() {
            String type;
            String uid = null;
            String cn = null;
            String o = null;
            while (this.index >= 0 && this.index < this.dn.length() && (type = this.getType()) != null) {
                String value = this.getValue();
                if (value == null) continue;
                if ("UID".equalsIgnoreCase(type) && uid == null) {
                    uid = value;
                }
                if ("CN".equalsIgnoreCase(type) && cn == null) {
                    cn = value;
                }
                if (!"O".equalsIgnoreCase(type) || o != null) continue;
                o = value;
            }
            if (uid != null) {
                return uid;
            }
            if (cn != null) {
                return cn;
            }
            return o;
        }

        private static boolean isDigits(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                return false;
            }
            return true;
        }

        ValueReference getValueReference() {
            String handleOr = this.getHandleOrValueReference();
            if (handleOr == null) {
                return null;
            }
            int colon = handleOr.indexOf(58);
            if (colon < 0) {
                return new ValueReference(Util.encodeString(handleOr), 0);
            }
            String maybeIndex = handleOr.substring(0, colon);
            if (Rfc2253DnParser.isDigits(maybeIndex)) {
                String handle = handleOr.substring(colon + 1);
                return new ValueReference(Util.encodeString(handle), Integer.parseInt(maybeIndex));
            }
            return new ValueReference(Util.encodeString(handleOr), 0);
        }

        String getHandle() {
            String handleOr = this.getHandleOrValueReference();
            if (handleOr == null) {
                return null;
            }
            int colon = handleOr.indexOf(58);
            if (colon < 0) {
                return handleOr;
            }
            String maybeIndex = handleOr.substring(0, colon);
            if (Rfc2253DnParser.isDigits(maybeIndex)) {
                String handle = handleOr.substring(colon + 1);
                return handle;
            }
            return handleOr;
        }
    }
}

