/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;

public class PublicKeyAuthenticationInfo
extends AuthenticationInfo {
    private final PrivateKey privateKey;
    private final byte[] userIdHandle;
    private final int userIdIndex;

    public PublicKeyAuthenticationInfo(byte[] userIdHandle, int userIdIndex, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.userIdHandle = userIdHandle;
        this.userIdIndex = userIdIndex;
    }

    @Override
    public byte[] getAuthType() {
        return Common.PUBLIC_KEY_TYPE;
    }

    @Override
    public byte[] authenticate(ChallengeResponse challenge, AbstractRequest request) throws HandleException {
        byte[] origDigest = Util.doDigest(challenge.rdHashType, (byte[][])new byte[][]{request.getEncodedMessageBody()});
        if (!Util.equals(origDigest, challenge.requestDigest)) {
            throw new HandleException(10, "Asked to sign unidentified request!");
        }
        byte[] signatureBytes = null;
        byte[] sigHashType = null;
        try {
            Signature signer = null;
            String alg = this.privateKey.getAlgorithm().trim();
            signer = Signature.getInstance(Util.getDefaultSigId(alg, challenge));
            signer.initSign(this.privateKey);
            signer.update(challenge.nonce);
            signer.update(challenge.requestDigest);
            signatureBytes = signer.sign();
            sigHashType = Util.getHashAlgIdFromSigId(signer.getAlgorithm());
            int offset = 0;
            byte[] signature = new byte[signatureBytes.length + sigHashType.length + 8];
            offset += Encoder.writeByteArray(signature, offset, sigHashType);
            offset += Encoder.writeByteArray(signature, offset, signatureBytes);
            return signature;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new HandleException(1, "Unable to sign challenge: ", e);
        }
    }

    @Override
    public byte[] getUserIdHandle() {
        return this.userIdHandle;
    }

    @Override
    public int getUserIdIndex() {
        return this.userIdIndex;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String toString() {
        return "public_key:" + String.valueOf(this.userIdIndex) + ':' + (this.userIdHandle == null ? "null" : Util.decodeString(this.userIdHandle));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.privateKey == null ? 0 : Arrays.hashCode(this.privateKey.getEncoded()));
        result = 31 * result + Arrays.hashCode(this.userIdHandle);
        result = 31 * result + this.userIdIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicKeyAuthenticationInfo other = (PublicKeyAuthenticationInfo)obj;
        if (!Arrays.equals(this.userIdHandle, other.userIdHandle)) {
            return false;
        }
        if (this.userIdIndex != other.userIdIndex) {
            return false;
        }
        return !(this.privateKey == null ? other.privateKey != null : !Util.equals(this.privateKey.getEncoded(), other.privateKey.getEncoded()));
    }
}

