/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Arrays;
import net.handle.hdllib.Cache;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.util.LRUCacheTable;

public class MemCache
implements Cache {
    private final LRUCacheTable<String, byte[]> db;
    private long maxTTL = 3600L;
    private static final byte[][] cachedNotFoundResult = new byte[1][4];

    public MemCache(int maxHandles, long maxTTL) {
        this.maxTTL = maxTTL;
        this.db = new LRUCacheTable(maxHandles);
    }

    @Deprecated
    public MemCache(int maxHandles, long maxTTL, boolean trackHits) {
        this(maxHandles, maxTTL);
    }

    public MemCache(long maxTTL) {
        this(100, maxTTL);
    }

    public MemCache() {
        this(100, 3600L);
    }

    @Override
    public boolean isCachedNotFound(byte[][] values) {
        return values == cachedNotFoundResult;
    }

    private boolean isCachedNotFoundClumps(byte[] clumps) {
        return Encoder.readInt(clumps, 0) < 0;
    }

    private int notFoundTimeRetrieved(byte[] notfound) {
        return Encoder.readInt(notfound, 4);
    }

    private int notFoundTTL(byte[] notfound) {
        return Encoder.readInt(notfound, 8);
    }

    @Override
    public byte[][] getCachedValues(byte[] handle, byte[][] reqTypes, int[] reqIndexes) throws Exception {
        int clumpIndex;
        byte[] clumpType;
        int clumpLen;
        byte[] clumps;
        try {
            String key = Util.decodeString(handle);
            clumps = this.db.get(key);
        }
        catch (Exception e) {
            System.err.println("cache error: " + e);
            e.printStackTrace(System.err);
            return null;
        }
        if (clumps == null) {
            return null;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (this.isCachedNotFoundClumps(clumps)) {
            if ((long)(now - this.notFoundTimeRetrieved(clumps)) > Math.min(this.maxTTL, (long)this.notFoundTTL(clumps))) {
                return null;
            }
            return cachedNotFoundResult;
        }
        int idx = 0;
        boolean allValues = !(reqIndexes != null && reqIndexes.length > 0 || reqTypes != null && reqTypes.length > 0);
        byte[][] types = new byte[Encoder.readInt(clumps, idx)][];
        idx += 4;
        idx += Encoder.readByteArrayArray(types, clumps, idx);
        int[] indexes = Encoder.readIntArray(clumps, idx);
        idx += 4 + 4 * indexes.length;
        idx += 4;
        if (types.length != 0 || indexes.length != 0) {
            int i;
            if (allValues) {
                return null;
            }
            if (reqIndexes != null && reqIndexes.length > 0) {
                for (i = 0; i < reqIndexes.length; ++i) {
                    if (Util.isInArray(indexes, reqIndexes[i])) continue;
                    return null;
                }
            }
            if (reqTypes != null && reqTypes.length > 0) {
                for (i = 0; i < reqTypes.length; ++i) {
                    if (Util.isParentTypeInArray(types, reqTypes[i]) || Util.isInArray(types, reqTypes[i])) continue;
                    return null;
                }
            }
        }
        int startIdx = idx;
        int numMatches = 0;
        boolean gotClumps = false;
        while (idx < clumps.length) {
            clumpLen = Encoder.readInt(clumps, idx);
            idx += 4;
            clumpType = Encoder.getHandleValueType(clumps, idx += 4);
            clumpIndex = Encoder.getHandleValueIndex(clumps, idx);
            if (allValues || Util.isParentTypeInArray(reqTypes, clumpType) || Util.isInArray(reqIndexes, clumpIndex)) {
                ++numMatches;
            }
            gotClumps = true;
            idx += clumpLen;
        }
        if (!gotClumps || numMatches == 0) {
            return null;
        }
        byte[][] retValues = new byte[numMatches][];
        int clumpNum = 0;
        HandleValue testValue = null;
        for (idx = startIdx; idx < clumps.length; idx += clumpLen) {
            clumpLen = Encoder.readInt(clumps, idx);
            int valueDate = Encoder.readInt(clumps, idx += 4);
            clumpType = Encoder.getHandleValueType(clumps, idx += 4);
            clumpIndex = Encoder.getHandleValueIndex(clumps, idx);
            if (!allValues && !Util.isParentTypeInArray(reqTypes, clumpType) && !Util.isInArray(reqIndexes, clumpIndex)) continue;
            retValues[clumpNum] = new byte[clumpLen];
            if (testValue == null) {
                testValue = new HandleValue();
            }
            Encoder.decodeHandleValue(clumps, idx, testValue);
            if (testValue.isExpired(now, valueDate)) {
                return null;
            }
            if ((long)(now - valueDate) > this.maxTTL) {
                return null;
            }
            System.arraycopy(clumps, idx, retValues[clumpNum], 0, retValues[clumpNum].length);
            ++clumpNum;
        }
        if (clumpNum != retValues.length) {
            System.err.println("Unknown cache error!!!");
            Thread.dumpStack();
            return null;
        }
        return retValues;
    }

    @Override
    public void setCachedNotFound(byte[] handle, int ttl) throws Exception {
        String key = Util.decodeString(handle);
        int now = (int)(System.currentTimeMillis() / 1000L);
        byte[] dataBuf = new byte[12];
        Encoder.writeInt(dataBuf, 0, -1);
        Encoder.writeInt(dataBuf, 4, now);
        Encoder.writeInt(dataBuf, 8, ttl);
        this.db.put(key, dataBuf);
    }

    @Override
    public void removeHandle(byte[] handle) throws Exception {
        this.db.remove(Util.decodeString(handle));
    }

    @Override
    public void setCachedValues(byte[] handle, HandleValue[] newValues, byte[][] newTypeList, int[] newIndexList) throws Exception {
        int lenLoc;
        int i;
        int i2;
        int j;
        int j2;
        int thisIndex;
        int i3;
        if (newValues != null && newTypeList != null && ((byte[][])newTypeList).length > 0) {
            if (newIndexList == null) {
                newIndexList = new int[]{};
            }
            int[] expIndexList = new int[newIndexList.length + newValues.length];
            System.arraycopy(newIndexList, 0, expIndexList, 0, newIndexList.length);
            for (int i4 = 0; i4 < newValues.length; ++i4) {
                expIndexList[newIndexList.length + i4] = newValues[i4].index;
            }
            Arrays.sort(expIndexList);
            int uniq = 0;
            for (int i5 = 0; i5 < expIndexList.length; ++i5) {
                if (i5 != 0 && expIndexList[i5] == expIndexList[i5 - 1]) continue;
                ++uniq;
            }
            newIndexList = new int[uniq];
            int count = 0;
            int i6 = 0;
            while (count < uniq) {
                if (i6 == 0 || expIndexList[i6] != expIndexList[i6 - 1]) {
                    newIndexList[count++] = expIndexList[i6];
                }
                ++i6;
            }
        }
        byte[][] types = null;
        int[] indexes = null;
        int[] valueDates = null;
        HandleValue[] values = null;
        byte[] clumps = null;
        String key = Util.decodeString(handle);
        try {
            clumps = this.db.get(key);
        }
        catch (Exception e) {
            System.err.println("MemCache error: " + e);
            e.printStackTrace(System.err);
            return;
        }
        int idx = 0;
        if (clumps != null && !this.isCachedNotFoundClumps(clumps)) {
            types = new byte[Encoder.readInt(clumps, idx)][];
            idx += 4;
            idx += Encoder.readByteArrayArray(types, clumps, idx);
            indexes = Encoder.readIntArray(clumps, idx);
            values = new HandleValue[Encoder.readInt(clumps, idx += 4 + 4 * indexes.length)];
            idx += 4;
            valueDates = new int[values.length];
            int i7 = 0;
            while (idx < clumps.length) {
                int clumpLen = Encoder.readInt(clumps, idx);
                valueDates[i7] = Encoder.readInt(clumps, idx += 4);
                values[i7] = new HandleValue();
                Encoder.decodeHandleValue(clumps, idx += 4, values[i7]);
                ++i7;
                idx += clumpLen;
            }
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (!(newTypeList != null && ((byte[][])newTypeList).length > 0 || newIndexList != null && newIndexList.length > 0)) {
            types = null;
            indexes = null;
            values = null;
        } else if (types != null && types.length <= 0 && indexes != null && indexes.length <= 0) {
            for (i3 = 0; values != null && newValues != null && i3 < newValues.length; ++i3) {
                thisIndex = newValues[i3].index;
                for (j2 = 0; j2 < values.length; ++j2) {
                    if (values[j2] == null || values[j2].index != thisIndex) continue;
                    values[j2] = null;
                }
            }
            if (values != null && newTypeList != null && ((byte[][])newTypeList).length > 0) {
                for (j = 0; j < values.length; ++j) {
                    if (values[j] == null || !Util.isParentTypeInArray(newTypeList, values[j].type)) continue;
                    values[j] = null;
                }
            }
            newTypeList = null;
            newIndexList = null;
        } else {
            int i8;
            if (values != null && newTypeList != null && ((byte[][])newTypeList).length > 0) {
                for (j = 0; j < values.length; ++j) {
                    if (values[j] == null || !Util.isParentTypeInArray(newTypeList, values[j].type)) continue;
                    values[j] = null;
                }
            }
            if (newTypeList != null && ((byte[][])newTypeList).length > 0) {
                byte[][] typeListCopy = new byte[((byte[][])newTypeList).length][];
                System.arraycopy(newTypeList, 0, typeListCopy, 0, ((byte[][])newTypeList).length);
                newTypeList = typeListCopy;
                for (i8 = 0; types != null && i8 < types.length; ++i8) {
                    if (types[i8] == null) continue;
                    for (j2 = 0; newTypeList != null && j2 < ((byte[][])newTypeList).length; ++j2) {
                        if (newTypeList[j2] == null || !Util.equalsCI(types[i8], newTypeList[j2])) continue;
                        newTypeList[j2] = null;
                    }
                }
            }
            if (newIndexList != null && newIndexList.length > 0) {
                int[] indexListCopy = new int[newIndexList.length];
                System.arraycopy(newIndexList, 0, indexListCopy, 0, newIndexList.length);
                newIndexList = indexListCopy;
                for (i8 = 0; indexes != null && i8 < indexes.length; ++i8) {
                    if (indexes[i8] < 0) continue;
                    for (j2 = 0; newIndexList != null && j2 < newIndexList.length; ++j2) {
                        if (newIndexList[j2] < 0 || indexes[i8] != newIndexList[j2]) continue;
                        newIndexList[j2] = -1;
                    }
                }
            }
            for (i3 = 0; values != null && newValues != null && i3 < newValues.length; ++i3) {
                thisIndex = newValues[i3].index;
                for (j2 = 0; j2 < values.length; ++j2) {
                    if (values[j2] == null || values[j2].index != thisIndex) continue;
                    values[j2] = null;
                }
            }
        }
        int dataLen = 0;
        int typeCount = 0;
        int indexCount = 0;
        int valueCount = 0;
        dataLen += 4;
        dataLen += 4;
        dataLen += 4;
        for (i2 = 0; types != null && i2 < types.length; ++i2) {
            if (types[i2] == null) continue;
            dataLen += 4 + types[i2].length;
            ++typeCount;
        }
        for (i2 = 0; newTypeList != null && i2 < ((byte[][])newTypeList).length; ++i2) {
            if (newTypeList[i2] == null) continue;
            dataLen += 4 + newTypeList[i2].length;
            ++typeCount;
        }
        for (i2 = 0; indexes != null && i2 < indexes.length; ++i2) {
            if (indexes[i2] < 0) continue;
            dataLen += 4;
            ++indexCount;
        }
        for (i2 = 0; newIndexList != null && i2 < newIndexList.length; ++i2) {
            if (newIndexList[i2] < 0) continue;
            dataLen += 4;
            ++indexCount;
        }
        for (i2 = 0; values != null && i2 < values.length; ++i2) {
            if (values[i2] == null) continue;
            dataLen += 4;
            dataLen += 4;
            dataLen += Encoder.calcStorageSize(values[i2]);
            ++valueCount;
        }
        for (i2 = 0; newValues != null && i2 < newValues.length; ++i2) {
            if (newValues[i2] == null) continue;
            dataLen += 4;
            dataLen += 4;
            dataLen += Encoder.calcStorageSize(newValues[i2]);
            ++valueCount;
        }
        byte[] dataBuf = new byte[dataLen];
        int loc = 0;
        loc += Encoder.writeInt(dataBuf, loc, typeCount);
        for (i = 0; types != null && i < types.length; ++i) {
            if (types[i] == null) continue;
            loc += Encoder.writeByteArray(dataBuf, loc, types[i]);
        }
        for (i = 0; newTypeList != null && i < ((byte[][])newTypeList).length; ++i) {
            if (newTypeList[i] == null) continue;
            loc += Encoder.writeByteArray(dataBuf, loc, newTypeList[i]);
        }
        loc += Encoder.writeInt(dataBuf, loc, indexCount);
        for (i = 0; indexes != null && i < indexes.length; ++i) {
            if (indexes[i] < 0) continue;
            loc += Encoder.writeInt(dataBuf, loc, indexes[i]);
        }
        for (i = 0; newIndexList != null && i < newIndexList.length; ++i) {
            if (newIndexList[i] < 0) continue;
            loc += Encoder.writeInt(dataBuf, loc, newIndexList[i]);
        }
        loc += Encoder.writeInt(dataBuf, loc, valueCount);
        for (i = 0; values != null && valueDates != null && i < values.length; ++i) {
            if (values[i] == null) continue;
            lenLoc = loc;
            loc += 4;
            loc += Encoder.writeInt(dataBuf, loc, valueDates[i]);
            loc += Encoder.encodeHandleValue(dataBuf, loc, values[i]);
            Encoder.writeInt(dataBuf, lenLoc, loc - lenLoc - 8);
        }
        for (i = 0; newValues != null && i < newValues.length; ++i) {
            if (newValues[i] == null) continue;
            lenLoc = loc;
            loc += 4;
            loc += Encoder.writeInt(dataBuf, loc, now);
            loc += Encoder.encodeHandleValue(dataBuf, loc, newValues[i]);
            Encoder.writeInt(dataBuf, lenLoc, loc - lenLoc - 8);
        }
        this.db.put(key, dataBuf);
    }

    @Override
    public void clear() throws Exception {
        this.db.clear();
    }

    @Override
    public void setMaximumHandles(int maxHandles) {
        this.db.setMaxSize(maxHandles);
    }

    @Override
    public void setMaximumSize(int maxSize) {
        this.setMaximumHandles(maxSize / 1024);
    }

    @Override
    public void close() {
    }

    static {
        Encoder.writeInt(cachedNotFoundResult[0], 0, -1);
    }
}

