/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AddValueRequest;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.CreateHandleResponse;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.DumpHandlesRequest;
import net.handle.hdllib.DumpHandlesResponse;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GenericResponse;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ListHandlesRequest;
import net.handle.hdllib.ListHandlesResponse;
import net.handle.hdllib.ListNAsRequest;
import net.handle.hdllib.ListNAsResponse;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.NextTxnIdResponse;
import net.handle.hdllib.RemoveValueRequest;
import net.handle.hdllib.ReplicationStateInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.RetrieveTxnResponse;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.ServiceReferralResponse;
import net.handle.hdllib.SessionExchangeKeyRequest;
import net.handle.hdllib.SessionSetupRequest;
import net.handle.hdllib.SessionSetupResponse;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;

public abstract class Encoder {
    public static final int INT_SIZE = 4;
    public static final int INT2_SIZE = 2;
    public static final int LONG_SIZE = 8;
    public static final int MSG_FLAG_AUTH = Integer.MIN_VALUE;
    public static final int MSG_FLAG_CERT = 0x40000000;
    public static final int MSG_FLAG_ENCR = 0x20000000;
    public static final int MSG_FLAG_RECU = 0x10000000;
    public static final int MSG_FLAG_CACR = 0x8000000;
    public static final int MSG_FLAG_CONT = 0x4000000;
    public static final int MSG_FLAG_KPAL = 0x2000000;
    public static final int MSG_FLAG_PUBL = 0x1000000;
    public static final int MSG_FLAG_RRDG = 0x800000;
    public static final int MSG_FLAG_OVRW = 0x400000;
    public static final int MSG_FLAG_MINT = 0x200000;
    public static final int MSG_FLAG_DNRF = 0x100000;
    public static final byte ENV_FLAG_COMPRESSED = -128;
    public static final byte ENV_FLAG_ENCRYPTED = 64;
    public static final byte ENV_FLAG_TRUNCATED = 32;
    public static final byte PERM_ADMIN_READ = 8;
    public static final byte PERM_ADMIN_WRITE = 4;
    public static final byte PERM_PUBLIC_READ = 2;
    public static final byte PERM_PUBLIC_WRITE = 1;
    public static final String MSG_INVALID_ARRAY_SIZE = "Invalid array size";
    static final int PERM_ADD_HANDLE = 1;
    static final int PERM_DELETE_HANDLE = 2;
    static final int PERM_ADD_NA = 4;
    static final int PERM_DELETE_NA = 8;
    static final int PERM_MODIFY_VALUE = 16;
    static final int PERM_REMOVE_VALUE = 32;
    static final int PERM_ADD_VALUE = 64;
    static final int PERM_MODIFY_ADMIN = 128;
    static final int PERM_REMOVE_ADMIN = 256;
    static final int PERM_ADD_ADMIN = 512;
    static final int PERM_READ_VALUE = 1024;
    static final int PERM_LIST_HDLS = 2048;
    public static final int SESSION_FLAG_CERT = Integer.MIN_VALUE;
    public static final int SESSION_FLAG_ENCR = 0x40000000;

    public static final long readLong(byte[] buf, int offset) {
        return (long)(buf[offset] << 56) | ((long)buf[offset + 1] & 0xFFL) << 48 | ((long)buf[offset + 2] & 0xFFL) << 40 | ((long)buf[offset + 3] & 0xFFL) << 32 | ((long)buf[offset + 4] & 0xFFL) << 24 | ((long)buf[offset + 5] & 0xFFL) << 16 | ((long)buf[offset + 6] & 0xFFL) << 8 | (long)buf[offset + 7] & 0xFFL;
    }

    public static final int writeLong(byte[] buf, int offset, long value) {
        buf[offset++] = (byte)(0xFFL & value >>> 56);
        buf[offset++] = (byte)(0xFFL & value >>> 48);
        buf[offset++] = (byte)(0xFFL & value >>> 40);
        buf[offset++] = (byte)(0xFFL & value >>> 32);
        buf[offset++] = (byte)(0xFFL & value >>> 24);
        buf[offset++] = (byte)(0xFFL & value >>> 16);
        buf[offset++] = (byte)(0xFFL & value >>> 8);
        buf[offset++] = (byte)(0xFFL & value);
        return 8;
    }

    public static final int readInt2(byte[] buf, int offset) {
        return buf[offset] << 8 | buf[offset + 1] & 0xFF;
    }

    public static final int writeInt2(byte[] buf, int offset, int value) {
        buf[offset++] = (byte)((value & 0xFF00) >>> 8);
        buf[offset++] = (byte)(value & 0xFF);
        return 2;
    }

    public static final int readInt(byte[] buf, int offset) {
        return buf[offset] << 24 | (0xFF & buf[offset + 1]) << 16 | (0xFF & buf[offset + 2]) << 8 | 0xFF & buf[offset + 3];
    }

    public static final int writeInt(byte[] buf, int offset, int value) {
        buf[offset++] = (byte)(0xFF & value >>> 24);
        buf[offset++] = (byte)(0xFF & value >> 16);
        buf[offset++] = (byte)(0xFF & value >> 8);
        buf[offset++] = (byte)(0xFF & value);
        return 4;
    }

    public static final byte[] readByteArray(byte[] buf, int offset) throws HandleException {
        int len = Encoder.readInt(buf, offset);
        if (len < 0 || len > 0x100000) {
            throw new HandleException(6, MSG_INVALID_ARRAY_SIZE);
        }
        byte[] a = new byte[len];
        System.arraycopy(buf, offset + 4, a, 0, len);
        return a;
    }

    public static final int writeByteArray(byte[] buf, int offset, byte[] bufToWrite) {
        if (bufToWrite != null) {
            return Encoder.writeByteArray(buf, offset, bufToWrite, 0, bufToWrite.length);
        }
        return Encoder.writeInt(buf, offset, 0);
    }

    public static final int writeByteArray(byte[] buf, int offset, byte[] bufToWrite, int woffset, int length) {
        offset += Encoder.writeInt(buf, offset, length);
        System.arraycopy(bufToWrite, woffset, buf, offset, length);
        return 4 + length;
    }

    public static final int writeByteArrayArray(byte[] buf, int offset, byte[][] bufToWrite) {
        if (bufToWrite == null) {
            return Encoder.writeInt(buf, offset, 0);
        }
        int origOffset = offset;
        int alen = bufToWrite.length;
        offset += Encoder.writeInt(buf, offset, alen);
        for (int i = 0; i < alen; ++i) {
            offset += Encoder.writeByteArray(buf, offset, bufToWrite[i], 0, bufToWrite[i].length);
        }
        return offset - origOffset;
    }

    public static final int writeIntArray(byte[] buf, int offset, int[] bufToWrite) {
        if (bufToWrite == null) {
            return Encoder.writeInt(buf, offset, 0);
        }
        int alen = bufToWrite.length;
        offset += Encoder.writeInt(buf, offset, alen);
        for (int i = 0; i < alen; ++i) {
            offset += Encoder.writeInt(buf, offset, bufToWrite[i]);
        }
        return 4 + 4 * alen;
    }

    public static final int[] readIntArray(byte[] buf, int offset) throws HandleException {
        int len = Encoder.readInt(buf, offset);
        if (len < 0 || len > 0x100000) {
            throw new HandleException(6, MSG_INVALID_ARRAY_SIZE);
        }
        offset += 4;
        int[] a = new int[len];
        for (int i = 0; i < len; ++i) {
            a[i] = Encoder.readInt(buf, offset);
            offset += 4;
        }
        return a;
    }

    public static final int readByteArrayArray(byte[][] a, byte[] buf, int offset) throws HandleException {
        int origOffset = offset;
        for (int i = 0; i < a.length; ++i) {
            a[i] = Encoder.readByteArray(buf, offset);
            offset += a[i].length + 4;
        }
        return offset - origOffset;
    }

    public static final void dumpBytes(byte[] buf) {
        if (buf != null) {
            Encoder.dumpBytes(buf, 0, buf.length);
        }
    }

    public static final void dumpBytes(byte[] buf, int len) {
        Encoder.dumpBytes(buf, 0, len);
    }

    public static final void dumpBytes(byte[] buf, int offset, int len) {
        len += offset;
        int j = 0;
        int i = offset;
        while (i < len && i < buf.length) {
            if (j % 8 == 0) {
                System.err.print(i == 0 ? "" : "\n");
            } else {
                System.err.print("  ");
            }
            String hs = Integer.toHexString(0xFF & buf[i]);
            if (hs.length() < 2) {
                System.err.print('0');
            }
            System.err.print(hs);
            ++i;
            ++j;
        }
        System.err.print('\n');
    }

    public static int readOpCode(byte[] msg, int offset) {
        return Encoder.readInt(msg, offset);
    }

    public static final AbstractMessage decodeMessage(byte[] msg, int offset, MessageEnvelope envelope) throws HandleException {
        AbstractMessage message;
        int loc;
        MessageHeaders headers;
        block50: {
            int bodyOffset;
            block49: {
                headers = new MessageHeaders(msg, offset);
                loc = bodyOffset = headers.bodyOffset;
                message = null;
                if (headers.responseCode != 0) break block49;
                switch (headers.opCode) {
                    case 1: {
                        message = Encoder.decodeResolutionRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 200: {
                        message = Encoder.decodeChallengeAnswer(msg, loc, envelope);
                        break block50;
                    }
                    case 201: {
                        message = Encoder.decodeVerifyAuthRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 100: {
                        message = Encoder.decodeCreateHandleRequest(msg, loc, envelope, headers.opCode);
                        break block50;
                    }
                    case 102: {
                        message = Encoder.decodeAddValueRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 104: {
                        message = Encoder.decodeModifyValueRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 103: {
                        message = Encoder.decodeRemoveValueRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 101: {
                        message = Encoder.decodeDeleteHandleRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 105: {
                        message = Encoder.decodeListHandlesRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 302: {
                        message = Encoder.decodeListNAsRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 1001: {
                        message = Encoder.decodeRetrieveTxnRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 1002: {
                        message = Encoder.decodeDumpHandlesRequest(msg, loc, envelope, headers.bodyLen);
                        break block50;
                    }
                    case 400: {
                        message = Encoder.decodeSessionSetupRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 402: {
                        message = Encoder.decodeSessionExchangeKeyRequest(msg, loc, envelope);
                        break block50;
                    }
                    case 2: 
                    case 300: 
                    case 301: 
                    case 401: 
                    case 1000: 
                    case 1003: {
                        message = Encoder.decodeGenericRequest(msg, loc, headers.opCode, envelope);
                        break block50;
                    }
                    default: {
                        throw new HandleException(1, "Unknown opCode in message: " + headers.opCode);
                    }
                }
            }
            int bodyOffsetBeforeRequestDigest = bodyOffset;
            byte[] requestDigest = null;
            byte rdHashType = 0;
            if (headers.responseCode != 0 && (0x800000 & headers.opFlags) != 0) {
                rdHashType = msg[bodyOffset++];
                switch (rdHashType) {
                    case 3: {
                        requestDigest = new byte[32];
                        System.arraycopy(msg, bodyOffset, requestDigest, 0, 32);
                        bodyOffset += 32;
                        break;
                    }
                    case 2: {
                        requestDigest = new byte[20];
                        System.arraycopy(msg, bodyOffset, requestDigest, 0, 20);
                        bodyOffset += 20;
                        break;
                    }
                    case 1: {
                        requestDigest = new byte[16];
                        System.arraycopy(msg, bodyOffset, requestDigest, 0, 16);
                        bodyOffset += 16;
                        break;
                    }
                    case 0: {
                        requestDigest = Encoder.readByteArray(msg, --bodyOffset);
                        bodyOffset += 4 + requestDigest.length;
                        break;
                    }
                    default: {
                        throw new HandleException(6, "Unrecognized request hash type: " + rdHashType);
                    }
                }
            }
            int bodyLengthAfterRequestDigest = headers.bodyLen - (bodyOffset - bodyOffsetBeforeRequestDigest);
            block23 : switch (headers.responseCode) {
                case 1: {
                    switch (headers.opCode) {
                        case 1: {
                            message = Encoder.decodeResolutionResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 201: {
                            message = Encoder.decodeVerifyAuthResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 105: {
                            message = Encoder.decodeListHandlesResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 302: {
                            message = Encoder.decodeListNAsResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 1001: {
                            message = Encoder.decodeRetrieveTxnResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 1002: {
                            message = Encoder.decodeDumpHandlesResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 400: {
                            message = Encoder.decodeSetupSessionResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 100: {
                            message = Encoder.decodeCreateHandleResponse(msg, bodyOffset, envelope, bodyLengthAfterRequestDigest);
                            break block23;
                        }
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 300: 
                        case 301: 
                        case 401: 
                        case 402: 
                        case 1003: {
                            message = Encoder.decodeGenericResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 1000: {
                            message = Encoder.decodeNextTxnIdResponse(msg, bodyOffset, envelope);
                            break block23;
                        }
                        case 2: {
                            message = Encoder.decodeGetSiteInfoResponse(msg, bodyOffset, bodyLengthAfterRequestDigest, envelope);
                            break block23;
                        }
                    }
                    throw new HandleException(1, "Unknown opCode in response: " + headers.opCode);
                }
                case 302: {
                    message = Encoder.decodeServiceReferralResponse(headers.responseCode, msg, bodyOffset, envelope, bodyOffset + bodyLengthAfterRequestDigest);
                    break;
                }
                case 303: {
                    if (AbstractMessage.hasEqualOrGreaterVersion(envelope.protocolMajorVersion, envelope.protocolMinorVersion, 2, 5)) {
                        message = Encoder.decodeServiceReferralResponse(headers.responseCode, msg, bodyOffset, envelope, bodyOffset + bodyLengthAfterRequestDigest);
                        break;
                    }
                    message = Encoder.decodeErrorMessage(msg, bodyOffset, envelope, envelope.messageLength + offset);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 100: 
                case 101: 
                case 102: 
                case 200: 
                case 201: 
                case 202: 
                case 300: 
                case 301: 
                case 400: 
                case 401: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: {
                    message = Encoder.decodeErrorMessage(msg, bodyOffset, envelope, envelope.messageLength + offset);
                    break;
                }
                case 402: {
                    message = Encoder.decodeChallenge(msg, bodyOffset, headers.opCode, envelope);
                    break;
                }
                default: {
                    throw new HandleException(1, "Unknown responseCode: " + headers.responseCode);
                }
            }
            if (requestDigest != null) {
                message.requestDigest = requestDigest;
                message.rdHashType = rdHashType;
            }
        }
        if (message == null) {
            throw new HandleException(6, "Unknown message type: opCode=" + headers.opCode + "; responseCode=" + headers.responseCode);
        }
        message.messageBody = new byte[24 + headers.bodyLen];
        System.arraycopy(msg, offset, message.messageBody, 0, 24 + headers.bodyLen);
        message.sessionId = envelope.sessionId;
        message.requestId = envelope.requestId;
        message.majorProtocolVersion = envelope.protocolMajorVersion;
        message.minorProtocolVersion = envelope.protocolMinorVersion;
        message.suggestMajorProtocolVersion = envelope.suggestMajorProtocolVersion;
        message.suggestMinorProtocolVersion = envelope.suggestMinorProtocolVersion;
        message.opCode = headers.opCode;
        message.responseCode = headers.responseCode;
        message.siteInfoSerial = headers.serialNum;
        message.recursionCount = headers.recursionCount;
        if (headers.responseCode == 303 && !AbstractMessage.hasEqualOrGreaterVersion(envelope.protocolMajorVersion, envelope.protocolMinorVersion, 2, 5)) {
            message.responseCode = 7;
        }
        Encoder.decodeOpFlagsInToMessage(message, headers.opFlags);
        message.expiration = headers.expiration;
        if (offset + envelope.messageLength >= (loc += headers.bodyLen) + 4) {
            int signatureLength = Encoder.readInt(msg, loc);
            message.signature = new byte[signatureLength];
            System.arraycopy(msg, loc += 4, message.signature, 0, signatureLength);
            loc += signatureLength;
        }
        return message;
    }

    public static void decodeOpFlagsInToMessage(AbstractMessage message, int opFlags) {
        message.authoritative = (Integer.MIN_VALUE & opFlags) != 0;
        message.certify = (0x40000000 & opFlags) != 0;
        message.encrypt = (0x20000000 & opFlags) != 0;
        message.recursive = (0x10000000 & opFlags) != 0;
        message.cacheCertify = (0x8000000 & opFlags) != 0;
        message.ignoreRestrictedValues = (0x1000000 & opFlags) != 0;
        message.continuous = (0x4000000 & opFlags) != 0;
        message.keepAlive = (0x2000000 & opFlags) != 0;
        message.returnRequestDigest = (0x800000 & opFlags) != 0;
        message.overwriteWhenExists = (0x400000 & opFlags) != 0;
        message.mintNewSuffix = (0x200000 & opFlags) != 0;
        message.doNotRefer = (0x100000 & opFlags) != 0;
    }

    public static SiteInfo decodeSiteInfoRecord(byte[] data, int offset) throws HandleException {
        SiteInfo site = new SiteInfo();
        Encoder.decodeSiteInfoRecord(data, offset, site);
        return site;
    }

    public static void decodeSiteInfoRecord(byte[] data, int offset, SiteInfo site) throws HandleException {
        site.dataFormatVersion = Encoder.readInt2(data, offset);
        offset += 2;
        site.majorProtocolVersion = data[offset++];
        site.minorProtocolVersion = data[offset++];
        site.serialNumber = Encoder.readInt2(data, offset);
        site.isPrimary = (0x80 & data[offset += 2]) != 0;
        site.multiPrimary = (0x40 & data[offset++]) != 0;
        site.hashOption = data[offset++];
        site.hashFilter = Encoder.readByteArray(data, offset);
        int numAtts = Encoder.readInt(data, offset += 4 + site.hashFilter.length);
        if (numAtts < 0 || numAtts > 0x100000) {
            throw new HandleException(6, MSG_INVALID_ARRAY_SIZE);
        }
        site.attributes = new Attribute[numAtts];
        offset += 4;
        for (int i = 0; i < site.attributes.length; ++i) {
            site.attributes[i] = new Attribute();
            site.attributes[i].name = Encoder.readByteArray(data, offset);
            site.attributes[i].value = Encoder.readByteArray(data, offset += 4 + site.attributes[i].name.length);
            offset += 4 + site.attributes[i].value.length;
        }
        int numServers = Encoder.readInt(data, offset);
        if (numServers < 0 || numServers > 0x100000) {
            throw new HandleException(6, MSG_INVALID_ARRAY_SIZE);
        }
        site.servers = new ServerInfo[numServers];
        offset += 4;
        for (int i = 0; i < site.servers.length; ++i) {
            ServerInfo server;
            site.servers[i] = server = new ServerInfo();
            server.serverId = Encoder.readInt(data, offset);
            server.ipAddress = new byte[16];
            System.arraycopy(data, offset += 4, server.ipAddress, 0, 16);
            server.publicKey = Encoder.readByteArray(data, offset += 16);
            int numIntf = Encoder.readInt(data, offset += 4 + server.publicKey.length);
            if (numIntf < 0 || numIntf > 0x100000) {
                throw new HandleException(6, MSG_INVALID_ARRAY_SIZE);
            }
            server.interfaces = new Interface[numIntf];
            offset += 4;
            for (int j = 0; j < server.interfaces.length; ++j) {
                Interface intrfc;
                server.interfaces[j] = intrfc = new Interface();
                intrfc.type = data[offset++];
                intrfc.protocol = data[offset++];
                intrfc.port = Encoder.readInt(data, offset);
                offset += 4;
            }
        }
        if (offset < data.length) {
            throw new HandleException(6, "Unexpected data remaining after decoding");
        }
    }

    public static byte[] encodeSiteInfoRecord(SiteInfo site) {
        int sz = 0;
        sz += 2;
        sz += 2;
        sz += 2;
        ++sz;
        ++sz;
        sz += 4 + (site.hashFilter == null ? 0 : site.hashFilter.length);
        sz += 4;
        if (site.attributes != null) {
            for (Attribute attribute : site.attributes) {
                sz += 4 + attribute.name.length;
                sz += 4 + attribute.value.length;
            }
        }
        sz += 4;
        if (site.servers != null) {
            for (ServerInfo server : site.servers) {
                sz += 4;
                sz += 16;
                sz += 4 + (server.publicKey == null ? 0 : server.publicKey.length);
                sz += 4;
                if (server.interfaces == null) continue;
                sz += 6 * server.interfaces.length;
            }
        }
        byte[] buf = new byte[sz];
        int offset = 0;
        offset += Encoder.writeInt2(buf, offset, site.dataFormatVersion);
        buf[offset++] = site.majorProtocolVersion;
        buf[offset++] = site.minorProtocolVersion;
        offset += Encoder.writeInt2(buf, offset, site.serialNumber);
        buf[offset++] = (byte)((site.isPrimary ? 128 : 0) | (site.multiPrimary ? 64 : 0));
        buf[offset++] = site.hashOption;
        offset += Encoder.writeByteArray(buf, offset, site.hashFilter);
        if (site.attributes == null) {
            offset += Encoder.writeInt(buf, offset, 0);
        } else {
            offset += Encoder.writeInt(buf, offset, site.attributes.length);
            Attribute[] attributeArray = site.attributes;
            int n = attributeArray.length;
            for (int i = 0; i < n; ++i) {
                Attribute attribute = attributeArray[i];
                offset += Encoder.writeByteArray(buf, offset, attribute.name);
                offset += Encoder.writeByteArray(buf, offset, attribute.value);
            }
        }
        if (site.servers == null) {
            offset += Encoder.writeInt(buf, offset, 0);
        } else {
            offset += Encoder.writeInt(buf, offset, site.servers.length);
            for (ServerInfo server : site.servers) {
                offset += Encoder.writeInt(buf, offset, server.serverId);
                System.arraycopy(server.ipAddress, 0, buf, offset + 16 - server.ipAddress.length, server.ipAddress.length);
                offset += 16;
                offset += Encoder.writeByteArray(buf, offset, server.publicKey);
                if (server.interfaces == null) {
                    offset += Encoder.writeInt(buf, offset, 0);
                    continue;
                }
                offset += Encoder.writeInt(buf, offset, server.interfaces.length);
                for (Interface intrfc : server.interfaces) {
                    buf[offset++] = intrfc.type;
                    buf[offset++] = intrfc.protocol;
                    offset += Encoder.writeInt(buf, offset, intrfc.port);
                }
            }
        }
        return buf;
    }

    public static AdminRecord decodeAdminRecord(byte[] data, int offset) throws HandleException {
        AdminRecord res = new AdminRecord();
        Encoder.decodeAdminRecord(data, offset, res);
        return res;
    }

    public static void decodeAdminRecord(byte[] data, int offset, AdminRecord admin) throws HandleException {
        try {
            int permissions = Encoder.readInt2(data, offset);
            offset += 2;
            admin.perms[0] = (1 & permissions) != 0;
            admin.perms[1] = (2 & permissions) != 0;
            admin.perms[2] = (4 & permissions) != 0;
            admin.perms[3] = (8 & permissions) != 0;
            admin.perms[10] = (0x400 & permissions) != 0;
            admin.perms[4] = (0x10 & permissions) != 0;
            admin.perms[5] = (0x20 & permissions) != 0;
            admin.perms[6] = (0x40 & permissions) != 0;
            admin.perms[7] = (0x80 & permissions) != 0;
            admin.perms[8] = (0x100 & permissions) != 0;
            admin.perms[9] = (0x200 & permissions) != 0;
            admin.perms[11] = (0x800 & permissions) != 0;
            admin.adminId = Encoder.readByteArray(data, offset);
            admin.adminIdIndex = Encoder.readInt(data, offset += 4 + admin.adminId.length);
            admin.legacyByteLength = (offset += 4) + 2 == data.length;
        }
        catch (HandleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HandleException(6, "Error decoding admin record", e);
        }
        if (!admin.legacyByteLength && offset < data.length) {
            throw new HandleException(6, "Unexpected data remaining after decoding");
        }
    }

    public static byte[] encodeAdminRecord(AdminRecord admin) {
        int recordLen = (admin.legacyByteLength ? 4 : 2) + 4 + 4 + admin.adminId.length;
        byte[] buf = new byte[recordLen];
        int offset = 0;
        int permissions = 0;
        permissions |= admin.perms[0] ? 1 : 0;
        permissions |= admin.perms[1] ? 2 : 0;
        permissions |= admin.perms[2] ? 4 : 0;
        permissions |= admin.perms[3] ? 8 : 0;
        permissions |= admin.perms[10] ? 1024 : 0;
        permissions |= admin.perms[4] ? 16 : 0;
        permissions |= admin.perms[5] ? 32 : 0;
        permissions |= admin.perms[6] ? 64 : 0;
        permissions |= admin.perms[7] ? 128 : 0;
        permissions |= admin.perms[8] ? 256 : 0;
        permissions |= admin.perms[9] ? 512 : 0;
        offset += Encoder.writeInt2(buf, offset, permissions |= admin.perms[11] ? 2048 : 0);
        offset += Encoder.writeByteArray(buf, offset, admin.adminId);
        offset += Encoder.writeInt(buf, offset, admin.adminIdIndex);
        return buf;
    }

    public static byte[] encodeSecretKey(byte[] secretKey, boolean hash) throws Exception {
        if (hash) {
            secretKey = Util.doSHA1Digest(new byte[][]{secretKey});
            secretKey = Util.encodeString(Util.decodeHexString(secretKey, false).toLowerCase());
        }
        return secretKey;
    }

    public static int calculateAdminRecordSize(AdminRecord admin) {
        return 4 + admin.adminId.length + 4 + 4;
    }

    public static byte[] encodeGenericRequest(AbstractRequest req) {
        int bodyLen = req.handle.length + 4;
        byte[] msg = new byte[24 + bodyLen];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        Encoder.writeByteArray(msg, loc, req.handle);
        return msg;
    }

    public static GenericRequest decodeGenericRequest(byte[] msg, int offset, int opCode, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        offset += handle.length + 4;
        GenericRequest req = new GenericRequest(handle, opCode, null);
        switch (opCode) {
            case 300: 
            case 301: 
            case 1000: {
                req.isAdminRequest = true;
                break;
            }
            case 2: 
            case 401: 
            case 1003: {
                req.isAdminRequest = false;
                break;
            }
            default: {
                System.err.println("Warning: uncaught generic request in Encoder");
                req.isAdminRequest = false;
            }
        }
        return req;
    }

    public static byte[] encodeHandleValue(HandleValue value) {
        byte[] buf = new byte[Encoder.calcStorageSize(value)];
        Encoder.encodeHandleValue(buf, 0, value);
        return buf;
    }

    public static byte[][] encodeHandleValues(HandleValue[] values) {
        byte[][] res = new byte[values.length][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Encoder.encodeHandleValue(values[i]);
        }
        return res;
    }

    public static final int encodeHandleValue(byte[] buf, int offset, HandleValue value) {
        int origOffset = offset;
        Encoder.writeInt(buf, offset, value.index);
        Encoder.writeInt(buf, offset += 4, value.timestamp);
        offset += 4;
        buf[offset++] = value.ttlType;
        Encoder.writeInt(buf, offset, value.ttl);
        offset += 4;
        buf[offset++] = (byte)((value.adminRead ? 8 : 0) | (value.adminWrite ? 4 : 0) | (value.publicRead ? 2 : 0) | (value.publicWrite ? 1 : 0));
        offset += Encoder.writeByteArray(buf, offset, value.type, 0, value.type.length);
        offset += Encoder.writeByteArray(buf, offset, value.data, 0, value.data.length);
        if (value.references != null) {
            offset += Encoder.writeInt(buf, offset, value.references.length);
            for (ValueReference reference : value.references) {
                offset += Encoder.writeByteArray(buf, offset, reference.handle);
                offset += Encoder.writeInt(buf, offset, reference.index);
            }
        } else {
            offset += Encoder.writeInt(buf, offset, 0);
        }
        return offset - origOffset;
    }

    public static final byte[] getHandleValueType(byte[] buf, int offset) throws HandleException {
        return Encoder.readByteArray(buf, offset + 14);
    }

    public static final int getHandleValueIndex(byte[] buf, int offset) {
        return Encoder.readInt(buf, offset);
    }

    public static final byte getHandleValuePermissions(byte[] buf, int offset) {
        return buf[offset + 13];
    }

    public static final int calcStorageSize(HandleValue value) {
        int sz = 18 + value.type.length + 4 + value.data.length;
        sz += 4;
        if (value.references != null) {
            for (ValueReference reference : value.references) {
                sz += 4 + reference.handle.length + 4;
            }
        }
        return sz;
    }

    public static final int calcHandleValueSize(byte[] values, int offset) {
        int origOffset = offset;
        int fieldLen = Encoder.readInt(values, offset += 14);
        offset += 4 + fieldLen;
        fieldLen = Encoder.readInt(values, offset);
        offset += 4 + fieldLen;
        fieldLen = Encoder.readInt(values, offset);
        offset += 4;
        for (int i = 0; i < fieldLen; ++i) {
            int refLen = Encoder.readInt(values, offset);
            offset += 4 + refLen + 4;
        }
        return offset - origOffset;
    }

    public static HandleValue[] decodeHandleValues(byte[][] handleValues) throws HandleException {
        if (handleValues == null) {
            return null;
        }
        HandleValue value = null;
        HandleValue[] values = new HandleValue[handleValues.length];
        for (int i = 0; i < handleValues.length; ++i) {
            value = new HandleValue();
            Encoder.decodeHandleValue(handleValues[i], 0, value);
            values[i] = value;
        }
        return values;
    }

    @Deprecated
    public static HandleValue[] decodeHandleValue(byte[][] handleValues) throws HandleException {
        return Encoder.decodeHandleValues(handleValues);
    }

    public static final int decodeHandleValue(byte[] buf, int offset, HandleValue value) throws HandleException {
        byte permissions;
        int origOffset = offset;
        value.index = Encoder.readInt(buf, offset);
        value.timestamp = Encoder.readInt(buf, offset += 4);
        offset += 4;
        value.ttlType = buf[offset++];
        value.ttl = Encoder.readInt(buf, offset);
        offset += 4;
        value.adminRead = ((permissions = buf[offset++]) & 8) != 0;
        value.adminWrite = (permissions & 4) != 0;
        value.publicRead = (permissions & 2) != 0;
        value.publicWrite = (permissions & 1) != 0;
        value.type = Encoder.readByteArray(buf, offset);
        value.data = Encoder.readByteArray(buf, offset += 4 + value.type.length);
        value.references = new ValueReference[Encoder.readInt(buf, offset += 4 + value.data.length)];
        offset += 4;
        for (int i = 0; i < value.references.length; ++i) {
            value.references[i] = new ValueReference();
            value.references[i].handle = Encoder.readByteArray(buf, offset);
            value.references[i].index = Encoder.readInt(buf, offset += 4 + value.references[i].handle.length);
            offset += 4;
        }
        value.cachedBuf = buf;
        value.cachedBufOffset = origOffset;
        value.cachedBufLength = offset - origOffset;
        return offset - origOffset;
    }

    public static final byte[] encodeMessage(AbstractMessage msg) throws HandleException {
        byte[] buf = null;
        block0 : switch (msg.responseCode) {
            case 0: {
                switch (msg.opCode) {
                    case 1: {
                        buf = Encoder.encodeResolutionRequest((ResolutionRequest)msg);
                        break block0;
                    }
                    case 201: {
                        buf = Encoder.encodeVerifyAuthRequest((VerifyAuthRequest)msg);
                        break block0;
                    }
                    case 100: {
                        buf = Encoder.encodeCreateHandleRequest((CreateHandleRequest)msg);
                        break block0;
                    }
                    case 101: {
                        buf = Encoder.encodeDeleteHandleRequest((DeleteHandleRequest)msg);
                        break block0;
                    }
                    case 1001: {
                        buf = Encoder.encodeRetrieveTxnRequest((RetrieveTxnRequest)msg);
                        break block0;
                    }
                    case 1002: {
                        buf = Encoder.encodeDumpHandlesRequest((DumpHandlesRequest)msg);
                        break block0;
                    }
                    case 200: {
                        buf = Encoder.encodeChallengeAnswer((ChallengeAnswerRequest)msg);
                        break block0;
                    }
                    case 102: {
                        buf = Encoder.encodeAddValueRequest((AddValueRequest)msg);
                        break block0;
                    }
                    case 104: {
                        buf = Encoder.encodeModifyValueRequest((ModifyValueRequest)msg);
                        break block0;
                    }
                    case 103: {
                        buf = Encoder.encodeRemoveValueRequest((RemoveValueRequest)msg);
                        break block0;
                    }
                    case 105: {
                        buf = Encoder.encodeListHandlesRequest((ListHandlesRequest)msg);
                        break block0;
                    }
                    case 302: {
                        buf = Encoder.encodeListNAsRequest((ListNAsRequest)msg);
                        break block0;
                    }
                    case 400: {
                        buf = Encoder.encodeSessionSetupRequest((SessionSetupRequest)msg);
                        break block0;
                    }
                    case 402: {
                        buf = Encoder.encodeSessionExchangeKeyRequest((SessionExchangeKeyRequest)msg);
                        break block0;
                    }
                    case 2: 
                    case 300: 
                    case 301: 
                    case 401: 
                    case 1000: 
                    case 1003: {
                        buf = Encoder.encodeGenericRequest((AbstractRequest)msg);
                        break block0;
                    }
                }
                throw new HandleException(1, "Unknown opCode: " + msg.opCode);
            }
            case 1: {
                switch (msg.opCode) {
                    case 1: {
                        buf = Encoder.encodeResolutionResponse((ResolutionResponse)msg);
                        break block0;
                    }
                    case 201: {
                        buf = Encoder.encodeVerifyAuthResponse((VerifyAuthResponse)msg);
                        break block0;
                    }
                    case 1000: {
                        buf = Encoder.encodeNextTxnIdResponse((NextTxnIdResponse)msg);
                        break block0;
                    }
                    case 105: {
                        buf = Encoder.encodeListHandlesResponse((ListHandlesResponse)msg);
                        break block0;
                    }
                    case 302: {
                        buf = Encoder.encodeListNAsResponse((ListNAsResponse)msg);
                        break block0;
                    }
                    case 1001: {
                        buf = Encoder.encodeRetrieveTxnResponse((RetrieveTxnResponse)msg);
                        break block0;
                    }
                    case 1002: {
                        buf = Encoder.encodeDumpHandlesResponse((DumpHandlesResponse)msg);
                        break block0;
                    }
                    case 2: {
                        buf = Encoder.encodeGetSiteInfoResponse((GetSiteInfoResponse)msg);
                        break block0;
                    }
                    case 400: {
                        buf = Encoder.encodeSessionSetupResponse((SessionSetupResponse)msg);
                        break block0;
                    }
                    case 100: {
                        buf = Encoder.encodeCreateHandleResponse((CreateHandleResponse)msg);
                        break block0;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 300: 
                    case 301: 
                    case 401: 
                    case 402: 
                    case 1003: {
                        buf = Encoder.encodeGenericResponse(msg);
                        break block0;
                    }
                    case 200: {
                        throw new HandleException(1, "Invalid response message opCode " + msg.opCode);
                    }
                }
                throw new HandleException(1, "Unknown opCode: " + msg.opCode);
            }
            case 302: 
            case 303: {
                buf = Encoder.encodeServiceReferralResponse((ServiceReferralResponse)msg);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 100: 
            case 101: 
            case 102: 
            case 200: 
            case 201: 
            case 202: 
            case 300: 
            case 301: 
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                buf = Encoder.encodeErrorMessage((ErrorResponse)msg);
                break;
            }
            case 402: {
                buf = Encoder.encodeChallenge((ChallengeResponse)msg);
                break;
            }
            default: {
                throw new HandleException(1, "Unknown responseCode: " + msg.responseCode);
            }
        }
        if (buf == null) {
            throw new HandleException(1, "Encoder.encodeMessage() not implemented for type: " + msg.opCode);
        }
        return buf;
    }

    public static final void encodeEnvelope(MessageEnvelope msgEnv, byte[] udpPkt) {
        udpPkt[0] = msgEnv.protocolMajorVersion;
        udpPkt[1] = msgEnv.protocolMinorVersion;
        udpPkt[2] = (byte)((msgEnv.compressed ? -128 : 0) | (msgEnv.encrypted ? 64 : 0) | (msgEnv.truncated ? 32 : 0) | msgEnv.suggestMajorProtocolVersion);
        udpPkt[3] = msgEnv.suggestMinorProtocolVersion;
        Encoder.writeInt(udpPkt, 4, msgEnv.sessionId);
        Encoder.writeInt(udpPkt, 8, msgEnv.requestId);
        Encoder.writeInt(udpPkt, 12, msgEnv.messageId);
        Encoder.writeInt(udpPkt, 16, msgEnv.messageLength);
    }

    public static final void decodeEnvelope(byte[] udpPkt, MessageEnvelope msgEnv) throws HandleException {
        if (udpPkt == null || udpPkt.length < 20) {
            throw new HandleException(6, "Invalid message envelope");
        }
        msgEnv.protocolMajorVersion = udpPkt[0];
        msgEnv.protocolMinorVersion = udpPkt[1];
        msgEnv.compressed = (udpPkt[2] & 0xFFFFFF80) != 0;
        msgEnv.encrypted = (udpPkt[2] & 0x40) != 0;
        msgEnv.truncated = (udpPkt[2] & 0x20) != 0;
        msgEnv.suggestMajorProtocolVersion = (byte)(udpPkt[2] & 3);
        msgEnv.suggestMinorProtocolVersion = udpPkt[3];
        if (msgEnv.suggestMajorProtocolVersion == 0) {
            msgEnv.suggestMajorProtocolVersion = msgEnv.protocolMajorVersion;
            msgEnv.suggestMinorProtocolVersion = msgEnv.protocolMinorVersion;
        }
        msgEnv.sessionId = Encoder.readInt(udpPkt, 4);
        msgEnv.requestId = Encoder.readInt(udpPkt, 8);
        msgEnv.messageId = Encoder.readInt(udpPkt, 12);
        msgEnv.messageLength = Encoder.readInt(udpPkt, 16);
        if (msgEnv.messageLength > 262144 || msgEnv.messageLength < 0) {
            throw new HandleException(6, "Invalid message length: " + msgEnv.messageLength);
        }
    }

    static final byte[] encodeNextTxnIdResponse(NextTxnIdResponse res) {
        int bodyLen = 8 + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        byte[] msg = new byte[bodyLen + 24];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        offset += Encoder.writeLong(msg, offset, res.nextTxnId);
        return msg;
    }

    static final NextTxnIdResponse decodeNextTxnIdResponse(byte[] msg, int offset, MessageEnvelope env) {
        long nextTxnId = Encoder.readLong(msg, offset);
        return new NextTxnIdResponse(nextTxnId);
    }

    public static final AddValueRequest decodeAddValueRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        HandleValue[] values = new HandleValue[Encoder.readInt(msg, offset += 4 + handle.length)];
        offset += 4;
        for (int i = 0; i < values.length; ++i) {
            values[i] = new HandleValue();
            offset += Encoder.decodeHandleValue(msg, offset, values[i]);
        }
        return new AddValueRequest(handle, values, null);
    }

    public static final byte[] encodeAddValueRequest(AddValueRequest req) {
        int bodyLen = 4 + req.handle.length + 4;
        for (HandleValue value : req.values) {
            bodyLen += Encoder.calcStorageSize(value);
        }
        byte[] msg = new byte[bodyLen + 24];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        loc += Encoder.writeInt(msg, loc, req.values.length);
        for (HandleValue value : req.values) {
            loc += Encoder.encodeHandleValue(msg, loc, value);
        }
        return msg;
    }

    public static final ModifyValueRequest decodeModifyValueRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        int numValues = Encoder.readInt(msg, offset += 4 + handle.length);
        offset += 4;
        HandleValue[] values = new HandleValue[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = new HandleValue();
            offset += Encoder.decodeHandleValue(msg, offset, values[i]);
        }
        return new ModifyValueRequest(handle, values, null);
    }

    public static final byte[] encodeModifyValueRequest(ModifyValueRequest req) {
        int bodyLen = 4 + req.handle.length + 4;
        for (HandleValue value : req.values) {
            bodyLen += Encoder.calcStorageSize(value);
        }
        byte[] msg = new byte[bodyLen + 24];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        loc += Encoder.writeInt(msg, loc, req.values.length);
        for (HandleValue value : req.values) {
            loc += Encoder.encodeHandleValue(msg, loc, value);
        }
        return msg;
    }

    public static final RemoveValueRequest decodeRemoveValueRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        int[] indexes = Encoder.readIntArray(msg, offset += 4 + handle.length);
        offset += 4 + indexes.length * 4;
        return new RemoveValueRequest(handle, indexes, null);
    }

    public static final byte[] encodeRemoveValueRequest(RemoveValueRequest req) {
        int bodyLen = 4 + req.handle.length + 4 + req.indexes.length * 4;
        byte[] msg = new byte[bodyLen + 24];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        loc += Encoder.writeIntArray(msg, loc, req.indexes);
        return msg;
    }

    static final byte[] encodeVerifyAuthRequest(VerifyAuthRequest req) {
        int bodyLen = 8 + req.handle.length + 4 + req.nonce.length + 4 + req.origRequestDigest.length + 4 + req.signedResponse.length;
        byte[] msg = new byte[bodyLen + 24];
        int offset = 0;
        offset += Encoder.writeHeader(req, msg, bodyLen);
        offset += Encoder.writeByteArray(msg, offset, req.handle);
        offset += Encoder.writeInt(msg, offset, req.handleIndex);
        offset += Encoder.writeByteArray(msg, offset, req.nonce);
        offset += Encoder.writeByteArray(msg, offset, req.origRequestDigest);
        offset += Encoder.writeByteArray(msg, offset, req.signedResponse);
        return msg;
    }

    static final VerifyAuthRequest decodeVerifyAuthRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        int handleIndex = Encoder.readInt(msg, offset += 4 + handle.length);
        byte[] nonce = Encoder.readByteArray(msg, offset += 4);
        offset += 4 + nonce.length;
        byte[] requestDigest = null;
        byte digestAlg = msg[offset++];
        switch (digestAlg) {
            case 0: {
                requestDigest = Encoder.readByteArray(msg, --offset);
                offset += 4 + requestDigest.length;
                break;
            }
            case 1: {
                requestDigest = new byte[16];
                System.arraycopy(msg, offset, requestDigest, 0, 16);
                offset += 16;
                break;
            }
            case 2: {
                requestDigest = new byte[20];
                System.arraycopy(msg, offset, requestDigest, 0, 20);
                offset += 20;
                break;
            }
            case 3: {
                requestDigest = new byte[32];
                System.arraycopy(msg, offset, requestDigest, 0, 32);
                offset += 32;
                break;
            }
            default: {
                throw new HandleException(6, "Invalid hash type in message: " + digestAlg);
            }
        }
        byte[] signedResponse = Encoder.readByteArray(msg, offset);
        offset += 4 + signedResponse.length;
        return new VerifyAuthRequest(handle, nonce, requestDigest, digestAlg, signedResponse, handleIndex, null);
    }

    static final GetSiteInfoResponse decodeGetSiteInfoResponse(byte[] msg, int offset, int len, MessageEnvelope env) throws HandleException {
        byte[] b = new byte[len];
        System.arraycopy(msg, offset, b, 0, len);
        SiteInfo site = new SiteInfo();
        Encoder.decodeSiteInfoRecord(b, 0, site);
        return new GetSiteInfoResponse(site);
    }

    static final byte[] encodeGetSiteInfoResponse(GetSiteInfoResponse res) {
        byte[] siteBuf = Encoder.encodeSiteInfoRecord(res.siteInfo);
        int bodyLen = siteBuf.length + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        System.arraycopy(siteBuf, 0, msg, offset, siteBuf.length);
        return msg;
    }

    static final byte[] encodeVerifyAuthResponse(VerifyAuthResponse res) {
        int bodyLen = 1 + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        msg[offset++] = (byte)(res.isValid ? 1 : 0);
        return msg;
    }

    static final VerifyAuthResponse decodeVerifyAuthResponse(byte[] msg, int offset, MessageEnvelope env) {
        boolean isValid = (msg[offset] & 1) != 0;
        return new VerifyAuthResponse(isValid);
    }

    static final byte[] encodeRetrieveTxnRequest(RetrieveTxnRequest req) {
        if (req.hasEqualOrGreaterVersion(2, 9)) {
            if (req.replicationStateInfo != null) {
                Gson gson = GsonUtility.getGson();
                String replicationStateInfoJson = gson.toJson((Object)req.replicationStateInfo);
                byte[] replicationStateInfoJsonBytes = Util.encodeString(replicationStateInfoJson);
                int bodyLen = 5 + replicationStateInfoJsonBytes.length + 1 + 4 + 4;
                byte[] msg = new byte[24 + bodyLen];
                int offset = Encoder.writeHeader(req, msg, bodyLen);
                msg[offset++] = 1;
                offset += Encoder.writeByteArray(msg, offset, replicationStateInfoJsonBytes);
                msg[offset++] = req.rcvrHashType;
                offset += Encoder.writeInt(msg, offset, req.numServers);
                offset += Encoder.writeInt(msg, offset, req.serverNum);
                return msg;
            }
            int bodyLen = 26;
            byte[] msg = new byte[24 + bodyLen];
            int offset = Encoder.writeHeader(req, msg, bodyLen);
            msg[offset++] = 0;
            offset += Encoder.writeLong(msg, offset, req.lastTxnId);
            offset += Encoder.writeLong(msg, offset, req.lastQueryDate);
            msg[offset++] = req.rcvrHashType;
            offset += Encoder.writeInt(msg, offset, req.numServers);
            offset += Encoder.writeInt(msg, offset, req.serverNum);
            return msg;
        }
        int bodyLen = 25;
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(req, msg, bodyLen);
        offset += Encoder.writeLong(msg, offset, req.lastTxnId);
        offset += Encoder.writeLong(msg, offset, req.lastQueryDate);
        msg[offset++] = req.rcvrHashType;
        offset += Encoder.writeInt(msg, offset, req.numServers);
        offset += Encoder.writeInt(msg, offset, req.serverNum);
        return msg;
    }

    static final byte[] encodeRetrieveTxnResponse(RetrieveTxnResponse res) {
        int bodyLen = 1 + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        msg[offset] = 0;
        if (res.keepAlive) {
            int n = offset;
            msg[n] = (byte)(msg[n] | 1);
        }
        return msg;
    }

    static final RetrieveTxnResponse decodeRetrieveTxnResponse(byte[] msg, int loc, MessageEnvelope env) {
        RetrieveTxnResponse res = new RetrieveTxnResponse();
        res.keepAlive = (msg[loc] & 1) != 0;
        return res;
    }

    static final RetrieveTxnRequest decodeRetrieveTxnRequest(byte[] msg, int loc, MessageEnvelope env) throws HandleException {
        if (AbstractMessage.hasEqualOrGreaterVersion(env.protocolMajorVersion, env.protocolMinorVersion, 2, 9)) {
            byte isPullOtherTransactionsByte;
            if ((isPullOtherTransactionsByte = msg[loc++]) == 1) {
                return Encoder.decodeRetrieveTransactionRequestPullingAllSources(msg, loc);
            }
            return Encoder.decodeRetrieveTransactionRequestPullingOnlyOneSource(msg, loc);
        }
        return Encoder.decodeRetrieveTransactionRequestPullingOnlyOneSource(msg, loc);
    }

    private static RetrieveTxnRequest decodeRetrieveTransactionRequestPullingAllSources(byte[] msg, int loc) throws HandleException {
        byte[] replicationStateInfoJsonBytes = Encoder.readByteArray(msg, loc);
        loc += replicationStateInfoJsonBytes.length + 4;
        String replicationStateInfoJson = Util.decodeString(replicationStateInfoJsonBytes);
        ReplicationStateInfo replicationStateInfo = (ReplicationStateInfo)GsonUtility.getGson().fromJson(replicationStateInfoJson, ReplicationStateInfo.class);
        byte rcvrHashType = msg[loc++];
        int numServers = Encoder.readInt(msg, loc);
        int serverNum = Encoder.readInt(msg, loc += 4);
        loc += 4;
        return new RetrieveTxnRequest(replicationStateInfo, rcvrHashType, numServers, serverNum, null);
    }

    private static RetrieveTxnRequest decodeRetrieveTransactionRequestPullingOnlyOneSource(byte[] msg, int loc) {
        long lastTxnId = Encoder.readLong(msg, loc);
        long lastQueryDate = Encoder.readLong(msg, loc += 8);
        loc += 8;
        byte rcvrHashType = msg[loc++];
        int numServers = Encoder.readInt(msg, loc);
        int serverNum = Encoder.readInt(msg, loc += 4);
        loc += 4;
        return new RetrieveTxnRequest(lastTxnId, lastQueryDate, rcvrHashType, numServers, serverNum, null);
    }

    static final byte[] encodeDumpHandlesRequest(DumpHandlesRequest req) {
        int bodyLen = 9;
        if (req.startingPoint != null) {
            bodyLen += 4 + req.startingPoint.length + 4;
        }
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(req, msg, bodyLen);
        msg[offset++] = req.rcvrHashType;
        offset += Encoder.writeInt(msg, offset, req.numServers);
        offset += Encoder.writeInt(msg, offset, req.serverNum);
        if (req.startingPoint != null) {
            offset += Encoder.writeByteArray(msg, offset, req.startingPoint, 0, req.startingPoint.length);
            offset += Encoder.writeInt(msg, offset, req.startingPointType);
        }
        return msg;
    }

    static final byte[] encodeDumpHandlesResponse(DumpHandlesResponse res) {
        int bodyLen = res.returnRequestDigest ? 1 + res.requestDigest.length : 0;
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        return msg;
    }

    static final DumpHandlesResponse decodeDumpHandlesResponse(byte[] msg, int loc, MessageEnvelope env) {
        return new DumpHandlesResponse();
    }

    static final DumpHandlesRequest decodeDumpHandlesRequest(byte[] msg, int loc, MessageEnvelope env, int bodyLen) throws HandleException {
        int startOfBody = loc;
        byte rcvrHashType = msg[loc++];
        int numServers = Encoder.readInt(msg, loc);
        int serverNum = Encoder.readInt(msg, loc += 4);
        if ((loc += 4) == startOfBody + bodyLen) {
            return new DumpHandlesRequest(rcvrHashType, numServers, serverNum, null);
        }
        byte[] startingPoint = Encoder.readByteArray(msg, loc);
        int startingPointType = Encoder.readInt(msg, loc += 4 + startingPoint.length);
        loc += 4;
        return new DumpHandlesRequest(rcvrHashType, numServers, serverNum, null, startingPoint, startingPointType);
    }

    public static final DeleteHandleRequest decodeDeleteHandleRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        return new DeleteHandleRequest(handle, null);
    }

    public static final byte[] encodeDeleteHandleRequest(DeleteHandleRequest req) {
        int bodyLen = 4 + req.handle.length;
        byte[] msg = new byte[bodyLen + 24];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        return msg;
    }

    public static final GenericResponse decodeGenericResponse(byte[] msg, int loc, MessageEnvelope env) {
        return new GenericResponse();
    }

    public static final byte[] encodeGenericResponse(AbstractMessage res) {
        int bodyLen = res.returnRequestDigest ? res.requestDigest.length + 1 : 0;
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        return msg;
    }

    public static final CreateHandleRequest decodeCreateHandleRequest(byte[] msg, int offset, MessageEnvelope env, int opCode) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        HandleValue[] values = new HandleValue[Encoder.readInt(msg, offset += 4 + handle.length)];
        offset += 4;
        for (int i = 0; i < values.length; ++i) {
            values[i] = new HandleValue();
            offset += Encoder.decodeHandleValue(msg, offset, values[i]);
        }
        return new CreateHandleRequest(handle, values, null);
    }

    public static final byte[] encodeCreateHandleRequest(CreateHandleRequest req) {
        int bodyLen = 4 + req.handle.length + 4;
        for (HandleValue value : req.values) {
            bodyLen += Encoder.calcStorageSize(value);
        }
        byte[] msg = new byte[bodyLen + 24];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        loc += Encoder.writeInt(msg, loc, req.values.length);
        for (HandleValue value : req.values) {
            loc += Encoder.encodeHandleValue(msg, loc, value);
        }
        return msg;
    }

    static ListHandlesRequest decodeListHandlesRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] naHandle = Encoder.readByteArray(msg, offset);
        offset += naHandle.length + 4;
        return new ListHandlesRequest(naHandle, null);
    }

    static ListNAsRequest decodeListNAsRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] naHandle = Encoder.readByteArray(msg, offset);
        offset += naHandle.length + 4;
        return new ListNAsRequest(naHandle, null);
    }

    static ListHandlesResponse decodeListHandlesResponse(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        int numHandles = Encoder.readInt(msg, offset);
        offset += 4;
        byte[][] handles = new byte[numHandles][];
        for (int i = 0; i < numHandles; ++i) {
            handles[i] = Encoder.readByteArray(msg, offset);
            offset += 4 + handles[i].length;
        }
        ListHandlesResponse response = new ListHandlesResponse();
        response.handles = handles;
        return response;
    }

    static ListNAsResponse decodeListNAsResponse(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        int numHandles = Encoder.readInt(msg, offset);
        offset += 4;
        byte[][] handles = new byte[numHandles][];
        for (int i = 0; i < numHandles; ++i) {
            handles[i] = Encoder.readByteArray(msg, offset);
            offset += 4 + handles[i].length;
        }
        ListNAsResponse response = new ListNAsResponse();
        response.handles = handles;
        return response;
    }

    static final byte[] encodeListHandlesRequest(ListHandlesRequest req) {
        int bodyLen = 4 + req.handle.length;
        byte[] msg = new byte[bodyLen + 24];
        Encoder.writeHeader(req, msg, bodyLen);
        int loc = 24;
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        return msg;
    }

    static final byte[] encodeListNAsRequest(ListNAsRequest req) {
        int bodyLen = 4 + req.handle.length;
        byte[] msg = new byte[bodyLen + 24];
        Encoder.writeHeader(req, msg, bodyLen);
        int loc = 24;
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        return msg;
    }

    static final byte[] encodeListHandlesResponse(ListHandlesResponse res) {
        int bodyLen = 4 + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        for (byte[] handle : res.handles) {
            bodyLen += handle.length + 4;
        }
        byte[] msg = new byte[bodyLen + 24];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        offset += Encoder.writeInt(msg, offset, res.handles.length);
        for (byte[] handle : res.handles) {
            offset += Encoder.writeByteArray(msg, offset, handle);
        }
        return msg;
    }

    static final byte[] encodeListNAsResponse(ListNAsResponse res) {
        int bodyLen = 4 + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        for (byte[] handle : res.handles) {
            bodyLen += handle.length + 4;
        }
        byte[] msg = new byte[bodyLen + 24];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        offset += Encoder.writeInt(msg, offset, res.handles.length);
        for (byte[] handle : res.handles) {
            offset += Encoder.writeByteArray(msg, offset, handle);
        }
        return msg;
    }

    public static ResolutionRequest decodeResolutionRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] handle = Encoder.readByteArray(msg, offset);
        int[] indexes = Encoder.readIntArray(msg, offset += handle.length + 4);
        byte[][] types = new byte[Encoder.readInt(msg, offset += 4 + 4 * indexes.length)][];
        offset += 4;
        offset += Encoder.readByteArrayArray(types, msg, offset);
        return new ResolutionRequest(handle, types, indexes, null);
    }

    public static ResolutionResponse decodeResolutionResponse(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        int handleLen = Encoder.readInt(msg, offset);
        offset += 4;
        if (handleLen < 0 || handleLen > 2048) {
            throw new HandleException(6, "Invalid handle length: " + handleLen);
        }
        byte[] handle = new byte[handleLen];
        System.arraycopy(msg, offset, handle, 0, handleLen);
        int numValues = Encoder.readInt(msg, offset += handleLen);
        offset += 4;
        if (numValues < 0 || numValues > 2048) {
            throw new HandleException(6, "Invalid number of values: " + numValues);
        }
        byte[][] values = new byte[numValues][];
        for (int i = 0; i < numValues; ++i) {
            int valLen = Encoder.calcHandleValueSize(msg, offset);
            values[i] = new byte[valLen];
            System.arraycopy(msg, offset, values[i], 0, valLen);
            offset += valLen;
        }
        return new ResolutionResponse(handle, values);
    }

    public static ServiceReferralResponse decodeServiceReferralResponse(int responseCode, byte[] msg, int offset, MessageEnvelope env, int endOfBuf) throws HandleException {
        int handleLen = Encoder.readInt(msg, offset);
        offset += 4;
        if (handleLen < 0 || handleLen > 2048) {
            throw new HandleException(6, "Invalid handle length: " + handleLen);
        }
        byte[] handle = new byte[handleLen];
        System.arraycopy(msg, offset, handle, 0, handleLen);
        byte[][] values = null;
        if ((offset += handleLen) < endOfBuf) {
            int numValues = Encoder.readInt(msg, offset);
            offset += 4;
            if (numValues < 0 || numValues > 2048) {
                throw new HandleException(6, "Invalid number of values: " + numValues);
            }
            values = new byte[numValues][];
            for (int i = 0; i < numValues; ++i) {
                int valLen = Encoder.calcHandleValueSize(msg, offset);
                values[i] = new byte[valLen];
                System.arraycopy(msg, offset, values[i], 0, valLen);
                offset += valLen;
            }
        }
        return new ServiceReferralResponse(responseCode, handle, values);
    }

    public static final byte[] encodeResolutionRequest(ResolutionRequest req) {
        int bodyLen = 4 + req.handle.length + 4 + (req.requestedIndexes == null ? 0 : req.requestedIndexes.length * 4) + 4;
        if (req.requestedTypes != null) {
            for (byte[] requestedType : req.requestedTypes) {
                bodyLen += requestedType.length + 4;
            }
        }
        byte[] msg = new byte[bodyLen + 24];
        Encoder.writeHeader(req, msg, bodyLen);
        int loc = 24;
        loc += Encoder.writeByteArray(msg, loc, req.handle, 0, req.handle.length);
        loc += Encoder.writeIntArray(msg, loc, req.requestedIndexes);
        loc += Encoder.writeByteArrayArray(msg, loc, req.requestedTypes);
        return msg;
    }

    public static final byte[] encodeResolutionResponse(ResolutionResponse res) {
        int bodyLen = 4 + res.handle.length + 4 + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        for (byte[] value : res.values) {
            bodyLen += value.length;
        }
        byte[] msg = new byte[bodyLen + 24];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        offset += Encoder.writeByteArray(msg, offset, res.handle, 0, res.handle.length);
        offset += Encoder.writeInt(msg, offset, res.values.length);
        for (byte[] value : res.values) {
            System.arraycopy(value, 0, msg, offset, value.length);
            offset += value.length;
        }
        return msg;
    }

    public static final byte[] encodeServiceReferralResponse(ServiceReferralResponse res) {
        int bodyLen = 4 + res.handle.length + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0);
        if (res.values != null) {
            bodyLen += 4;
            for (byte[] value : res.values) {
                bodyLen += value.length;
            }
        }
        byte[] msg = new byte[bodyLen + 24];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        offset += Encoder.writeByteArray(msg, offset, res.handle, 0, res.handle.length);
        if (res.values != null) {
            offset += Encoder.writeInt(msg, offset, res.values.length);
            for (byte[] value : res.values) {
                System.arraycopy(value, 0, msg, offset, value.length);
                offset += value.length;
            }
        }
        return msg;
    }

    static final ChallengeResponse decodeChallenge(byte[] msg, int offset, int opCode, MessageEnvelope env) throws HandleException {
        byte[] nonce = null;
        if (env.protocolMajorVersion == 5 && env.protocolMinorVersion == 0 || env.protocolMajorVersion == 2 && env.protocolMinorVersion == 0) {
            nonce = Encoder.readByteArray(msg, offset);
            ChallengeResponse cr = new ChallengeResponse(opCode, nonce);
            cr.rdHashType = 0;
            cr.requestDigest = Encoder.readByteArray(msg, offset += 4 + nonce.length);
            offset += 4 + cr.requestDigest.length;
            return cr;
        }
        nonce = Encoder.readByteArray(msg, offset);
        offset += 4 + nonce.length;
        return new ChallengeResponse(opCode, nonce);
    }

    static final ChallengeAnswerRequest decodeChallengeAnswer(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        byte[] authType = Encoder.readByteArray(msg, offset);
        byte[] userIdHandle = Encoder.readByteArray(msg, offset += 4 + authType.length);
        int userIdIndex = Encoder.readInt(msg, offset += 4 + userIdHandle.length);
        byte[] signedResponse = Encoder.readByteArray(msg, offset += 4);
        return new ChallengeAnswerRequest(authType, userIdHandle, userIdIndex, signedResponse, null);
    }

    public static final ValueReference[] decodeValueReferenceList(byte[] buf, int offset) throws HandleException {
        int numValues = Encoder.readInt(buf, offset);
        offset += 4;
        if (numValues < 0 || numValues > 0x100000) {
            throw new HandleException(6, MSG_INVALID_ARRAY_SIZE);
        }
        ValueReference[] values = new ValueReference[numValues];
        for (int i = 0; i < numValues; ++i) {
            values[i] = new ValueReference();
            values[i].handle = Encoder.readByteArray(buf, offset);
            values[i].index = Encoder.readInt(buf, offset += 4 + values[i].handle.length);
            offset += 4;
        }
        if (offset < buf.length) {
            throw new HandleException(6, "Unexpected data remaining after decoding");
        }
        return values;
    }

    public static final byte[] encodeValueReferenceList(ValueReference[] values) {
        int sz = 4;
        if (values != null) {
            for (ValueReference value : values) {
                sz += 4;
                sz += 4;
                sz += value.handle.length;
            }
        }
        byte[] buf = new byte[sz];
        int offset = 0;
        offset += Encoder.writeInt(buf, offset, values == null ? 0 : values.length);
        if (values != null) {
            for (ValueReference value : values) {
                offset += Encoder.writeByteArray(buf, offset, value.handle);
                offset += Encoder.writeInt(buf, offset, value.index);
            }
        }
        return buf;
    }

    static final byte[] encodeChallengeAnswer(ChallengeAnswerRequest req) {
        byte[] msg = new byte[28 + req.authType.length + 4 + req.userIdHandle.length + 4 + 4 + req.signedResponse.length];
        int offset = Encoder.writeHeader(req, msg, msg.length - 24);
        offset += Encoder.writeByteArray(msg, offset, req.authType, 0, req.authType.length);
        offset += Encoder.writeByteArray(msg, offset, req.userIdHandle, 0, req.userIdHandle.length);
        offset += Encoder.writeInt(msg, offset, req.userIdIndex);
        offset += Encoder.writeByteArray(msg, offset, req.signedResponse, 0, req.signedResponse.length);
        return msg;
    }

    static final byte[] encodeChallenge(ChallengeResponse res) {
        byte[] msg;
        if (!res.hasEqualOrGreaterVersion(2, 1)) {
            msg = new byte[28 + res.nonce.length + 4 + res.requestDigest.length];
            int offset = Encoder.writeHeader(res, msg, msg.length - 24);
            offset += Encoder.writeByteArray(msg, offset, res.nonce, 0, res.nonce.length);
            offset += Encoder.writeByteArray(msg, offset, res.requestDigest, 0, res.requestDigest.length);
        } else {
            msg = new byte[28 + res.nonce.length + (res.returnRequestDigest ? 1 + res.requestDigest.length : 0)];
            int offset = Encoder.writeHeader(res, msg, msg.length - 24);
            if (res.returnRequestDigest) {
                msg[offset++] = res.rdHashType;
                System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
                offset += res.requestDigest.length;
            }
            int n = offset + Encoder.writeByteArray(msg, offset, res.nonce, 0, res.nonce.length);
        }
        return msg;
    }

    static final byte[] encodeErrorMessage(ErrorResponse res) {
        int bodyLen = 4;
        if (res.message != null) {
            bodyLen += res.message.length;
        }
        if (res.returnRequestDigest) {
            bodyLen += 1 + res.requestDigest.length;
        }
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        if (res.message != null) {
            offset += Encoder.writeInt(msg, offset, res.message.length);
            System.arraycopy(res.message, 0, msg, offset, res.message.length);
        } else {
            offset += Encoder.writeInt(msg, offset, 0);
        }
        return msg;
    }

    static final AbstractResponse decodeErrorMessage(byte[] msg, int loc, MessageEnvelope env, int endOfBuf) throws HandleException {
        if (env.protocolMajorVersion == 5 || env.protocolMajorVersion == 2 && env.protocolMinorVersion == 0) {
            if (loc + 4 < endOfBuf) {
                return new ErrorResponse(Encoder.readByteArray(msg, loc));
            }
            return new ErrorResponse(new byte[0]);
        }
        return new ErrorResponse(Encoder.readByteArray(msg, loc));
    }

    static final int writeHeader(AbstractMessage msg, byte[] buf, int bodyLen) {
        int loc = 0;
        loc += Encoder.writeInt(buf, loc, msg.opCode);
        loc = msg.responseCode == 7 && !msg.hasEqualOrGreaterVersion(2, 5) ? (loc += Encoder.writeInt(buf, loc, 303)) : (msg.responseCode == 202 && !msg.hasEqualOrGreaterVersion(2, 5) ? (loc += Encoder.writeInt(buf, loc, 201)) : (loc += Encoder.writeInt(buf, loc, msg.responseCode)));
        int flags = 0;
        if (msg.authoritative) {
            flags |= Integer.MIN_VALUE;
        }
        if (msg.certify) {
            flags |= 0x40000000;
        }
        if (msg.encrypt) {
            flags |= 0x20000000;
        }
        if (msg.recursive) {
            flags |= 0x10000000;
        }
        if (msg.cacheCertify) {
            flags |= 0x8000000;
        }
        if (msg.continuous) {
            flags |= 0x4000000;
        }
        if (msg.keepAlive) {
            flags |= 0x2000000;
        }
        if (msg.ignoreRestrictedValues) {
            flags |= 0x1000000;
        }
        if (msg.hasEqualOrGreaterVersion(2, 1) && msg.returnRequestDigest) {
            flags |= 0x800000;
        }
        if (msg.overwriteWhenExists) {
            flags |= 0x400000;
        }
        if (msg.mintNewSuffix) {
            flags |= 0x200000;
        }
        if (msg.doNotRefer) {
            flags |= 0x100000;
        }
        loc += Encoder.writeInt(buf, loc, flags);
        loc += Encoder.writeInt2(buf, loc, msg.siteInfoSerial);
        buf[loc++] = (byte)msg.recursionCount;
        ++loc;
        loc += Encoder.writeInt(buf, loc, msg.expiration);
        loc += Encoder.writeInt(buf, loc, bodyLen);
        return 24;
    }

    public static final byte[] encodeGlobalValues(HandleValue[] values) {
        int dataLen = 8;
        for (HandleValue value : values) {
            dataLen += Encoder.calcStorageSize(value);
        }
        byte[] buf = new byte[dataLen];
        int offset = 0;
        offset += Encoder.writeInt(buf, offset, dataLen - 4);
        offset += Encoder.writeInt(buf, offset, values.length);
        for (HandleValue value : values) {
            offset += Encoder.encodeHandleValue(buf, offset, value);
        }
        return buf;
    }

    public static final byte[] encodeLocalSites(SiteInfo[] sites, String[][] na) throws HandleException {
        if (sites.length != na.length) {
            throw new HandleException(1, "Local site values must have matching NAs");
        }
        byte[] intbuf = new byte[4];
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            b.write(intbuf);
            Encoder.writeInt(intbuf, 0, sites.length);
            b.write(intbuf);
            for (int i = 0; i < sites.length; ++i) {
                Encoder.writeInt(intbuf, 0, na[i].length);
                b.write(intbuf);
                for (int j = 0; j < na[i].length; ++j) {
                    Encoder.writeInt(intbuf, 0, na[i][j].length());
                    b.write(intbuf);
                    b.write(Util.encodeString(na[i][j]));
                }
                byte[] bsite = Encoder.encodeSiteInfoRecord(sites[i]);
                Encoder.writeInt(intbuf, 0, bsite.length);
                b.write(intbuf);
                b.write(bsite);
            }
            byte[] buf = b.toByteArray();
            Encoder.writeInt(buf, 0, buf.length);
            return buf;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HandleException(1, "Error writing local site information");
        }
    }

    public static final Map<String, SiteInfo[]> decodeLocalSites(InputStream in) throws HandleException {
        try {
            byte[] intbuf = new byte[4];
            Util.readFully(in, intbuf);
            Util.readFully(in, intbuf);
            int numSites = Encoder.readInt(intbuf, 0);
            HashMap<String, SiteInfo[]> table = new HashMap<String, SiteInfo[]>();
            for (int i = 0; i < numSites; ++i) {
                Util.readFully(in, intbuf);
                int numNAs = Encoder.readInt(intbuf, 0);
                String[] na = new String[numNAs];
                for (int j = 0; j < numNAs; ++j) {
                    Util.readFully(in, intbuf);
                    int len = Encoder.readInt(intbuf, 0);
                    byte[] buf = new byte[len];
                    Util.readFully(in, buf);
                    na[j] = Util.decodeString(buf);
                }
                Util.readFully(in, intbuf);
                int len = Encoder.readInt(intbuf, 0);
                byte[] b = new byte[len];
                Util.readFully(in, b);
                SiteInfo site = new SiteInfo();
                Encoder.decodeSiteInfoRecord(b, 0, site);
                for (int j = 0; j < numNAs; ++j) {
                    SiteInfo[] sites = table.get(na[j]);
                    if (sites == null) {
                        sites = new SiteInfo[1];
                    } else {
                        SiteInfo[] newsites = new SiteInfo[sites.length + 1];
                        System.arraycopy(sites, 0, newsites, 1, sites.length);
                        sites = newsites;
                    }
                    sites[0] = site;
                    table.put(na[j], sites);
                }
            }
            return table;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HandleException(1, "Error reading local site information");
        }
    }

    public static final Map<String, String> decodeLocalAddresses(InputStream in) throws HandleException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(in, "ASCII"));
            while ((line = rdr.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String fromAddr = "";
                String toAddr = "";
                try (Scanner scanner = new Scanner(line);){
                    if (scanner.hasNext()) {
                        fromAddr = scanner.next().trim().toLowerCase();
                    }
                    if (scanner.hasNext()) {
                        toAddr = scanner.next().trim().toLowerCase();
                    }
                }
                if (fromAddr.length() <= 0 || toAddr.length() <= 0) continue;
                map.put(fromAddr, toAddr);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HandleException(1, "Error reading local site information");
        }
        return map;
    }

    public static final void writeLocalAddresses(Map<?, ?> map, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, "ASCII");
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (key == null || val == null) continue;
            if (key instanceof InetAddress) {
                key = Util.rfcIpRepr((InetAddress)key);
            }
            if (val instanceof InetAddress) {
                val = Util.rfcIpRepr((InetAddress)val);
            }
            w.write(String.valueOf(key));
            w.write(9);
            w.write(String.valueOf(val));
            w.write(10);
        }
        w.close();
    }

    public static final HandleValue[] decodeGlobalValues(InputStream in) throws HandleException {
        try {
            int r;
            byte[] buf = new byte[4];
            Util.readFully(in, buf);
            int dataLen = Encoder.readInt(buf, 0);
            buf = new byte[dataLen];
            for (int n = 0; (r = in.read(buf, n, dataLen - n)) > 0 && n < dataLen; n += r) {
            }
            int offset = 0;
            int numValues = Encoder.readInt(buf, offset);
            offset += 4;
            if (numValues < 0) {
                throw new Exception("Invalid number of handle values");
            }
            HandleValue[] values = new HandleValue[numValues];
            for (int i = 0; i < numValues; ++i) {
                values[i] = new HandleValue();
                offset += Encoder.decodeHandleValue(buf, offset, values[i]);
            }
            return values;
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(1, "Error parsing global info", e);
        }
    }

    public static final HandleValue[] decodeHandleValues(byte[] buf) throws HandleException {
        try {
            int offset = 0;
            int numValues = Encoder.readInt(buf, offset += 4);
            offset += 4;
            if (numValues < 0) {
                throw new Exception("Invalid number of handle values");
            }
            HandleValue[] values = new HandleValue[numValues];
            for (int i = 0; i < numValues; ++i) {
                values[i] = new HandleValue();
                offset += Encoder.decodeHandleValue(buf, offset, values[i]);
            }
            return values;
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(1, "Error parsing global info: " + e);
        }
    }

    static final SessionSetupRequest decodeSessionSetupRequest(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        try {
            SessionSetupRequest req = new SessionSetupRequest();
            req.keyExchangeMode = Encoder.readInt2(msg, offset);
            req.timeout = Encoder.readInt(msg, offset += 2);
            req.identityHandle = Encoder.readByteArray(msg, offset += 4);
            req.identityIndex = Encoder.readInt(msg, offset += 4 + req.identityHandle.length);
            offset += 4;
            if (req.keyExchangeMode == 1 || req.keyExchangeMode == 4) {
                req.publicKey = Encoder.readByteArray(msg, offset);
                offset += 4 + req.publicKey.length;
            } else if (req.keyExchangeMode == 3) {
                req.exchangeKeyHandle = Encoder.readByteArray(msg, offset);
                req.exchangeKeyIndex = Encoder.readInt(msg, offset += 4 + req.exchangeKeyHandle.length);
                offset += 4;
            }
            return req;
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(1, "Can not decode session setup request: " + e);
        }
    }

    static final byte[] encodeSessionSetupRequest(SessionSetupRequest req) throws HandleException {
        int bodyLen = 4;
        bodyLen += 4;
        bodyLen += 4;
        if (req.identityHandle != null) {
            bodyLen += req.identityHandle.length;
        }
        bodyLen += 4;
        try {
            if (req.keyExchangeMode == 1 || req.keyExchangeMode == 4) {
                if (req.publicKey == null) {
                    throw new HandleException(1, "Session setup request missing exchange key");
                }
                bodyLen += 4;
                bodyLen += req.publicKey.length;
            } else if (req.keyExchangeMode == 3) {
                if (req.exchangeKeyHandle == null) {
                    throw new HandleException(1, "Session setup request missing key exchange handle");
                }
                bodyLen += 4;
                bodyLen += req.exchangeKeyHandle.length;
                bodyLen += 4;
            } else if (req.keyExchangeMode != 2) {
                throw new HandleException(1, "Unknown key exchange mode: " + req.keyExchangeMode);
            }
            byte[] msg = new byte[bodyLen + 24];
            int offset = Encoder.writeHeader(req, msg, bodyLen);
            offset += Encoder.writeInt2(msg, offset, req.keyExchangeMode);
            offset += Encoder.writeInt(msg, offset, req.timeout);
            offset += Encoder.writeByteArray(msg, offset, req.identityHandle);
            offset += Encoder.writeInt(msg, offset, req.identityIndex);
            if (req.keyExchangeMode == 1 || req.keyExchangeMode == 4) {
                offset += Encoder.writeByteArray(msg, offset, req.publicKey);
            } else if (req.keyExchangeMode == 3) {
                offset += Encoder.writeByteArray(msg, offset, req.exchangeKeyHandle);
                offset += Encoder.writeInt(msg, offset, req.exchangeKeyIndex);
            }
            return msg;
        }
        catch (HandleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HandleException(1, "Error encoding session setup request: " + e.getMessage());
        }
    }

    static final byte[] encodeSessionExchangeKeyRequest(SessionExchangeKeyRequest req) {
        byte[] encryptedSessionKey = req.getEncryptedSessionKey();
        int bodyLen = 0;
        if (encryptedSessionKey != null) {
            bodyLen = 4 + encryptedSessionKey.length;
        }
        byte[] msg = new byte[bodyLen + 24];
        int loc = Encoder.writeHeader(req, msg, bodyLen);
        if (encryptedSessionKey != null) {
            loc += Encoder.writeByteArray(msg, loc, encryptedSessionKey, 0, encryptedSessionKey.length);
        }
        return msg;
    }

    static SessionExchangeKeyRequest decodeSessionExchangeKeyRequest(byte[] msg, int offset, MessageEnvelope env) {
        int sessionKeyLen = Encoder.readInt(msg, offset);
        byte[] encryptedSessionKey = new byte[sessionKeyLen];
        System.arraycopy(msg, offset += 4, encryptedSessionKey, 0, sessionKeyLen);
        return new SessionExchangeKeyRequest(encryptedSessionKey);
    }

    static final byte[] encodeSessionSetupResponse(SessionSetupResponse res) {
        int bodyLen = 4;
        bodyLen += 4 + res.data.length;
        byte[] msg = new byte[(bodyLen += res.returnRequestDigest ? 1 + res.requestDigest.length : 0) + 24];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        offset += Encoder.writeInt2(msg, offset, res.keyExchangeMode);
        offset += Encoder.writeByteArray(msg, offset, res.data, 0, res.data.length);
        return msg;
    }

    static SessionSetupResponse decodeSetupSessionResponse(byte[] msg, int offset, MessageEnvelope env) throws HandleException {
        int mode = Encoder.readInt2(msg, offset);
        byte[] data = Encoder.readByteArray(msg, offset += 2);
        offset += 4 + data.length;
        return new SessionSetupResponse(mode, data);
    }

    static AbstractResponse decodeCreateHandleResponse(byte[] msg, int offset, MessageEnvelope env, int bodyLength) throws HandleException {
        if (bodyLength == 0) {
            return new CreateHandleResponse(null);
        }
        int handleLen = Encoder.readInt(msg, offset);
        offset += 4;
        if (handleLen < 0 || handleLen > 2048) {
            throw new HandleException(6, "Invalid handle length: " + handleLen);
        }
        byte[] handle = new byte[handleLen];
        System.arraycopy(msg, offset, handle, 0, handleLen);
        offset += handleLen;
        return new CreateHandleResponse(handle);
    }

    public static final byte[] encodeCreateHandleResponse(CreateHandleResponse res) {
        int bodyLen;
        int n = bodyLen = res.returnRequestDigest ? res.requestDigest.length + 1 : 0;
        if (res.handle != null) {
            bodyLen += 4 + res.handle.length;
        }
        byte[] msg = new byte[24 + bodyLen];
        int offset = Encoder.writeHeader(res, msg, bodyLen);
        if (res.returnRequestDigest) {
            msg[offset++] = res.rdHashType;
            System.arraycopy(res.requestDigest, 0, msg, offset, res.requestDigest.length);
            offset += res.requestDigest.length;
        }
        if (res.handle != null) {
            offset += Encoder.writeByteArray(msg, offset, res.handle, 0, res.handle.length);
        }
        return msg;
    }

    public static class MessageHeaders {
        public int opCode;
        public int responseCode;
        public int opFlags;
        public int serialNum;
        public short recursionCount;
        public int expiration;
        public int bodyLen;
        public int bodyOffset;

        public MessageHeaders(byte[] msg, int offset) {
            int loc = offset;
            this.opCode = Encoder.readInt(msg, loc);
            this.responseCode = Encoder.readInt(msg, loc += 4);
            this.opFlags = Encoder.readInt(msg, loc += 4);
            this.serialNum = Encoder.readInt2(msg, loc += 4);
            loc += 2;
            this.recursionCount = msg[loc++];
            this.expiration = Encoder.readInt(msg, ++loc);
            this.bodyLen = Encoder.readInt(msg, loc += 4);
            this.bodyOffset = loc += 4;
        }
    }
}

