/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.IOException;
import java.net.InetAddress;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.BootstrapHandles;
import net.handle.hdllib.Common;
import net.handle.hdllib.FilesystemConfiguration;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.RootInfoListener;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.trust.ChainBuilder;
import net.handle.hdllib.trust.ChainVerifier;
import net.handle.hdllib.trust.HandleRecordTrustVerifier;

public abstract class Configuration {
    public static final int RM_GLOBAL = 0;
    public static final int RM_WITH_CACHE = 1;
    private static Configuration defaultConfig = null;
    private volatile boolean startedAutoUpdate;
    private final Object synchronizeUpdateLock = new Object();
    private volatile boolean updatingRootInfo = false;
    private Vector<RootInfoListener> rootInfoNotifications = null;
    private final Object synchronizeRootInfoNotifications = new Object();

    public static final synchronized Configuration defaultConfiguration() {
        if (defaultConfig == null) {
            defaultConfig = new FilesystemConfiguration();
        }
        return defaultConfig;
    }

    public void setResolutionMethod(int resolutionMethod) {
        throw new UnsupportedOperationException();
    }

    public int getResolutionMethod() {
        return 0;
    }

    public SiteInfo[] getCacheSites() {
        return null;
    }

    public void setCacheSites(SiteInfo[] cacheSites) {
        throw new UnsupportedOperationException();
    }

    public abstract SiteInfo[] getGlobalSites();

    public abstract void setGlobalSites(SiteInfo[] var1);

    public abstract NamespaceInfo getGlobalNamespace();

    public abstract HandleValue[] getGlobalValues();

    @Deprecated
    public abstract void setGlobalValues(HandleValue[] var1);

    public abstract List<PublicKey> getRootKeys();

    public abstract void setRootKeys(List<PublicKey> var1);

    public abstract BootstrapHandles getBootstrapHandles();

    public abstract void setBootstrapHandles(BootstrapHandles var1);

    public abstract void persist();

    public SiteInfo[] getLocalSites(byte[] na) {
        return this.getLocalSites(Util.decodeString(na));
    }

    public SiteInfo[] getLocalSites(String na) {
        return null;
    }

    public InetAddress mapLocalAddress(InetAddress addr) {
        return addr;
    }

    public Map<String, String> getLocalAddressMap() {
        return null;
    }

    public void saveLocalAddressMap() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLocalAddressMap(Map<String, String> localAddrMap) {
        throw new UnsupportedOperationException();
    }

    public void setLocalSites(byte[] na, SiteInfo[] sites) {
        this.setLocalSites(Util.decodeString(na), sites);
    }

    public void setLocalSites(String na, SiteInfo[] sites) {
        throw new UnsupportedOperationException();
    }

    public String getPreferredGlobalServiceHandle() {
        return null;
    }

    public void configureResolver(HandleResolver resolver) {
    }

    public abstract boolean isAutoUpdateRootInfo();

    public abstract void setAutoUpdateRootInfo(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootInfoListener(RootInfoListener listener) {
        Object object = this.synchronizeRootInfoNotifications;
        synchronized (object) {
            if (this.rootInfoNotifications == null) {
                this.rootInfoNotifications = new Vector();
            }
            this.rootInfoNotifications.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootInfoListener(RootInfoListener listener) {
        Object object = this.synchronizeRootInfoNotifications;
        synchronized (object) {
            if (this.rootInfoNotifications == null) {
                return;
            }
            this.rootInfoNotifications.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRootInfoOutdated(final HandleResolver resolver) {
        Object object = this.synchronizeRootInfoNotifications;
        synchronized (object) {
            if (this.rootInfoNotifications != null && this.rootInfoNotifications.size() > 0) {
                Enumeration<RootInfoListener> enumeration = this.rootInfoNotifications.elements();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement().rootInfoOutOfDate(this);
                }
                return;
            }
        }
        if (!this.isAutoUpdateRootInfo()) {
            return;
        }
        if (this.updatingRootInfo) {
            return;
        }
        object = this.synchronizeUpdateLock;
        synchronized (object) {
            if (this.updatingRootInfo) {
                return;
            }
            this.updatingRootInfo = true;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Configuration.this.refreshRootInfoFromNet(resolver);
                }
                catch (Exception e) {
                    System.err.println("Error refreshing root info: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    private void refreshRootInfoFromNet(HandleResolver resolver) throws HandleException {
        try {
            if (!this.isAutoUpdateRootInfo()) {
                return;
            }
            this.updatingRootInfo = true;
            this.resolveVerifyUpdateAndPersistBootstrapHandles(resolver);
        }
        finally {
            this.updatingRootInfo = false;
        }
    }

    private void resolveVerifyUpdateAndPersistBootstrapHandles(HandleResolver resolver) throws HandleException {
        resolver.setCheckSignatures(true);
        HandleValue[] trustRoot = this.resolveHandleCertified(resolver, Common.TRUST_ROOT_HANDLE);
        HandleValue[] rootOfResolution = this.resolveHandleCertified(resolver, Common.ROOT_HANDLE);
        LinkedHashMap<String, HandleRecord> map = new LinkedHashMap<String, HandleRecord>();
        map.put("0.0/0.0", new HandleRecord("0.0/0.0", trustRoot));
        map.put("0.NA/0.NA", new HandleRecord("0.NA/0.NA", rootOfResolution));
        this.addServiceHandles(resolver, rootOfResolution, map);
        String preferredGlobalServiceHandle = this.getPreferredGlobalServiceHandle();
        if (preferredGlobalServiceHandle != null && !map.containsKey(preferredGlobalServiceHandle)) {
            HandleValue[] preferredGlobalServiceHandleValues = null;
            try {
                preferredGlobalServiceHandleValues = this.resolveHandleCertified(resolver, Util.encodeString(preferredGlobalServiceHandle));
            }
            catch (HandleException handleException) {
                // empty catch block
            }
            if (preferredGlobalServiceHandleValues != null) {
                map.put(preferredGlobalServiceHandle, new HandleRecord(preferredGlobalServiceHandle, preferredGlobalServiceHandleValues));
                this.addServiceHandles(resolver, preferredGlobalServiceHandleValues, map);
            }
        }
        ChainBuilder chainBuilder = new ChainBuilder(map, resolver);
        ChainVerifier chainVerifier = new ChainVerifier(this.getRootKeys());
        HandleRecordTrustVerifier handleRecordTrustVerifier = new HandleRecordTrustVerifier(chainBuilder, chainVerifier);
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            HandleRecord record = (HandleRecord)iter.next();
            boolean valid = handleRecordTrustVerifier.validateHandleRecord(record);
            if (valid) continue;
            if ("0.0/0.0".equals(record.getHandle()) || "0.NA/0.NA".equals(record.getHandle())) {
                System.err.println("Unable to validate root handles");
                return;
            }
            System.err.println("Unable to validate " + record.getHandle() + ", so it will not be used for global sites");
            iter.remove();
        }
        BootstrapHandles bootstrapHandles = new BootstrapHandles(map);
        Set<SiteInfo> sites = bootstrapHandles.getSites(null);
        List<PublicKey> rootKeys = Util.getPublicKeysFromValues(trustRoot);
        if (sites == null || sites.isEmpty()) {
            System.err.println("Unable to extract root site information");
        } else if (rootKeys == null || rootKeys.isEmpty()) {
            System.err.println("Unable to extract root key information");
        } else {
            this.setBootstrapHandles(bootstrapHandles);
            this.persist();
        }
    }

    private void addServiceHandles(HandleResolver resolver, HandleValue[] rootValues, Map<String, HandleRecord> map) {
        HandleValue[] serviceValues;
        for (HandleValue serviceValue : serviceValues = Util.filterValues(rootValues, null, Common.SERVICE_HANDLE_TYPES)) {
            String serviceHandle = serviceValue.getDataAsString();
            this.addServiceHandleRecursivelyToMap(resolver, serviceHandle, map, 1);
        }
    }

    private void addServiceHandleRecursivelyToMap(HandleResolver resolver, String handle, Map<String, HandleRecord> map, int depth) {
        HandleValue[] serviceValues;
        HandleValue[] values;
        if (map.containsKey(handle)) {
            return;
        }
        try {
            values = this.resolveHandleCertified(resolver, Util.encodeString(handle));
        }
        catch (HandleException e) {
            return;
        }
        if (values == null) {
            return;
        }
        map.put(handle, new HandleRecord(handle, values));
        if (depth >= 20) {
            return;
        }
        for (HandleValue serviceValue : serviceValues = Util.filterValues(values, null, Common.SERVICE_HANDLE_TYPES)) {
            String serviceHandle = serviceValue.getDataAsString();
            this.addServiceHandleRecursivelyToMap(resolver, serviceHandle, map, depth + 1);
        }
    }

    private HandleValue[] resolveHandleCertified(HandleResolver resolver, byte[] handle) throws HandleException {
        ResolutionRequest req = new ResolutionRequest(handle, null, null, null);
        req.certify = true;
        AbstractResponse resp = resolver.processRequest(req);
        if (resp.responseCode != 1) {
            throw new HandleException(1, "Unable to query root info");
        }
        HandleValue[] handleValues = ((ResolutionResponse)resp).getHandleValues();
        return handleValues;
    }

    public void checkRootInfoUpToDate(HandleResolver resolver, String handle, HandleValue[] handleValues) {
        HandleValue[] knownValues;
        if (!this.isAutoUpdateRootInfo()) {
            return;
        }
        try {
            knownValues = this.getBootstrapHandles().handles.get(handle).getValuesAsArray();
        }
        catch (Exception e) {
            return;
        }
        if (HandleValue.unorderedEquals(handleValues, knownValues)) {
            return;
        }
        this.notifyRootInfoOutdated(resolver);
    }

    public boolean isBootstrapHandlesOld() {
        long now;
        BootstrapHandles bootstrapHandles = this.getBootstrapHandles();
        long lastUpdate = 0L;
        if (bootstrapHandles != null) {
            lastUpdate = bootstrapHandles.lastUpdate;
        }
        return (now = System.currentTimeMillis()) - lastUpdate > 82800000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBootstrapHandlesIfOld(final HandleResolver resolver) {
        if (!this.isAutoUpdateRootInfo()) {
            return;
        }
        if (!this.isBootstrapHandlesOld()) {
            return;
        }
        if (this.updatingRootInfo) {
            return;
        }
        Object object = this.synchronizeUpdateLock;
        synchronized (object) {
            if (this.updatingRootInfo) {
                return;
            }
            this.updatingRootInfo = true;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Configuration.this.refreshRootInfoFromNet(resolver);
                }
                catch (Exception e) {
                    System.err.println("Error refreshing root info: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAutoUpdate(final HandleResolver resolver) {
        if (this.startedAutoUpdate) {
            return;
        }
        Object object = this.synchronizeUpdateLock;
        synchronized (object) {
            if (this.startedAutoUpdate) {
                return;
            }
            this.startedAutoUpdate = true;
        }
        if (!this.isAutoUpdateRootInfo()) {
            return;
        }
        new Timer("resolver-config-auto-update", true).schedule(new TimerTask(){

            @Override
            public void run() {
                Configuration.this.updateBootstrapHandlesIfOld(resolver);
            }
        }, 0L, 86400000L);
    }
}

